/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.items;

import java.util.List;
import java.util.function.Consumer;
import net.dries007.tfc.client.TFCSounds;
import net.dries007.tfc.client.render.blockentity.PanItemRenderer;
import net.dries007.tfc.common.items.TFCItems;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.Pannable;
import net.dries007.tfc.util.loot.TFCLoot;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraftforge.client.IItemRenderProperties;
import net.minecraftforge.common.util.NonNullLazy;
import net.minecraftforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.Nullable;

public class PanItem
extends Item {
    public static final int USE_TIME = 120;

    @Nullable
    public static BlockState readState(ItemStack stack) {
        CompoundTag tag = stack.m_41737_("state");
        if (tag != null) {
            return NbtUtils.m_129241_((CompoundTag)tag);
        }
        return null;
    }

    @Nullable
    public static Pannable readPannable(ItemStack stack) {
        BlockState state = PanItem.readState(stack);
        if (state != null) {
            return Pannable.get(state);
        }
        return null;
    }

    @Deprecated(forRemoval=true)
    public static void dropItems(ServerLevel level, BlockState state, BlockPos pos) {
        Helpers.dropWithContext(level, state, pos, ctx -> ctx.m_78972_(TFCLoot.PANNED, (Object)true), false);
    }

    public PanItem(Item.Properties properties) {
        super(properties);
    }

    public int m_8105_(ItemStack stack) {
        return 120;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        if (hand == InteractionHand.OFF_HAND) {
            return InteractionResultHolder.m_19098_((Object)player.m_21120_(hand));
        }
        if (Helpers.isFluid(level.m_6425_(player.m_142538_()), (TagKey<Fluid>)FluidTags.f_13131_)) {
            return ItemUtils.m_150959_((Level)level, (Player)player, (InteractionHand)hand);
        }
        if (!level.f_46443_) {
            player.m_5661_((Component)Helpers.translatable("tfc.tooltip.pan.water"), true);
        }
        return super.m_7203_(level, player, hand);
    }

    public void m_5929_(Level level, LivingEntity entity, ItemStack stack, int countLeft) {
        if (countLeft % 16 == 0 && !level.f_46443_) {
            level.m_6269_(null, (Entity)entity, (SoundEvent)TFCSounds.PANNING.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
        }
    }

    public ItemStack m_5922_(ItemStack stack, Level level, LivingEntity entity) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                Pannable pannable = PanItem.readPannable(stack);
                if (pannable != null) {
                    LootTable table = level.m_142572_().m_129898_().m_79217_(pannable.getLootTable());
                    LootContext.Builder builder = new LootContext.Builder(serverLevel).m_78977_(level.f_46441_).m_78972_(LootContextParams.f_81455_, (Object)entity).m_78972_(LootContextParams.f_81460_, (Object)entity.m_20182_()).m_78972_(LootContextParams.f_81463_, (Object)stack);
                    List items = table.m_79129_(builder.m_78975_(LootContextParamSets.f_81414_));
                    items.forEach(item -> ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)item));
                    player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
                    return new ItemStack((ItemLike)TFCItems.EMPTY_PAN.get());
                }
            }
        }
        return stack;
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> text, TooltipFlag flag) {
        BlockState state = PanItem.readState(stack);
        if (state != null) {
            text.add((Component)Helpers.translatable("tfc.tooltip.pan.contents").m_7220_((Component)state.m_60734_().m_49954_()));
        }
    }

    public void initializeClient(Consumer<IItemRenderProperties> consumer) {
        consumer.accept(new IItemRenderProperties(){
            private final NonNullLazy<PanItemRenderer> renderer = NonNullLazy.of(PanItemRenderer::new);

            public BlockEntityWithoutLevelRenderer getItemStackRenderer() {
                return (BlockEntityWithoutLevelRenderer)this.renderer.get();
            }
        });
    }
}

