/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.entities;

import javax.annotation.Nullable;
import net.dries007.tfc.client.TFCSounds;
import net.dries007.tfc.common.entities.TFCEntities;
import net.dries007.tfc.util.advancements.TFCAdvancements;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;

public class ThrownJavelin
extends AbstractArrow {
    private static final EntityDataAccessor<Boolean> DATA_ENCHANT_GLOW = SynchedEntityData.m_135353_(ThrownJavelin.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<ItemStack> DATA_ITEM = SynchedEntityData.m_135353_(ThrownJavelin.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
    private boolean dealtDamage = false;

    public ThrownJavelin(EntityType<? extends ThrownJavelin> type, Level level) {
        super(type, level);
    }

    public ThrownJavelin(Level level, LivingEntity entity, ItemStack stack) {
        this((EntityType<? extends ThrownJavelin>)((EntityType)TFCEntities.THROWN_JAVELIN.get()), level, entity, stack);
    }

    public ThrownJavelin(EntityType<? extends ThrownJavelin> type, Level level, LivingEntity entity, ItemStack stack) {
        super(type, entity, level);
        this.setItem(stack);
        this.setIsEnchantGlowing(stack.m_41790_());
    }

    public void m_8119_() {
        if (this.f_36704_ > 4) {
            this.dealtDamage = true;
        }
        super.m_8119_();
    }

    protected boolean m_142470_(Player player) {
        return super.m_142470_(player) || this.m_36797_() && this.m_150171_((Entity)player) && player.m_150109_().m_36054_(this.m_7941_());
    }

    public void m_6901_() {
        if (this.f_36705_ != AbstractArrow.Pickup.ALLOWED) {
            super.m_6901_();
        }
    }

    public boolean m_6000_(double x, double y, double z) {
        return true;
    }

    @Nullable
    protected EntityHitResult m_6351_(Vec3 pos1, Vec3 pos2) {
        return this.dealtDamage ? null : super.m_6351_(pos1, pos2);
    }

    protected void m_5790_(EntityHitResult result) {
        Entity hitEntity = result.m_82443_();
        float damage = this.getItemAttackDamage();
        if (hitEntity instanceof LivingEntity) {
            LivingEntity livingentity = (LivingEntity)hitEntity;
            damage += EnchantmentHelper.m_44833_((ItemStack)this.getItem(), (MobType)livingentity.m_6336_());
        }
        Entity owner = this.m_37282_();
        this.dealtDamage = true;
        if (hitEntity.m_6469_(DamageSource.m_19337_((Entity)this, (Entity)(owner == null ? this : owner)), damage)) {
            if (hitEntity.m_6095_() == EntityType.f_20566_) {
                return;
            }
            if (hitEntity instanceof LivingEntity) {
                LivingEntity livingVictim = (LivingEntity)hitEntity;
                if (owner instanceof LivingEntity) {
                    LivingEntity livingOwner = (LivingEntity)owner;
                    EnchantmentHelper.m_44823_((LivingEntity)livingVictim, (Entity)owner);
                    EnchantmentHelper.m_44896_((LivingEntity)livingOwner, (Entity)livingVictim);
                }
                this.m_7761_(livingVictim);
            }
            if (owner instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)owner;
                TFCAdvancements.STAB_ENTITY.trigger(serverPlayer, hitEntity);
            }
        }
        this.m_20256_(this.m_20184_().m_82542_(-0.01, -0.1, -0.01));
        this.m_5496_((SoundEvent)TFCSounds.JAVELIN_HIT.get(), 1.0f, 1.0f);
    }

    protected float m_6882_() {
        return 0.99f;
    }

    public SoundEvent m_7239_() {
        return (SoundEvent)TFCSounds.JAVELIN_HIT_GROUND.get();
    }

    public float getItemAttackDamage() {
        float f;
        Item item = this.getItem().m_41720_();
        if (item instanceof SwordItem) {
            SwordItem javelin = (SwordItem)item;
            f = javelin.m_43299_() * 1.1f;
        } else {
            f = 8.0f;
        }
        return f;
    }

    public ItemStack m_7941_() {
        return this.getItem().m_41777_();
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        if (tag.m_128425_("item", 10)) {
            this.setItem(ItemStack.m_41712_((CompoundTag)tag.m_128469_("item")));
            this.setIsEnchantGlowing(tag.m_128471_("glow"));
        }
        this.dealtDamage = tag.m_128471_("dealtDamage");
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        if (!this.getItem().m_41619_()) {
            tag.m_128365_("item", (Tag)this.getItem().m_41739_(new CompoundTag()));
            tag.m_128379_("glow", this.isEnchantGlowing());
        }
        tag.m_128379_("dealtDamage", this.dealtDamage);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_ENCHANT_GLOW, (Object)false);
        this.f_19804_.m_135372_(DATA_ITEM, (Object)ItemStack.f_41583_);
    }

    public ItemStack getItem() {
        return (ItemStack)this.f_19804_.m_135370_(DATA_ITEM);
    }

    public void setItem(ItemStack item) {
        this.f_19804_.m_135381_(DATA_ITEM, (Object)item.m_41777_());
    }

    public boolean isEnchantGlowing() {
        return (Boolean)this.f_19804_.m_135370_(DATA_ENCHANT_GLOW);
    }

    public void setIsEnchantGlowing(boolean glow) {
        this.f_19804_.m_135381_(DATA_ENCHANT_GLOW, (Object)glow);
    }
}

