/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.entities;

import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blocks.rock.IFallableBlock;
import net.dries007.tfc.common.entities.TFCEntities;
import net.dries007.tfc.common.fluids.FluidHelpers;
import net.dries007.tfc.mixin.accessor.FallingBlockEntityAccessor;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.LegacyMaterials;
import net.dries007.tfc.util.tracker.WorldTrackerCapability;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.DirectionalPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class TFCFallingBlockEntity
extends FallingBlockEntity {
    private final boolean dontSetBlock;
    private boolean failedBreakCheck = false;

    public static boolean canFallThrough(BlockGetter world, BlockPos pos, BlockState state) {
        return !state.m_60783_(world, pos, Direction.UP);
    }

    public static boolean canFallInDirection(BlockGetter level, BlockPos pos, Direction fallingDirection) {
        BlockPos fallThroughPos = pos.m_142300_(fallingDirection);
        return TFCFallingBlockEntity.canFallThrough(level, fallThroughPos, level.m_8055_(fallThroughPos), fallingDirection, level.m_8055_(pos));
    }

    public static boolean canFallThrough(BlockGetter level, BlockPos pos, Direction fallingDirection) {
        BlockState state = level.m_8055_(pos);
        return TFCFallingBlockEntity.canFallThrough(level, pos, state, fallingDirection, state);
    }

    public static boolean canFallThrough(BlockGetter level, BlockPos pos, Direction fallingDirection, BlockState fallingState) {
        return TFCFallingBlockEntity.canFallThrough(level, pos, level.m_8055_(pos), fallingDirection, fallingState);
    }

    public static boolean canFallThrough(BlockGetter level, BlockPos pos, BlockState state, Direction fallingDirection, BlockState fallingState) {
        return !state.m_60783_(level, pos, fallingDirection.m_122424_()) && TFCFallingBlockEntity.getBlockToughness(fallingState) >= TFCFallingBlockEntity.getBlockToughness(state) && state.m_60800_(level, pos) > -1.0f && !LegacyMaterials.isStructuralAir(state);
    }

    public static int getBlockToughness(BlockState state) {
        if (state.m_60734_() == Blocks.f_50752_) {
            return 4;
        }
        if (Helpers.isBlock(state, TFCTags.Blocks.TOUGHNESS_3)) {
            return 3;
        }
        if (Helpers.isBlock(state, TFCTags.Blocks.TOUGHNESS_2)) {
            return 2;
        }
        if (Helpers.isBlock(state, TFCTags.Blocks.TOUGHNESS_1)) {
            return 1;
        }
        return 0;
    }

    public TFCFallingBlockEntity(EntityType<? extends FallingBlockEntity> entityType, Level level) {
        super(entityType, level);
        this.dontSetBlock = false;
    }

    public TFCFallingBlockEntity(Level level, double x, double y, double z, BlockState fallingBlockState, float damagePerBlockFallen, int maximumFallDamage) {
        this(level, x, y, z, fallingBlockState);
        this.m_149656_(damagePerBlockFallen, maximumFallDamage);
    }

    public TFCFallingBlockEntity(Level level, double x, double y, double z, BlockState fallingBlockState) {
        this((EntityType<? extends FallingBlockEntity>)((EntityType)TFCEntities.FALLING_BLOCK.get()), level);
        ((FallingBlockEntityAccessor)((Object)this)).setBlockState(fallingBlockState);
        this.f_19850_ = true;
        this.m_6034_(x, y, z);
        this.m_20256_(Vec3.f_82478_);
        this.f_19854_ = x;
        this.f_19855_ = y;
        this.f_19856_ = z;
        this.m_31959_(this.m_142538_());
    }

    public void m_8119_() {
        BlockState fallingBlockState = this.m_31980_();
        if (fallingBlockState.m_60795_()) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        } else {
            Block block = fallingBlockState.m_60734_();
            if (this.f_31942_++ == 0) {
                BlockPos blockpos = this.m_142538_();
                if (block == this.f_19853_.m_8055_(blockpos).m_60734_()) {
                    this.f_19853_.m_7471_(blockpos, false);
                } else if (!this.f_19853_.f_46443_) {
                    this.m_142687_(Entity.RemovalReason.DISCARDED);
                }
                return;
            }
            if (!this.m_20068_()) {
                this.m_20256_(this.m_20184_().m_82520_(0.0, -0.04, 0.0));
            }
            this.m_6478_(MoverType.SELF, this.m_20184_());
            if (!this.f_19853_.f_46443_) {
                BlockPos posAt = this.m_142538_();
                if (!this.f_19861_) {
                    this.failedBreakCheck = false;
                    if (this.f_31942_ > 100 && (posAt.m_123342_() < 1 || posAt.m_123342_() > 256) || this.f_31942_ > 600) {
                        if (this.f_31943_ && this.f_19853_.m_46469_().m_46207_(GameRules.f_46137_)) {
                            this.m_19998_((ItemLike)block);
                        }
                        this.m_142687_(Entity.RemovalReason.DISCARDED);
                    }
                } else {
                    if (!this.failedBreakCheck) {
                        if (!FluidHelpers.isAirOrEmptyFluid(this.f_19853_.m_8055_(posAt)) && TFCFallingBlockEntity.canFallThrough((BlockGetter)this.f_19853_, posAt, Direction.DOWN, fallingBlockState)) {
                            this.f_19853_.m_46961_(posAt, true);
                            this.failedBreakCheck = true;
                            return;
                        }
                        if (!FluidHelpers.isAirOrEmptyFluid(this.f_19853_.m_8055_(posAt.m_7495_())) && TFCFallingBlockEntity.canFallThrough((BlockGetter)this.f_19853_, posAt.m_7495_(), Direction.DOWN, fallingBlockState)) {
                            this.f_19853_.m_46961_(posAt.m_7495_(), true);
                            this.failedBreakCheck = true;
                            return;
                        }
                    }
                    BlockState hitBlockState = this.f_19853_.m_8055_(posAt);
                    this.m_20256_(this.m_20184_().m_82542_(0.7, -0.5, 0.7));
                    if (hitBlockState.m_60734_() != Blocks.f_50110_) {
                        this.m_142687_(Entity.RemovalReason.DISCARDED);
                        if (!this.dontSetBlock) {
                            if (this.canPlaceAt(hitBlockState, posAt, fallingBlockState, fallingBlockState)) {
                                this.placeAsBlockOrDropAsItem(hitBlockState, posAt, fallingBlockState);
                            } else {
                                BlockPos posAbove = posAt.m_7494_();
                                BlockState hitAboveBlockState = this.f_19853_.m_8055_(posAbove);
                                if (this.canPlaceAt(hitAboveBlockState, posAbove, fallingBlockState, Blocks.f_50752_.m_49966_())) {
                                    this.placeAsBlockOrDropAsItem(hitAboveBlockState, posAbove, fallingBlockState);
                                } else {
                                    this.attemptToDropAsItem(fallingBlockState);
                                }
                            }
                        }
                        if (block instanceof IFallableBlock) {
                            IFallableBlock fallingBlock = (IFallableBlock)block;
                            fallingBlock.onceFinishedFalling(this.f_19853_, posAt, this);
                        }
                    }
                }
            }
            this.m_20256_(this.m_20184_().m_82490_(0.98));
        }
    }

    private boolean canPlaceAt(BlockState hitBlockState, BlockPos posAt, BlockState fallingBlockState, BlockState toughnessBlockState) {
        BlockPos below = posAt.m_7495_();
        return hitBlockState.m_60629_((BlockPlaceContext)new DirectionalPlaceContext(this.f_19853_, posAt, Direction.DOWN, ItemStack.f_41583_, Direction.UP)) && fallingBlockState.m_60710_((LevelReader)this.f_19853_, posAt) && !TFCFallingBlockEntity.canFallThrough((BlockGetter)this.f_19853_, below, Direction.DOWN, toughnessBlockState);
    }

    private void placeAsBlockOrDropAsItem(BlockState hitBlockState, BlockPos posAt, BlockState fallingBlockState) {
        if (this.f_19853_.m_46597_(posAt, fallingBlockState)) {
            this.afterPlacementAsBlock(hitBlockState, posAt, fallingBlockState);
        } else {
            this.attemptToDropAsItem(fallingBlockState);
        }
    }

    private void afterPlacementAsBlock(BlockState hitBlockState, BlockPos posAt, BlockState fallingBlockState) {
        BlockEntity tileEntity;
        Block block = fallingBlockState.m_60734_();
        if (block instanceof FallingBlock) {
            FallingBlock fallingBlock = (FallingBlock)block;
            fallingBlock.m_142216_(this.f_19853_, posAt, fallingBlockState, hitBlockState, (FallingBlockEntity)this);
        }
        if (Helpers.isBlock(fallingBlockState.m_60734_(), TFCTags.Blocks.CAN_LANDSLIDE)) {
            this.f_19853_.getCapability(WorldTrackerCapability.CAPABILITY).ifPresent(cap -> cap.addLandslidePos(posAt));
        }
        if (this.f_31944_ != null && fallingBlockState.m_155947_() && (tileEntity = this.f_19853_.m_7702_(posAt)) != null) {
            CompoundTag tileEntityData = tileEntity.m_187482_();
            for (String dataKey : tileEntityData.m_128431_()) {
                Tag dataElement = tileEntityData.m_128423_(dataKey);
                if ("x".equals(dataKey) || "y".equals(dataKey) || "z".equals(dataKey) || dataElement == null) continue;
                tileEntityData.m_128365_(dataKey, dataElement.m_6426_());
            }
            tileEntity.m_142466_(tileEntityData);
            tileEntity.m_6596_();
        }
    }

    private void attemptToDropAsItem(BlockState fallingBlockState) {
        if (this.f_31943_ && this.f_19853_.m_46469_().m_46207_(GameRules.f_46137_)) {
            this.m_19998_((ItemLike)fallingBlockState.m_60734_());
        }
    }
}

