/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.capabilities.forge;

import net.dries007.tfc.common.capabilities.forge.ForgeStep;
import net.dries007.tfc.common.capabilities.forge.ForgeSteps;
import net.dries007.tfc.util.Helpers;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.Nullable;

public final class ForgeRule
extends Enum<ForgeRule> {
    public static final /* enum */ ForgeRule HIT_ANY = new ForgeRule(Order.ANY, ForgeStep.HIT_LIGHT);
    public static final /* enum */ ForgeRule HIT_NOT_LAST = new ForgeRule(Order.NOT_LAST, ForgeStep.HIT_LIGHT);
    public static final /* enum */ ForgeRule HIT_LAST = new ForgeRule(Order.LAST, ForgeStep.HIT_LIGHT);
    public static final /* enum */ ForgeRule HIT_SECOND_LAST = new ForgeRule(Order.SECOND_LAST, ForgeStep.HIT_LIGHT);
    public static final /* enum */ ForgeRule HIT_THIRD_LAST = new ForgeRule(Order.THIRD_LAST, ForgeStep.HIT_LIGHT);
    public static final /* enum */ ForgeRule DRAW_ANY = new ForgeRule(Order.ANY, ForgeStep.DRAW);
    public static final /* enum */ ForgeRule DRAW_LAST = new ForgeRule(Order.LAST, ForgeStep.DRAW);
    public static final /* enum */ ForgeRule DRAW_NOT_LAST = new ForgeRule(Order.NOT_LAST, ForgeStep.DRAW);
    public static final /* enum */ ForgeRule DRAW_SECOND_LAST = new ForgeRule(Order.SECOND_LAST, ForgeStep.DRAW);
    public static final /* enum */ ForgeRule DRAW_THIRD_LAST = new ForgeRule(Order.THIRD_LAST, ForgeStep.DRAW);
    public static final /* enum */ ForgeRule PUNCH_ANY = new ForgeRule(Order.ANY, ForgeStep.PUNCH);
    public static final /* enum */ ForgeRule PUNCH_LAST = new ForgeRule(Order.LAST, ForgeStep.PUNCH);
    public static final /* enum */ ForgeRule PUNCH_NOT_LAST = new ForgeRule(Order.NOT_LAST, ForgeStep.PUNCH);
    public static final /* enum */ ForgeRule PUNCH_SECOND_LAST = new ForgeRule(Order.SECOND_LAST, ForgeStep.PUNCH);
    public static final /* enum */ ForgeRule PUNCH_THIRD_LAST = new ForgeRule(Order.THIRD_LAST, ForgeStep.PUNCH);
    public static final /* enum */ ForgeRule BEND_ANY = new ForgeRule(Order.ANY, ForgeStep.BEND);
    public static final /* enum */ ForgeRule BEND_LAST = new ForgeRule(Order.LAST, ForgeStep.BEND);
    public static final /* enum */ ForgeRule BEND_NOT_LAST = new ForgeRule(Order.NOT_LAST, ForgeStep.BEND);
    public static final /* enum */ ForgeRule BEND_SECOND_LAST = new ForgeRule(Order.SECOND_LAST, ForgeStep.BEND);
    public static final /* enum */ ForgeRule BEND_THIRD_LAST = new ForgeRule(Order.THIRD_LAST, ForgeStep.BEND);
    public static final /* enum */ ForgeRule UPSET_ANY = new ForgeRule(Order.ANY, ForgeStep.UPSET);
    public static final /* enum */ ForgeRule UPSET_LAST = new ForgeRule(Order.LAST, ForgeStep.UPSET);
    public static final /* enum */ ForgeRule UPSET_NOT_LAST = new ForgeRule(Order.NOT_LAST, ForgeStep.UPSET);
    public static final /* enum */ ForgeRule UPSET_SECOND_LAST = new ForgeRule(Order.SECOND_LAST, ForgeStep.UPSET);
    public static final /* enum */ ForgeRule UPSET_THIRD_LAST = new ForgeRule(Order.THIRD_LAST, ForgeStep.UPSET);
    public static final /* enum */ ForgeRule SHRINK_ANY = new ForgeRule(Order.ANY, ForgeStep.SHRINK);
    public static final /* enum */ ForgeRule SHRINK_LAST = new ForgeRule(Order.LAST, ForgeStep.SHRINK);
    public static final /* enum */ ForgeRule SHRINK_NOT_LAST = new ForgeRule(Order.NOT_LAST, ForgeStep.SHRINK);
    public static final /* enum */ ForgeRule SHRINK_SECOND_LAST = new ForgeRule(Order.SECOND_LAST, ForgeStep.SHRINK);
    public static final /* enum */ ForgeRule SHRINK_THIRD_LAST = new ForgeRule(Order.THIRD_LAST, ForgeStep.SHRINK);
    private static final ForgeRule[] VALUES;
    private final Order order;
    private final ForgeStep type;
    private static final /* synthetic */ ForgeRule[] $VALUES;

    public static ForgeRule[] values() {
        return (ForgeRule[])$VALUES.clone();
    }

    public static ForgeRule valueOf(String name) {
        return Enum.valueOf(ForgeRule.class, name);
    }

    @Nullable
    public static ForgeRule valueOf(int id) {
        return id >= 0 && id < VALUES.length ? VALUES[id] : null;
    }

    public static boolean isConsistent(ForgeRule ... rules) {
        if (rules.length == 0 || rules.length > 3) {
            return false;
        }
        ForgeRule last = null;
        ForgeRule secondLast = null;
        ForgeRule thirdLast = null;
        ForgeRule notLast1 = null;
        ForgeRule notLast2 = null;
        block6: for (ForgeRule rule : rules) {
            if (rule == last || rule == secondLast || rule == thirdLast || rule == notLast1 || rule == notLast2) continue;
            switch (rule.order) {
                case THIRD_LAST: {
                    if (thirdLast != null) {
                        return false;
                    }
                    thirdLast = rule;
                    continue block6;
                }
                case SECOND_LAST: {
                    if (secondLast != null) {
                        return false;
                    }
                    secondLast = rule;
                    continue block6;
                }
                case LAST: {
                    if (last != null) {
                        return false;
                    }
                    last = rule;
                    continue block6;
                }
                case NOT_LAST: {
                    if (notLast2 != null) {
                        return false;
                    }
                    notLast2 = notLast1;
                    notLast1 = rule;
                }
            }
        }
        return ForgeRule.conflict3(notLast1, secondLast, thirdLast) && ForgeRule.conflict3(secondLast, notLast1, notLast2) && ForgeRule.conflict3(thirdLast, notLast1, notLast2);
    }

    private static boolean conflict3(@Nullable ForgeRule rule1, @Nullable ForgeRule rule2, @Nullable ForgeRule rule3) {
        return rule1 == null || rule2 == null || rule3 == null || rule1.type == rule2.type || rule1.type == rule3.type;
    }

    public static int calculateOptimalStepsToTarget(int target, ForgeRule ... rules) {
        ForgeRule[] lastSteps = new ForgeRule[]{null, null, null};
        block5: for (ForgeRule rule : rules) {
            switch (rule.order) {
                case LAST: {
                    lastSteps[0] = rule;
                    continue block5;
                }
                case SECOND_LAST: {
                    lastSteps[1] = rule;
                    continue block5;
                }
                case THIRD_LAST: {
                    lastSteps[2] = rule;
                }
            }
        }
        block6: for (ForgeRule rule : rules) {
            int i;
            if (rule.order != Order.NOT_LAST && rule.order != Order.ANY) continue;
            boolean placed = false;
            for (i = 2; i >= 0; --i) {
                if (lastSteps[i] == null || lastSteps[i].type != rule.type || rule.order != Order.ANY && i <= 0) continue;
                lastSteps[i] = rule;
                placed = true;
                break;
            }
            if (placed) continue;
            for (i = 2; i >= 0; --i) {
                if (lastSteps[i] != null) continue;
                lastSteps[i] = rule;
                continue block6;
            }
        }
        int requiredSteps = 0;
        int requiredHits = 0;
        for (ForgeRule rule : lastSteps) {
            if (rule == null) continue;
            ++requiredSteps;
            target -= rule.type.step();
            if (rule.type != ForgeStep.HIT_LIGHT) continue;
            ++requiredHits;
        }
        int minimumSteps = ForgeStep.getOptimalStepsToTarget(target);
        for (int hit = 0; hit < requiredHits * 2; ++hit) {
            minimumSteps = Math.min(minimumSteps, ForgeStep.getOptimalStepsToTarget(target -= ForgeStep.HIT_LIGHT.step()));
        }
        return requiredSteps + minimumSteps;
    }

    public static ForgeRule fromNetwork(FriendlyByteBuf buffer) {
        ForgeRule rule = ForgeRule.valueOf(buffer.readByte());
        return rule == null ? HIT_ANY : rule;
    }

    private ForgeRule(Order order, ForgeStep type) {
        this.order = order;
        this.type = type;
        assert (type != ForgeStep.HIT_MEDIUM && type != ForgeStep.HIT_HARD);
    }

    public void toNetwork(FriendlyByteBuf buffer) {
        buffer.writeByte(this.ordinal());
    }

    public int iconX() {
        return this.type == ForgeStep.HIT_LIGHT ? 218 : this.type.iconX();
    }

    public int iconY() {
        return this.type == ForgeStep.HIT_LIGHT ? 18 : this.type.iconY();
    }

    public int overlayY() {
        return this.order.y;
    }

    public boolean matches(ForgeSteps steps) {
        return switch (this.order) {
            default -> throw new IncompatibleClassChangeError();
            case Order.ANY -> {
                if (this.matches(steps.last()) || this.matches(steps.secondLast()) || this.matches(steps.thirdLast())) {
                    yield true;
                }
                yield false;
            }
            case Order.NOT_LAST -> {
                if (this.matches(steps.secondLast()) || this.matches(steps.thirdLast())) {
                    yield true;
                }
                yield false;
            }
            case Order.LAST -> this.matches(steps.last());
            case Order.SECOND_LAST -> this.matches(steps.secondLast());
            case Order.THIRD_LAST -> this.matches(steps.thirdLast());
        };
    }

    public Component getDescriptionId() {
        return (this.type == ForgeStep.HIT_LIGHT ? Helpers.translatable("tfc.enum.forgestep.hit") : Helpers.translateEnum(this.type)).m_130946_(" ").m_7220_((Component)Helpers.translateEnum(this.order));
    }

    private boolean matches(@Nullable ForgeStep step) {
        if (this.type == ForgeStep.HIT_LIGHT) {
            return step == ForgeStep.HIT_LIGHT || step == ForgeStep.HIT_MEDIUM || step == ForgeStep.HIT_HARD;
        }
        return this.type == step;
    }

    private static /* synthetic */ ForgeRule[] $values() {
        return new ForgeRule[]{HIT_ANY, HIT_NOT_LAST, HIT_LAST, HIT_SECOND_LAST, HIT_THIRD_LAST, DRAW_ANY, DRAW_LAST, DRAW_NOT_LAST, DRAW_SECOND_LAST, DRAW_THIRD_LAST, PUNCH_ANY, PUNCH_LAST, PUNCH_NOT_LAST, PUNCH_SECOND_LAST, PUNCH_THIRD_LAST, BEND_ANY, BEND_LAST, BEND_NOT_LAST, BEND_SECOND_LAST, BEND_THIRD_LAST, UPSET_ANY, UPSET_LAST, UPSET_NOT_LAST, UPSET_SECOND_LAST, UPSET_THIRD_LAST, SHRINK_ANY, SHRINK_LAST, SHRINK_NOT_LAST, SHRINK_SECOND_LAST, SHRINK_THIRD_LAST};
    }

    static {
        $VALUES = ForgeRule.$values();
        VALUES = ForgeRule.values();
        assert (VALUES.length < 127);
    }

    private static enum Order {
        ANY(88),
        LAST(0),
        NOT_LAST(66),
        SECOND_LAST(22),
        THIRD_LAST(44);

        private final int y;

        private Order(int y) {
            this.y = y;
        }
    }
}

