/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks.plant.coral;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Map;
import net.dries007.tfc.common.blocks.plant.coral.TFCCoralPlantBlock;
import net.dries007.tfc.common.fluids.FluidHelpers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class CoralWallFanBlock
extends TFCCoralPlantBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    private static final Map<Direction, VoxelShape> SHAPES = Maps.newEnumMap((Map)ImmutableMap.of((Object)Direction.NORTH, (Object)Block.m_49796_((double)0.0, (double)4.0, (double)5.0, (double)16.0, (double)12.0, (double)16.0), (Object)Direction.SOUTH, (Object)Block.m_49796_((double)0.0, (double)4.0, (double)0.0, (double)16.0, (double)12.0, (double)11.0), (Object)Direction.WEST, (Object)Block.m_49796_((double)5.0, (double)4.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0), (Object)Direction.EAST, (Object)Block.m_49796_((double)0.0, (double)4.0, (double)0.0, (double)11.0, (double)12.0, (double)16.0)));

    public CoralWallFanBlock(BlockBehaviour.Properties builder) {
        super(Shapes.m_83040_(), builder);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    @Override
    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        Direction[] directions;
        BlockState state = super.m_5573_(context);
        if (state == null) {
            return null;
        }
        Level level = context.m_43725_();
        BlockPos pos = context.m_8083_();
        for (Direction d : directions = context.m_6232_()) {
            if (!d.m_122434_().m_122479_() || !(state = (BlockState)state.m_61124_((Property)FACING, (Comparable)d.m_122424_())).m_60710_((LevelReader)level, pos)) continue;
            return state;
        }
        return null;
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_((StateDefinition.Builder<Block, BlockState>)builder.m_61104_(new Property[]{FACING}));
    }

    @Override
    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        FluidHelpers.tickFluid(level, currentPos, state);
        return facing.m_122424_() == state.m_61143_((Property)FACING) && !state.m_60710_((LevelReader)level, currentPos) ? Blocks.f_50016_.m_49966_() : state;
    }

    @Override
    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        Direction direction = (Direction)state.m_61143_((Property)FACING);
        BlockPos blockpos = pos.m_142300_(direction.m_122424_());
        BlockState blockstate = level.m_8055_(blockpos);
        return blockstate.m_60783_((BlockGetter)level, blockpos, direction);
    }

    @Override
    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPES.get(state.m_61143_((Property)FACING));
    }
}

