/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks.plant;

import java.util.Random;
import java.util.function.BiPredicate;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blocks.rock.LooseRockBlock;
import net.dries007.tfc.common.fluids.FluidHelpers;
import net.dries007.tfc.config.TFCConfig;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.calendar.Calendars;
import net.dries007.tfc.util.calendar.Season;
import net.dries007.tfc.util.climate.Climate;
import net.dries007.tfc.world.chunkdata.ChunkData;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import org.jetbrains.annotations.Nullable;

public final class PlantRegrowth {
    public static boolean canSpread(Level level, Random random) {
        return (double)random.nextFloat() < (Double)TFCConfig.SERVER.plantSpreadChance.get() && Calendars.get((LevelReader)level).getCalendarMonthOfYear().getSeason() != Season.WINTER;
    }

    @Nullable
    public static BlockPos spreadSelf(BlockState state, ServerLevel level, BlockPos pos, Random random, int selfSpreadRange, int radius, int maxPlants) {
        return PlantRegrowth.spreadSelf(state, level, pos, random, selfSpreadRange, radius, maxPlants, (s, p) -> Helpers.isBlock(s, TFCTags.Blocks.PLANTS), (s, p) -> s.m_60795_());
    }

    @Nullable
    public static BlockPos spreadSelf(BlockState state, ServerLevel level, BlockPos pos, Random random, int selfSpreadRange, int radius, int maxPlants, BiPredicate<BlockState, BlockPos> occlusionTest, BiPredicate<BlockState, BlockPos> placementTest) {
        BlockPos newPos = pos.m_142082_(Mth.m_14072_((Random)random, (int)0, (int)selfSpreadRange), 0, Mth.m_14072_((Random)random, (int)0, (int)selfSpreadRange));
        if (newPos.equals((Object)pos)) {
            newPos = pos.m_142082_(Mth.m_14072_((Random)random, (int)1, (int)selfSpreadRange), 0, Mth.m_14072_((Random)random, (int)1, (int)selfSpreadRange));
        }
        if ((state = FluidHelpers.fillWithFluid(state, level.m_6425_(newPos).m_76152_())) != null && placementTest.test(level.m_8055_(newPos), newPos) && state.m_60710_((LevelReader)level, newPos)) {
            int plants = 0;
            BlockPos.MutableBlockPos cursor = new BlockPos.MutableBlockPos();
            for (int x = -radius; x <= radius; ++x) {
                for (int z = -radius; z <= radius; ++z) {
                    cursor.m_122154_((Vec3i)newPos, x, 0, z);
                    if (!level.m_46749_((BlockPos)cursor)) {
                        return null;
                    }
                    if (!occlusionTest.test(level.m_8055_((BlockPos)cursor), (BlockPos)cursor) || plants++ <= maxPlants) continue;
                    return null;
                }
            }
            return newPos;
        }
        return null;
    }

    public static void placeRisingRock(ServerLevel level, BlockPos pos, Random random) {
        BlockState state;
        if ((double)random.nextFloat() > (Double)TFCConfig.SERVER.grassSpawningRocksChance.get() || Calendars.SERVER.getCalendarMonthOfYear().getSeason() != Season.SPRING || Climate.getAverageTemperature((Level)level, pos) > 8.0f || !level.isAreaLoaded(pos, 2) || PlantRegrowth.hasPlayerNearby(level, pos, 20)) {
            return;
        }
        ChunkPos chunkPos = new ChunkPos(pos);
        if (WorldgenRandom.m_64685_((int)chunkPos.f_45578_, (int)chunkPos.f_45579_, (long)level.m_7328_(), (long)6942069420L).nextInt(5) != 0) {
            return;
        }
        BlockState currentState = level.m_8055_(pos);
        boolean isInAir = currentState.m_60795_();
        boolean isInSelf = currentState.m_60734_() instanceof LooseRockBlock;
        if (!isInSelf && !isInAir) {
            return;
        }
        if (isInAir) {
            ChunkData data = ChunkData.get((LevelReader)level, pos);
            state = data.getRockData().getRock(pos).loose().map(Block::m_49966_).orElse(null);
            if (state == null) {
                return;
            }
            if ((state = FluidHelpers.fillWithFluid(state, level.m_6425_(pos).m_76152_())) == null || !state.m_60710_((LevelReader)level, pos)) {
                return;
            }
        } else if ((Integer)currentState.m_61143_((Property)LooseRockBlock.COUNT) < 3) {
            state = (BlockState)currentState.m_61122_((Property)LooseRockBlock.COUNT);
        } else {
            return;
        }
        BlockPos.MutableBlockPos cursor = new BlockPos.MutableBlockPos();
        for (int x = -2; x <= 2; ++x) {
            for (int z = -2; z <= 2; ++z) {
                cursor.m_122154_((Vec3i)pos, x, 0, z);
                if (!(level.m_8055_((BlockPos)cursor).m_60734_() instanceof LooseRockBlock)) continue;
                return;
            }
        }
        level.m_46597_(pos, state);
    }

    private static boolean hasPlayerNearby(ServerLevel level, BlockPos pos, int range) {
        for (ServerPlayer player : level.m_6907_()) {
            if (!(player.m_20275_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_()) < (double)(range * range))) continue;
            return true;
        }
        return false;
    }
}

