/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks.plant;

import java.util.Random;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blocks.DirectionPropertyBlock;
import net.dries007.tfc.common.fluids.FluidHelpers;
import net.dries007.tfc.common.fluids.FluidProperty;
import net.dries007.tfc.common.fluids.IFluidLoggable;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;

public abstract class KelpTreeBlock
extends PipeBlock
implements IFluidLoggable {
    public static KelpTreeBlock create(BlockBehaviour.Properties builder, final FluidProperty fluid) {
        return new KelpTreeBlock(builder){

            @Override
            public FluidProperty getFluidProperty() {
                return fluid;
            }
        };
    }

    protected KelpTreeBlock(BlockBehaviour.Properties builder) {
        super(0.3125f, builder);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)f_55148_, (Comparable)Boolean.FALSE)).m_61124_((Property)f_55149_, (Comparable)Boolean.FALSE)).m_61124_((Property)f_55150_, (Comparable)Boolean.FALSE)).m_61124_((Property)f_55151_, (Comparable)Boolean.FALSE)).m_61124_((Property)f_55152_, (Comparable)Boolean.FALSE)).m_61124_((Property)f_55153_, (Comparable)Boolean.FALSE)).m_61124_((Property)this.getFluidProperty(), (Comparable)this.getFluidProperty().keyFor(Fluids.f_76191_)));
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return this.getStateForPlacement((BlockGetter)context.m_43725_(), context.m_8083_());
    }

    public void m_5707_(Level level, BlockPos pos, BlockState state, Player player) {
        FluidHelpers.tickFluid((LevelAccessor)level, pos, state);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{this.getFluidProperty()});
        builder.m_61104_(new Property[]{f_55148_, f_55149_, f_55150_, f_55151_, f_55152_, f_55153_});
    }

    public BlockState getStateForPlacement(BlockGetter world, BlockPos pos) {
        Block downBlock = world.m_8055_(pos.m_7495_()).m_60734_();
        Block upBlock = world.m_8055_(pos.m_7494_()).m_60734_();
        Block northBlock = world.m_8055_(pos.m_142127_()).m_60734_();
        Block eastBlock = world.m_8055_(pos.m_142126_()).m_60734_();
        Block southBlock = world.m_8055_(pos.m_142128_()).m_60734_();
        Block westBlock = world.m_8055_(pos.m_142125_()).m_60734_();
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)f_55153_, (Comparable)Boolean.valueOf(Helpers.isBlock(downBlock, TFCTags.Blocks.KELP_TREE) || Helpers.isBlock(downBlock, TFCTags.Blocks.SEA_BUSH_PLANTABLE_ON)))).m_61124_((Property)f_55152_, (Comparable)Boolean.valueOf(Helpers.isBlock(upBlock, TFCTags.Blocks.KELP_TREE)))).m_61124_((Property)f_55148_, (Comparable)Boolean.valueOf(Helpers.isBlock(northBlock, TFCTags.Blocks.KELP_TREE)))).m_61124_((Property)f_55149_, (Comparable)Boolean.valueOf(Helpers.isBlock(eastBlock, TFCTags.Blocks.KELP_TREE)))).m_61124_((Property)f_55150_, (Comparable)Boolean.valueOf(Helpers.isBlock(southBlock, TFCTags.Blocks.KELP_TREE)))).m_61124_((Property)f_55151_, (Comparable)Boolean.valueOf(Helpers.isBlock(westBlock, TFCTags.Blocks.KELP_TREE)));
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        if (!state.m_60710_((LevelReader)level, currentPos)) {
            level.m_186460_(currentPos, (Block)this, 1);
            FluidHelpers.tickFluid(level, currentPos, state);
            return state;
        }
        FluidHelpers.tickFluid(level, currentPos, state);
        boolean flag = Helpers.isBlock(facingState, TFCTags.Blocks.KELP_TREE) || facing == Direction.DOWN && Helpers.isBlock(facingState, TFCTags.Blocks.SEA_BUSH_PLANTABLE_ON);
        return (BlockState)state.m_61124_((Property)f_55154_.get(facing), (Comparable)Boolean.valueOf(flag));
    }

    public FluidState m_5888_(BlockState state) {
        return IFluidLoggable.super.getFluidState(state);
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        if (state.m_60819_().m_76178_()) {
            return false;
        }
        BlockState belowState = level.m_8055_(pos.m_7495_());
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            Block below;
            BlockPos relativePos = pos.m_142300_(direction);
            if (!Helpers.isBlock(level.m_8055_(relativePos).m_60734_(), TFCTags.Blocks.KELP_BRANCH) || !Helpers.isBlock(below = level.m_8055_(relativePos.m_7495_()).m_60734_(), TFCTags.Blocks.KELP_BRANCH) && !Helpers.isBlock(below, TFCTags.Blocks.SEA_BUSH_PLANTABLE_ON)) continue;
            return true;
        }
        Block blockIn = belowState.m_60734_();
        return Helpers.isBlock(blockIn, TFCTags.Blocks.KELP_BRANCH) || Helpers.isBlock(blockIn, TFCTags.Blocks.SEA_BUSH_PLANTABLE_ON);
    }

    public void m_7458_(BlockState state, ServerLevel level, BlockPos pos, Random rand) {
        if (!state.m_60710_((LevelReader)level, pos)) {
            level.m_46961_(pos, true);
        }
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return DirectionPropertyBlock.rotate(state, rot);
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return DirectionPropertyBlock.mirror(state, mirror);
    }
}

