/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks.devices;

import java.util.Optional;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blockentities.TFCBlockEntities;
import net.dries007.tfc.common.blocks.EntityBlockExtension;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.IForgeBlockExtension;
import net.dries007.tfc.common.blocks.devices.BurningLogPileBlock;
import net.dries007.tfc.common.blocks.devices.DeviceBlock;
import net.dries007.tfc.common.capabilities.Capabilities;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;

public class LogPileBlock
extends DeviceBlock
implements IForgeBlockExtension,
EntityBlockExtension {
    public static final EnumProperty<Direction.Axis> AXIS = BlockStateProperties.f_61364_;

    public LogPileBlock(ExtendedProperties properties) {
        super(properties, DeviceBlock.InventoryRemoveBehavior.DROP);
        this.m_49959_((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_(AXIS, (Comparable)Direction.Axis.X));
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_(AXIS, (Comparable)context.m_8125_().m_122434_());
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder.m_61104_(new Property[]{AXIS}));
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor levelAccess, BlockPos currentPos, BlockPos facingPos) {
        if (!levelAccess.m_5776_() && levelAccess instanceof Level) {
            Level level = (Level)levelAccess;
            if (Helpers.isBlock(facingState, (TagKey<Block>)BlockTags.f_13076_)) {
                BurningLogPileBlock.tryLightLogPile(level, currentPos);
            }
        }
        return super.m_7417_(state, facing, facingState, levelAccess, currentPos, facingPos);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        if (!player.m_6144_()) {
            ItemStack stack = player.m_21120_(hand);
            level.m_141902_(pos, (BlockEntityType)TFCBlockEntities.LOG_PILE.get()).ifPresent(logPile -> {
                if (Helpers.isItem(stack.m_41720_(), TFCTags.Items.LOG_PILE_LOGS)) {
                    if (!level.f_46443_ && Helpers.insertOne(Optional.of(logPile), stack)) {
                        Helpers.playPlaceSound(level, pos, state);
                        stack.m_41774_(1);
                    }
                } else if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    Helpers.openScreen(serverPlayer, (MenuProvider)logPile, pos);
                }
            });
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        return InteractionResult.PASS;
    }

    @Override
    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter level, BlockPos pos, Player player) {
        level.m_141902_(pos, (BlockEntityType)TFCBlockEntities.LOG_PILE.get()).ifPresent(pile -> pile.getCapability(Capabilities.ITEM).map(cap -> {
            for (int i = 0; i < cap.getSlots(); ++i) {
                ItemStack stack = cap.getStackInSlot(i);
                if (stack.m_41619_()) continue;
                return stack.m_41777_();
            }
            return ItemStack.f_41583_;
        }));
        return ItemStack.f_41583_;
    }
}

