/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks;

import java.util.Random;
import net.dries007.tfc.common.TFCDamageSources;
import net.dries007.tfc.common.blocks.ExtendedBlock;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.TFCBlockStateProperties;
import net.dries007.tfc.common.blocks.TFCBlocks;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;

public class MoltenBlock
extends ExtendedBlock {
    public static final IntegerProperty LAYERS = TFCBlockStateProperties.LAYERS_4;
    public static final BooleanProperty LIT = BlockStateProperties.f_61443_;

    public static void removeMoltenBlockTower(Level level, BlockPos pos, int maxHeight) {
        MoltenBlock.manageMoltenBlockTower(level, pos, false, maxHeight, 0, 1);
    }

    public static void manageMoltenBlockTower(Level level, BlockPos pos, boolean lit, int maxHeight, int itemCount, int itemsPerLayer) {
        BlockState state = (BlockState)((Block)TFCBlocks.MOLTEN.get()).m_49966_().m_61124_((Property)LIT, (Comparable)Boolean.valueOf(lit));
        int layers = 0;
        if (itemCount > 0) {
            layers = Math.max(1, 4 * itemCount / itemsPerLayer);
        }
        for (int y = 0; y < maxHeight; ++y) {
            BlockPos checkPos = pos.m_6630_(y);
            if (layers >= 4) {
                level.m_46597_(checkPos, (BlockState)state.m_61124_((Property)LAYERS, (Comparable)Integer.valueOf(4)));
                layers -= 4;
                continue;
            }
            if (layers > 0) {
                level.m_46597_(checkPos, (BlockState)state.m_61124_((Property)LAYERS, (Comparable)Integer.valueOf(layers)));
                layers = 0;
                continue;
            }
            if (!Helpers.isBlock(level.m_8055_(checkPos), (Block)TFCBlocks.MOLTEN.get())) continue;
            level.m_46597_(checkPos, Blocks.f_50016_.m_49966_());
        }
    }

    public MoltenBlock(ExtendedProperties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)LAYERS, (Comparable)Integer.valueOf(1))).m_61124_((Property)LIT, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{LAYERS, LIT});
    }

    public void m_141947_(Level level, BlockPos pos, BlockState state, Entity entity) {
        if (!entity.m_5825_() && entity instanceof LivingEntity && !EnchantmentHelper.m_44938_((LivingEntity)((LivingEntity)entity)) && ((Boolean)level.m_8055_(pos).m_61143_((Property)LIT)).booleanValue()) {
            TFCDamageSources.hotFloor(entity, 1.0f);
        }
        super.m_141947_(level, pos, state, entity);
    }

    public void m_7100_(BlockState state, Level level, BlockPos pos, Random random) {
        if (((Boolean)state.m_61143_((Property)LIT)).booleanValue() && level.m_46859_(pos.m_7494_())) {
            double x = (double)pos.m_123341_() + 0.5;
            double y = (double)pos.m_123342_() + 1.1;
            double z = (double)pos.m_123343_() + 0.5;
            level.m_7106_((ParticleOptions)ParticleTypes.f_123777_, x, y, z, (double)Helpers.triangle(random) * 0.1, 0.2, (double)Helpers.triangle(random) * 0.1);
            if (random.nextInt(10) == 0) {
                level.m_7106_((ParticleOptions)ParticleTypes.f_123756_, x, y, z, (double)Helpers.triangle(random) * 0.1, 0.5, (double)Helpers.triangle(random) * 0.1);
            }
        }
    }

    public void m_7455_(BlockState state, ServerLevel level, BlockPos pos, Random rand) {
        if (level.m_8055_(pos.m_7494_()).m_60795_() && ((Boolean)state.m_61143_((Property)LIT)).booleanValue()) {
            Helpers.fireSpreaderTick(level, pos, rand, 2);
        }
    }
}

