/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks;

import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public interface DirectionPropertyBlock {
    public static final BooleanProperty UP = BlockStateProperties.f_61366_;
    public static final BooleanProperty DOWN = BlockStateProperties.f_61367_;
    public static final BooleanProperty NORTH = BlockStateProperties.f_61368_;
    public static final BooleanProperty EAST = BlockStateProperties.f_61369_;
    public static final BooleanProperty SOUTH = BlockStateProperties.f_61370_;
    public static final BooleanProperty WEST = BlockStateProperties.f_61371_;
    public static final BiMap<Direction, BooleanProperty> PROPERTY_BY_DIRECTION = ImmutableBiMap.builder().put((Object)Direction.UP, (Object)BlockStateProperties.f_61366_).put((Object)Direction.DOWN, (Object)BlockStateProperties.f_61367_).put((Object)Direction.NORTH, (Object)BlockStateProperties.f_61368_).put((Object)Direction.SOUTH, (Object)BlockStateProperties.f_61370_).put((Object)Direction.EAST, (Object)BlockStateProperties.f_61369_).put((Object)Direction.WEST, (Object)BlockStateProperties.f_61371_).build();
    public static final BooleanProperty[] PROPERTIES = new BooleanProperty[]{NORTH, SOUTH, EAST, WEST, UP, DOWN};

    public static BooleanProperty getProperty(Direction direction) {
        return (BooleanProperty)PROPERTY_BY_DIRECTION.get((Object)direction);
    }

    public static Direction getDirection(BooleanProperty property) {
        return (Direction)PROPERTY_BY_DIRECTION.inverse().get((Object)property);
    }

    public static BlockState setAllDirections(BlockState state, boolean value) {
        for (BooleanProperty property : PROPERTIES) {
            state = (BlockState)state.m_61124_((Property)property, (Comparable)Boolean.valueOf(value));
        }
        return state;
    }

    public static Map<BlockState, VoxelShape> makeShapeCache(StateDefinition<Block, BlockState> stateDefinition, Function<BooleanProperty, VoxelShape> toShape) {
        return stateDefinition.m_61056_().stream().collect(Collectors.toUnmodifiableMap(Function.identity(), state -> Arrays.stream(PROPERTIES).filter(arg_0 -> ((BlockState)state).m_61143_(arg_0)).map(toShape).reduce(Shapes::m_83110_).orElseGet(Shapes::m_83040_)));
    }

    public static BlockState rotate(BlockState state, Rotation rot) {
        return switch (rot) {
            case Rotation.CLOCKWISE_90 -> (BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_((Property)NORTH, (Comparable)((Boolean)state.m_61143_((Property)WEST)))).m_61124_((Property)EAST, (Comparable)((Boolean)state.m_61143_((Property)NORTH)))).m_61124_((Property)SOUTH, (Comparable)((Boolean)state.m_61143_((Property)EAST)))).m_61124_((Property)WEST, (Comparable)((Boolean)state.m_61143_((Property)SOUTH)));
            case Rotation.CLOCKWISE_180 -> (BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_((Property)NORTH, (Comparable)((Boolean)state.m_61143_((Property)SOUTH)))).m_61124_((Property)EAST, (Comparable)((Boolean)state.m_61143_((Property)WEST)))).m_61124_((Property)SOUTH, (Comparable)((Boolean)state.m_61143_((Property)NORTH)))).m_61124_((Property)WEST, (Comparable)((Boolean)state.m_61143_((Property)EAST)));
            case Rotation.COUNTERCLOCKWISE_90 -> (BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_((Property)NORTH, (Comparable)((Boolean)state.m_61143_((Property)EAST)))).m_61124_((Property)EAST, (Comparable)((Boolean)state.m_61143_((Property)SOUTH)))).m_61124_((Property)SOUTH, (Comparable)((Boolean)state.m_61143_((Property)WEST)))).m_61124_((Property)WEST, (Comparable)((Boolean)state.m_61143_((Property)NORTH)));
            default -> state;
        };
    }

    public static BlockState mirror(BlockState state, Mirror mirror) {
        return switch (mirror) {
            case Mirror.LEFT_RIGHT -> (BlockState)((BlockState)state.m_61124_((Property)NORTH, (Comparable)((Boolean)state.m_61143_((Property)SOUTH)))).m_61124_((Property)SOUTH, (Comparable)((Boolean)state.m_61143_((Property)NORTH)));
            case Mirror.FRONT_BACK -> (BlockState)((BlockState)state.m_61124_((Property)EAST, (Comparable)((Boolean)state.m_61143_((Property)WEST)))).m_61124_((Property)WEST, (Comparable)((Boolean)state.m_61143_((Property)EAST)));
            default -> state;
        };
    }
}

