/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blockentities;

import net.dries007.tfc.common.blockentities.TFCBlockEntity;
import net.dries007.tfc.common.capabilities.Capabilities;
import net.dries007.tfc.common.capabilities.InventoryItemHandler;
import net.dries007.tfc.common.capabilities.SidedHandler;
import net.dries007.tfc.common.container.ISlotCallback;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Clearable;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class InventoryBlockEntity<C extends IItemHandlerModifiable & INBTSerializable<CompoundTag>>
extends TFCBlockEntity
implements ISlotCallback,
MenuProvider,
Clearable {
    protected final C inventory;
    protected final SidedHandler.Builder<IItemHandler> sidedInventory;
    @Nullable
    protected Component customName;
    protected Component defaultName;

    public static InventoryFactory<ItemStackHandler> defaultInventory(int slots) {
        return self -> new InventoryItemHandler(self, slots);
    }

    public InventoryBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state, InventoryFactory<C> inventoryFactory, Component defaultName) {
        super(type, pos, state);
        this.inventory = inventoryFactory.create(this);
        this.sidedInventory = new SidedHandler.Builder<C>(this.inventory);
        this.defaultName = defaultName;
    }

    public Component m_5446_() {
        return this.customName == null ? this.defaultName : this.customName;
    }

    public void setCustomName(Component customName) {
        this.customName = customName;
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int containerId, Inventory inventory, Player player) {
        return null;
    }

    @Override
    public void loadAdditional(CompoundTag nbt) {
        if (nbt.m_128441_("CustomName")) {
            this.customName = Component.Serializer.m_130701_((String)nbt.m_128461_("CustomName"));
        }
        ((INBTSerializable)this.inventory).deserializeNBT((Tag)nbt.m_128469_("inventory"));
        super.loadAdditional(nbt);
    }

    @Override
    public void m_183515_(CompoundTag nbt) {
        if (this.customName != null) {
            nbt.m_128359_("CustomName", Component.Serializer.m_130703_((Component)this.customName));
        }
        nbt.m_128365_("inventory", ((INBTSerializable)this.inventory).serializeNBT());
        super.m_183515_(nbt);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        if (cap == Capabilities.ITEM) {
            return this.sidedInventory.getSidedHandler(side).cast();
        }
        return super.getCapability(cap, side);
    }

    public void m_6211_() {
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            this.inventory.setStackInSlot(i, ItemStack.f_41583_);
        }
    }

    public void ejectInventory() {
        assert (this.f_58857_ != null);
        for (ItemStack stack : Helpers.iterate(this.inventory)) {
            if (stack.m_41619_()) continue;
            Helpers.spawnItem(this.f_58857_, this.f_58858_, stack);
        }
    }

    public void invalidateCapabilities() {
        this.sidedInventory.invalidate();
    }

    @Override
    public void setAndUpdateSlots(int slot) {
        this.m_6596_();
    }

    public boolean canInteractWith(Player player) {
        if (this.f_58857_ == null || this.f_58857_.m_7702_(this.f_58858_) != this) {
            return false;
        }
        return player.m_20275_((double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5) <= 64.0;
    }

    @FunctionalInterface
    public static interface InventoryFactory<C extends IItemHandlerModifiable & INBTSerializable<CompoundTag>> {
        public C create(InventoryBlockEntity<C> var1);
    }
}

