/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.client.screen;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Objects;
import java.util.function.Consumer;
import net.dries007.tfc.client.RenderHelpers;
import net.dries007.tfc.client.screen.BlockEntityScreen;
import net.dries007.tfc.client.screen.button.BarrelSealButton;
import net.dries007.tfc.common.blockentities.BarrelBlockEntity;
import net.dries007.tfc.common.blocks.devices.BarrelBlock;
import net.dries007.tfc.common.capabilities.Capabilities;
import net.dries007.tfc.common.container.BarrelContainer;
import net.dries007.tfc.common.recipes.BarrelRecipe;
import net.dries007.tfc.config.TFCConfig;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.Tooltips;
import net.dries007.tfc.util.calendar.Calendars;
import net.dries007.tfc.util.calendar.ICalendar;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.fluids.FluidStack;

public class BarrelScreen
extends BlockEntityScreen<BarrelBlockEntity, BarrelContainer> {
    private static final Component SEAL = Helpers.translatable("tfc.tooltip.seal_barrel");
    private static final Component UNSEAL = Helpers.translatable("tfc.tooltip.unseal_barrel");
    private static final int MAX_RECIPE_NAME_LENGTH = 100;
    public static final ResourceLocation BACKGROUND = Helpers.identifier("textures/gui/barrel.png");

    public BarrelScreen(BarrelContainer container, Inventory playerInventory, Component name) {
        super(container, playerInventory, name, BACKGROUND);
        this.f_97731_ += 12;
        this.f_97727_ += 12;
    }

    public void m_7856_() {
        super.m_7856_();
        this.m_142416_((GuiEventListener)new BarrelSealButton((BarrelBlockEntity)this.blockEntity, this.getGuiLeft(), this.getGuiTop(), new Button.OnTooltip(){

            public void m_93752_(Button button, PoseStack poseStack, int x, int y) {
                BarrelScreen.this.m_96602_(poseStack, BarrelScreen.this.isSealed() ? UNSEAL : SEAL, x, y);
            }

            public void m_142753_(Consumer<Component> consumer) {
                consumer.accept(BarrelScreen.this.isSealed() ? UNSEAL : SEAL);
            }
        }));
    }

    protected void m_7027_(PoseStack poseStack, int mouseX, int mouseY) {
        super.m_7027_(poseStack, mouseX, mouseY);
        if (this.isSealed()) {
            this.drawDisabled(poseStack, 0, 2);
            BarrelRecipe recipe = ((BarrelBlockEntity)this.blockEntity).getRecipe();
            if (recipe != null) {
                TranslatableComponent resultText = recipe.getTranslationComponent();
                if (this.f_96547_.m_92852_((FormattedText)resultText) > 100) {
                    int line = 0;
                    for (FormattedCharSequence text : this.f_96547_.m_92923_((FormattedText)resultText, 100)) {
                        float f = 70 + Math.floorDiv(100 - this.f_96547_.m_92724_(text), 2);
                        Objects.requireNonNull(this.f_96547_);
                        this.f_96547_.m_92877_(poseStack, text, f, (float)(this.f_97729_ + line * 9), 0x404040);
                        ++line;
                    }
                } else {
                    this.f_96547_.m_92883_(poseStack, resultText.getString(), (float)(70 + Math.floorDiv(100 - this.f_96547_.m_92852_((FormattedText)resultText), 2)), 61.0f, 0x404040);
                }
            }
            String date = ICalendar.getTimeAndDate(Calendars.CLIENT.ticksToCalendarTicks(((BarrelBlockEntity)this.blockEntity).getSealedTick()), Calendars.CLIENT.getCalendarDaysInMonth()).getString();
            this.f_96547_.m_92883_(poseStack, date, (float)this.f_97726_ / 2.0f - (float)this.f_96547_.m_92895_(date) / 2.0f, 74.0f, 0x404040);
        }
    }

    @Override
    protected void m_7286_(PoseStack poseStack, float partialTicks, int mouseX, int mouseY) {
        super.m_7286_(poseStack, partialTicks, mouseX, mouseY);
        ((BarrelBlockEntity)this.blockEntity).getCapability(Capabilities.FLUID).ifPresent(fluidHandler -> {
            FluidStack fluidStack = fluidHandler.getFluidInTank(0);
            if (!fluidStack.isEmpty()) {
                TextureAtlasSprite sprite = RenderHelpers.getAndBindFluidSprite(fluidStack);
                int fillHeight = (int)Math.ceil(50.0f * (float)fluidStack.getAmount() / (float)((Integer)TFCConfig.SERVER.barrelCapacity.get()).intValue());
                RenderHelpers.fillAreaWithSprite(poseStack, sprite, this.f_97735_ + 8, this.f_97736_ + 70 - fillHeight, 16, fillHeight, 16, 16);
                this.resetToBackgroundSprite();
            }
        });
        this.m_93228_(poseStack, this.getGuiLeft() + 7, this.getGuiTop() + 19, 176, 0, 18, 52);
    }

    protected void m_7025_(PoseStack poseStack, int mouseX, int mouseY) {
        super.m_7025_(poseStack, mouseX, mouseY);
        int relX = mouseX - this.getGuiLeft();
        int relY = mouseY - this.getGuiTop();
        if (relX >= 7 && relY >= 19 && relX < 25 && relY < 71) {
            ((BarrelBlockEntity)this.blockEntity).getCapability(Capabilities.FLUID).ifPresent(fluidHandler -> {
                FluidStack fluid = fluidHandler.getFluidInTank(0);
                if (!fluid.isEmpty()) {
                    this.m_96602_(poseStack, (Component)Tooltips.fluidUnitsOf(fluid), mouseX, mouseY);
                }
            });
        }
    }

    private boolean isSealed() {
        return (Boolean)((BarrelBlockEntity)this.blockEntity).m_58900_().m_61143_((Property)BarrelBlock.SEALED);
    }
}

