/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.client.model.entity;

import com.google.common.collect.ImmutableList;
import net.dries007.tfc.common.entities.livestock.WoolyAnimal;
import net.minecraft.client.model.AgeableListModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;

public class TFCSheepModel
extends AgeableListModel<WoolyAnimal> {
    private final ModelPart body;
    private final ModelPart head;
    private final ModelPart leftHindLeg;
    private final ModelPart rightHindLeg;
    private final ModelPart leftFrontLeg;
    private final ModelPart rightFrontLeg;
    private final ModelPart woolBody;
    private final ModelPart woolHead;
    private final ModelPart woolLeftFrontLeg;
    private final ModelPart woolLeftHindLeg;
    private final ModelPart woolRightFrontLeg;
    private final ModelPart woolRightHindLeg;
    private final ModelPart leftHorn;
    private final ModelPart rightHorn;

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition body = partdefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 29).m_171488_(-4.0f, -5.0f, -8.0f, 8.0f, 8.0f, 16.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)11.0f, (float)0.0f));
        PartDefinition woolBody = body.m_171599_("woolBody", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-5.5f, -7.0f, -9.0f, 11.0f, 11.0f, 18.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition leftFrontLeg = body.m_171599_("leftFrontLeg", CubeListBuilder.m_171558_().m_171514_(78, 0).m_171488_(2.0f, 1.0f, -7.0f, 3.0f, 12.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition woolLeftFrontLeg = leftFrontLeg.m_171599_("woolLeftFrontLeg", CubeListBuilder.m_171558_().m_171514_(0, 53).m_171488_(8.0f, 1.0f, -8.0f, 5.0f, 6.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-7.0f, (float)0.0f, (float)0.0f));
        PartDefinition rightFrontLeg = body.m_171599_("rightFrontLeg", CubeListBuilder.m_171558_().m_171514_(66, 0).m_171488_(2.0f, 1.0f, -7.0f, 3.0f, 12.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-7.0f, (float)0.0f, (float)0.0f));
        PartDefinition woolRightFrontLeg = rightFrontLeg.m_171599_("woolRightFrontLeg", CubeListBuilder.m_171558_().m_171514_(53, 24).m_171488_(1.0f, 1.0f, -8.0f, 5.0f, 6.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition leftHindLeg = body.m_171599_("leftHindLeg", CubeListBuilder.m_171558_().m_171514_(0, 29).m_171488_(2.0f, 1.0f, -7.0f, 3.0f, 12.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)12.25f));
        PartDefinition woolLeftHindLeg = leftHindLeg.m_171599_("woolLeftHindLeg", CubeListBuilder.m_171558_().m_171514_(20, 53).m_171488_(8.0f, 1.0f, 4.25f, 5.0f, 6.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-7.0f, (float)0.0f, (float)-12.25f));
        PartDefinition rightHindLeg = body.m_171599_("rightHindLeg", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(2.0f, 1.0f, -7.0f, 3.0f, 12.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-7.0f, (float)0.0f, (float)12.25f));
        PartDefinition woolRightHindLeg = rightHindLeg.m_171599_("woolRightHindLeg", CubeListBuilder.m_171558_().m_171514_(43, 48).m_171488_(1.0f, 1.0f, 4.25f, 5.0f, 6.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)-12.25f));
        PartDefinition head = body.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(40, 0).m_171488_(-3.0f, -6.0f, -5.0f, 6.0f, 6.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-3.0f, (float)-9.0f));
        PartDefinition woolHead = head.m_171599_("woolHead", CubeListBuilder.m_171558_().m_171514_(32, 29).m_171488_(-3.5f, -6.5f, -3.75f, 7.0f, 7.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition leftHorn = head.m_171599_("leftHorn", CubeListBuilder.m_171558_().m_171514_(90, 0).m_171488_(-1.0f, -2.0f, -1.0f, 3.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)2.5f, (float)-5.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.6981f));
        PartDefinition cube_r1 = leftHorn.m_171599_("cube_r1", CubeListBuilder.m_171558_().m_171514_(90, 8).m_171488_(-1.5039f, -1.0643f, -4.0f, 2.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)2.0f, (float)3.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.3491f));
        PartDefinition cube_r2 = leftHorn.m_171599_("cube_r2", CubeListBuilder.m_171558_().m_171514_(90, 4).m_171488_(1.5f, 0.5f, -3.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0873f));
        PartDefinition cube_r3 = leftHorn.m_171599_("cube_r3", CubeListBuilder.m_171558_().m_171514_(90, 10).m_171488_(0.75f, -0.75f, -2.0f, 2.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.48f));
        PartDefinition rightHorn = head.m_171599_("rightHorn", CubeListBuilder.m_171558_().m_171514_(90, 0).m_171480_().m_171488_(-2.0f, -2.0f, -1.0f, 3.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)-2.5f, (float)-5.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.6981f));
        PartDefinition cube_r4 = rightHorn.m_171599_("cube_r4", CubeListBuilder.m_171558_().m_171514_(90, 8).m_171480_().m_171488_(-0.4961f, -1.0643f, -4.0f, 2.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)-2.0f, (float)3.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.3491f));
        PartDefinition cube_r5 = rightHorn.m_171599_("cube_r5", CubeListBuilder.m_171558_().m_171514_(90, 4).m_171480_().m_171488_(-3.5f, 0.5f, -3.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.0873f));
        PartDefinition cube_r6 = rightHorn.m_171599_("cube_r6", CubeListBuilder.m_171558_().m_171514_(90, 10).m_171480_().m_171488_(-2.75f, -0.75f, -2.0f, 2.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.48f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)128, (int)64);
    }

    public TFCSheepModel(ModelPart root) {
        super(false, 0.0f, 0.0f, 1.8f, 1.8f, 18.0f);
        this.body = root.m_171324_("body");
        this.head = this.body.m_171324_("head");
        this.woolBody = this.body.m_171324_("woolBody");
        this.woolHead = this.head.m_171324_("woolHead");
        this.rightHorn = this.head.m_171324_("rightHorn");
        this.leftHorn = this.head.m_171324_("leftHorn");
        this.leftHindLeg = this.body.m_171324_("leftHindLeg");
        this.rightHindLeg = this.body.m_171324_("rightHindLeg");
        this.leftFrontLeg = this.body.m_171324_("leftFrontLeg");
        this.rightFrontLeg = this.body.m_171324_("rightFrontLeg");
        this.woolLeftHindLeg = this.leftHindLeg.m_171324_("woolLeftHindLeg");
        this.woolLeftFrontLeg = this.leftFrontLeg.m_171324_("woolLeftFrontLeg");
        this.woolRightHindLeg = this.rightHindLeg.m_171324_("woolRightHindLeg");
        this.woolRightFrontLeg = this.rightFrontLeg.m_171324_("woolRightFrontLeg");
    }

    public void setupAnim(WoolyAnimal sheep, float limbSwing, float limbSwingAmount, float ageInTicks, float headYaw, float headPitch) {
        this.rightHorn.f_104207_ = this.leftHorn.f_104207_ = sheep.displayMaleCharacteristics();
        this.woolRightFrontLeg.f_104207_ = this.woolRightHindLeg.f_104207_ = sheep.hasProduct();
        this.woolLeftHindLeg.f_104207_ = this.woolRightHindLeg.f_104207_;
        this.woolLeftFrontLeg.f_104207_ = this.woolRightHindLeg.f_104207_;
        this.woolHead.f_104207_ = this.woolRightHindLeg.f_104207_;
        this.woolBody.f_104207_ = this.woolRightHindLeg.f_104207_;
        this.head.f_104203_ = headPitch * ((float)Math.PI / 180);
        this.head.f_104204_ = headYaw * ((float)Math.PI / 180);
        this.rightHindLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.9f)) * 0.4f * limbSwingAmount;
        this.leftHindLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.9f + (float)Math.PI)) * 0.4f * limbSwingAmount;
        this.rightFrontLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.9f + (float)Math.PI)) * 0.4f * limbSwingAmount;
        this.leftFrontLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.9f)) * 0.4f * limbSwingAmount;
    }

    protected Iterable<ModelPart> m_5607_() {
        return ImmutableList.of();
    }

    protected Iterable<ModelPart> m_5608_() {
        return ImmutableList.of((Object)this.body);
    }
}

