/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.client.model.entity;

import java.util.Map;
import net.dries007.tfc.client.model.animation.AnimationChannel;
import net.dries007.tfc.client.model.animation.AnimationDefinition;
import net.dries007.tfc.client.model.animation.VanillaAnimations;
import net.dries007.tfc.client.model.entity.HierarchicalAnimatedModel;
import net.dries007.tfc.common.entities.aquatic.Penguin;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;

public class PenguinModel
extends HierarchicalAnimatedModel<Penguin> {
    public static final AnimationDefinition WALK = AnimationDefinition.Builder.withLength(1.0f).looping().addAnimation("core", new AnimationChannel(AnimationChannel.Targets.ROTATION, VanillaAnimations.rotation(0.0f, 0.0f, 0.0f, 15.0f), VanillaAnimations.rotation(0.5f, 0.0f, 0.0f, -15.0f), VanillaAnimations.rotation(1.0f, 0.0f, 0.0f, 15.0f))).addAnimation("head", new AnimationChannel(AnimationChannel.Targets.ROTATION, VanillaAnimations.noRotation(0.0f), VanillaAnimations.rotation(0.33f, 0.0f, 0.0f, -15.0f), VanillaAnimations.rotation(0.66f, 0.0f, 0.0f, 15.0f), VanillaAnimations.noRotation(1.0f))).addAnimation("leftfoot", new AnimationChannel(AnimationChannel.Targets.ROTATION, VanillaAnimations.noRotation(0.0f), VanillaAnimations.rotation(0.5f, 45.0f, 0.0f, 0.0f), VanillaAnimations.noRotation(1.0f))).addAnimation("rightfoot", new AnimationChannel(AnimationChannel.Targets.ROTATION, VanillaAnimations.noRotation(0.0f), VanillaAnimations.rotation(0.5f, -45.0f, 0.0f, 0.0f), VanillaAnimations.noRotation(1.0f))).addAnimation("leftwing", new AnimationChannel(AnimationChannel.Targets.ROTATION, VanillaAnimations.noRotation(0.0f), VanillaAnimations.rotation(0.5f, 25.0f, 0.0f, 0.0f), VanillaAnimations.noRotation(1.0f))).addAnimation("rightwing", new AnimationChannel(AnimationChannel.Targets.ROTATION, VanillaAnimations.noRotation(0.0f), VanillaAnimations.rotation(0.5f, 25.0f, 0.0f, 0.0f), VanillaAnimations.noRotation(1.0f))).build();
    public static final AnimationDefinition SWIM = AnimationDefinition.Builder.withLength(1.0f).looping().addAnimation("leftfoot", new AnimationChannel(AnimationChannel.Targets.ROTATION, VanillaAnimations.noRotation(0.0f), VanillaAnimations.rotation(0.5f, 45.0f, 0.0f, 0.0f), VanillaAnimations.noRotation(1.0f))).addAnimation("rightfoot", new AnimationChannel(AnimationChannel.Targets.ROTATION, VanillaAnimations.noRotation(0.0f), VanillaAnimations.rotation(0.5f, -45.0f, 0.0f, 0.0f), VanillaAnimations.noRotation(1.0f))).addAnimation("leftwing", new AnimationChannel(AnimationChannel.Targets.ROTATION, VanillaAnimations.noRotation(0.0f), VanillaAnimations.rotation(0.5f, 0.0f, 0.0f, -25.0f), VanillaAnimations.noRotation(1.0f))).addAnimation("rightwing", new AnimationChannel(AnimationChannel.Targets.ROTATION, VanillaAnimations.noRotation(0.0f), VanillaAnimations.rotation(0.5f, 0.0f, 0.0f, 25.0f), VanillaAnimations.noRotation(1.0f))).build();
    public final Map<ModelPart, PartPose> defaults;
    private final ModelPart core;
    private final ModelPart head;

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition core = partdefinition.m_171599_("core", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)23.0f, (float)0.0f));
        PartDefinition core_r1 = core.m_171599_("core_r1", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-2.0f, -9.0f, -2.0f, 4.0f, 8.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)1.0f, (float)1.0f, (float)-3.1416f, (float)0.0f, (float)3.1416f));
        PartDefinition head = core.m_171599_("head", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)-8.0f, (float)0.0f));
        PartDefinition head_r1 = head.m_171599_("head_r1", CubeListBuilder.m_171558_().m_171514_(16, 4).m_171488_(-1.0f, -10.0f, 1.5f, 2.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)9.0f, (float)1.0f, (float)-3.1416f, (float)0.0f, (float)3.1416f));
        PartDefinition head_r2 = head.m_171599_("head_r2", CubeListBuilder.m_171558_().m_171514_(13, 9).m_171488_(-1.0f, -2.0f, -1.0f, 2.0f, 2.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)1.0f, (float)-3.1416f, (float)0.0f, (float)3.1416f));
        PartDefinition leftfoot = core.m_171599_("leftfoot", CubeListBuilder.m_171558_().m_171514_(12, 0).m_171488_(1.3264f, 0.0f, -0.9848f, 2.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-1.0f, (float)0.0f, (float)-1.0f, (float)0.0f, (float)-0.1745f, (float)0.0f));
        PartDefinition rightfoot = core.m_171599_("rightfoot", CubeListBuilder.m_171558_().m_171514_(16, 16).m_171488_(-4.3264f, 0.0f, -0.9848f, 2.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)2.0f, (float)0.0f, (float)-1.0f, (float)0.0f, (float)0.1745f, (float)0.0f));
        PartDefinition leftwing = core.m_171599_("leftwing", CubeListBuilder.m_171558_().m_171514_(0, 12).m_171480_().m_171488_(0.0f, 0.0f, 0.0f, 1.0f, 5.0f, 3.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)2.0f, (float)-7.0f, (float)-1.0f, (float)0.0f, (float)0.0f, (float)-0.1745f));
        PartDefinition rightwing = core.m_171599_("rightwing", CubeListBuilder.m_171558_().m_171514_(8, 12).m_171480_().m_171488_(-1.0f, 0.0f, 0.0f, 1.0f, 5.0f, 3.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)-2.0f, (float)-7.0f, (float)-1.0f, (float)0.0f, (float)0.0f, (float)0.1745f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)32, (int)32);
    }

    public PenguinModel(ModelPart root) {
        super(root);
        this.core = root.m_171324_("core");
        this.head = this.core.m_171324_("head");
        this.defaults = VanillaAnimations.save(root.m_171331_());
    }

    public void setupAnim(Penguin entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        super.m_6973_(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        if (entity.isPlayingDead()) {
            this.core.f_104203_ = -1.5707964f;
        } else {
            this.animate(entity.walkingAnimation, WALK, ageInTicks, this.getAdjustedLandSpeed(entity));
            this.animate(entity.swimmingAnimation, SWIM, ageInTicks);
            this.head.f_104203_ = entity.m_20069_() ? -1.0f : headPitch * ((float)Math.PI / 180);
            this.head.f_104204_ = netHeadYaw * ((float)Math.PI / 180);
        }
    }
}

