/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.client.model.animation;

import com.google.common.collect.ImmutableMap;
import com.mojang.math.Vector3f;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import net.dries007.tfc.client.model.animation.AnimationChannel;
import net.dries007.tfc.client.model.animation.AnimationDefinition;
import net.dries007.tfc.client.model.animation.Keyframe;
import net.dries007.tfc.mixin.client.accessor.ModelPartAccessor;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.util.Mth;

public final class VanillaAnimations {
    public static void animate(HierarchicalModel<?> model, AnimationDefinition definition, long ticks, float scale, Vector3f pos) {
        float seconds = VanillaAnimations.getElapsedSeconds(definition, ticks);
        for (Map.Entry<String, List<AnimationChannel>> entry : definition.boneAnimations().entrySet()) {
            Optional<ModelPart> optionalPart = VanillaAnimations.findNamedPart(model, entry.getKey());
            List<AnimationChannel> list = entry.getValue();
            optionalPart.ifPresent(part -> list.forEach(channel -> {
                Keyframe[] frames = channel.keyframes();
                int startIdx = Math.max(0, Mth.m_14049_((int)0, (int)frames.length, idx -> seconds <= frames[idx].timestamp()) - 1);
                int endIdx = Math.min(frames.length - 1, startIdx + 1);
                Keyframe start = frames[startIdx];
                Keyframe end = frames[endIdx];
                float now = seconds - start.timestamp();
                float lerp = Mth.m_14036_((float)(now / (end.timestamp() - start.timestamp())), (float)0.0f, (float)1.0f);
                end.interpolation().apply(pos, lerp, frames, startIdx, endIdx, scale);
                channel.target().apply((ModelPart)part, pos);
            }));
        }
    }

    public static Optional<ModelPart> findNamedPart(HierarchicalModel<?> model, String name) {
        return model.m_142109_().m_171331_().filter(p -> ((ModelPartAccessor)p).accessor$getChildren().containsKey(name)).findFirst().map(p -> p.m_171324_(name));
    }

    private static float getElapsedSeconds(AnimationDefinition anim, long ticks) {
        float f = (float)ticks / 1000.0f;
        return anim.loop() ? f % anim.lengthInSeconds() : f;
    }

    public static ImmutableMap<ModelPart, PartPose> save(Stream<ModelPart> parts) {
        ImmutableMap.Builder map = new ImmutableMap.Builder();
        parts.forEach(part -> map.put(part, (Object)part.m_171308_()));
        return map.build();
    }

    public static Keyframe translation(float time, float x, float y, float z) {
        return VanillaAnimations.translation(time, x, y, z, true);
    }

    public static Keyframe translation(float time, float x, float y, float z, boolean cmr) {
        return new Keyframe(time, VanillaAnimations.posVec(x, y, z), cmr ? AnimationChannel.Interpolations.CATMULLROM : AnimationChannel.Interpolations.LINEAR);
    }

    public static Keyframe noRotation(float time) {
        return VanillaAnimations.rotation(time, 0.0f, 0.0f, 0.0f);
    }

    public static Keyframe noRotation(float time, boolean cmr) {
        return VanillaAnimations.rotation(time, 0.0f, 0.0f, 0.0f, cmr);
    }

    public static Keyframe rotation(float time, float x, float y, float z) {
        return VanillaAnimations.rotation(time, x, y, z, true);
    }

    public static Keyframe rotation(float time, float x, float y, float z, boolean cmr) {
        return new Keyframe(time, VanillaAnimations.degreeVec(x, y, z), cmr ? AnimationChannel.Interpolations.CATMULLROM : AnimationChannel.Interpolations.LINEAR);
    }

    public static Vector3f posVec(float x, float y, float z) {
        return new Vector3f(x, -y, z);
    }

    public static Vector3f degreeVec(float x, float y, float z) {
        return new Vector3f(x * ((float)Math.PI / 180), y * ((float)Math.PI / 180), z * ((float)Math.PI / 180));
    }
}

