/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.datagen.builder;

import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.Tag;
import net.minecraft.tags.TagKey;

public class GTTagBuilder<T> {
    public final Tag.Builder builder;
    public final Registry<T> registry;
    public final List<T> removeElements = new ArrayList<T>();
    private final String source;
    boolean replace = false;

    public GTTagBuilder(Tag.Builder builder, Registry<T> registry, String string) {
        this.builder = builder;
        this.registry = registry;
        this.source = string;
    }

    public GTTagBuilder<T> add(T item) {
        this.builder.m_13327_(this.registry.m_7981_(item), this.source);
        return this;
    }

    public GTTagBuilder<T> add(Tag.BuilderEntry builderEntry) {
        this.builder.m_13305_(builderEntry);
        return this;
    }

    public GTTagBuilder<T> add(ResourceKey<T> ... resourceKeys) {
        for (ResourceKey<T> resourceKey : resourceKeys) {
            this.builder.m_13327_(resourceKey.m_135782_(), this.source);
        }
        return this;
    }

    public GTTagBuilder<T> addOptional(ResourceLocation location) {
        this.builder.m_144379_(location, this.source);
        return this;
    }

    public GTTagBuilder<T> addTag(TagKey<T> tag) {
        this.builder.m_13335_(tag.f_203868_(), this.source);
        return this;
    }

    public GTTagBuilder<T> addOptionalTag(ResourceLocation location) {
        this.builder.m_144382_(location, this.source);
        return this;
    }

    @SafeVarargs
    public final GTTagBuilder<T> add(T ... toAdd) {
        Stream.of(toAdd).map(arg_0 -> this.registry.m_7981_(arg_0)).forEach(resourceLocation -> this.builder.m_13327_(resourceLocation, this.source));
        return this;
    }

    @SafeVarargs
    public final GTTagBuilder<T> remove(T ... remove) {
        this.removeElements.addAll(Arrays.asList(remove));
        return this;
    }

    public GTTagBuilder<T> replace() {
        return this.replace(true);
    }

    public GTTagBuilder<T> replace(boolean value) {
        this.replace = value;
        return this;
    }

    public GTTagBuilder<T> addFromJson(JsonObject json, String source) {
        this.builder.m_13312_(json, source);
        return this;
    }

    public JsonObject serializeToJson() {
        JsonObject jsonObject = this.builder.m_13334_();
        jsonObject.addProperty("replace", Boolean.valueOf(this.replace));
        return jsonObject;
    }
}

