/*
 * Decompiled with CFR 0.152.
 */
package com.eerussianguy.firmalife.common.network;

import com.eerussianguy.firmalife.common.FLHelpers;
import com.eerussianguy.firmalife.common.util.GreenhouseType;
import com.eerussianguy.firmalife.common.util.Plantable;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.dries007.tfc.network.PacketHandler;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;
import org.apache.commons.lang3.mutable.MutableInt;

public class FLPackets {
    private static final String VERSION = Integer.toString(1);
    private static final SimpleChannel CHANNEL = NetworkRegistry.newSimpleChannel((ResourceLocation)FLHelpers.identifier("network"), () -> VERSION, VERSION::equals, VERSION::equals);
    private static final MutableInt ID = new MutableInt(0);

    public static void send(PacketDistributor.PacketTarget target, Object message) {
        CHANNEL.send(target, message);
    }

    public static void init() {
        PacketHandler.registerDataManager(GreenhouseType.Packet.class, GreenhouseType.MANAGER, (SimpleChannel)CHANNEL, (int)ID.getAndIncrement());
        PacketHandler.registerDataManager(Plantable.Packet.class, Plantable.MANAGER, (SimpleChannel)CHANNEL, (int)ID.getAndIncrement());
    }

    private static <T> void register(Class<T> cls, BiConsumer<T, FriendlyByteBuf> encoder, Function<FriendlyByteBuf, T> decoder, BiConsumer<T, NetworkEvent.Context> handler) {
        CHANNEL.registerMessage(ID.getAndIncrement(), cls, encoder, decoder, (packet, context) -> {
            ((NetworkEvent.Context)context.get()).setPacketHandled(true);
            handler.accept(packet, (NetworkEvent.Context)context.get());
        });
    }

    private static <T> void register(Class<T> cls, Supplier<T> factory, BiConsumer<T, NetworkEvent.Context> handler) {
        CHANNEL.registerMessage(ID.getAndIncrement(), cls, (packet, buffer) -> {}, buffer -> factory.get(), (packet, context) -> {
            ((NetworkEvent.Context)context.get()).setPacketHandled(true);
            handler.accept(packet, (NetworkEvent.Context)context.get());
        });
    }
}

