/*
 * Decompiled with CFR 0.152.
 */
package com.eerussianguy.firmalife.common.blocks;

import com.eerussianguy.firmalife.common.FLHelpers;
import com.eerussianguy.firmalife.common.blockentities.FLBlockEntities;
import com.eerussianguy.firmalife.common.misc.FLDamageSources;
import java.util.Random;
import net.dries007.tfc.common.blockentities.AbstractFirepitBlockEntity;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.TFCBlockStateProperties;
import net.dries007.tfc.common.blocks.devices.DeviceBlock;
import net.dries007.tfc.common.items.Powder;
import net.dries007.tfc.common.items.TFCItems;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.registries.RegistryObject;

public class AshtrayBlock
extends DeviceBlock {
    public static final IntegerProperty STAGE = TFCBlockStateProperties.STAGE_10;

    public AshtrayBlock(ExtendedProperties properties) {
        super(properties, DeviceBlock.InventoryRemoveBehavior.DROP);
        this.m_49959_((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)STAGE, (Comparable)Integer.valueOf(0)));
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        return FLHelpers.consumeInventory(level, pos, FLBlockEntities.ASHTRAY, (ashtray, inv) -> {
            ItemStack stack = inv.extractItem(0, player.m_6144_() ? Integer.MAX_VALUE : 1, false);
            if (!stack.m_41619_()) {
                ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)stack);
                ashtray.updateBlockState();
                Helpers.playSound((Level)level, (BlockPos)pos, (SoundEvent)SoundEvents.f_12334_);
                return InteractionResult.m_19078_((boolean)level.f_46443_);
            }
            return InteractionResult.PASS;
        });
    }

    public void m_7455_(BlockState state, ServerLevel level, BlockPos pos, Random rand) {
        AbstractFirepitBlockEntity firepit;
        BlockEntity blockEntity = level.m_7702_(pos.m_7495_());
        if (blockEntity instanceof AbstractFirepitBlockEntity && (firepit = (AbstractFirepitBlockEntity)blockEntity).getTemperature() > 0.0f && (Integer)state.m_61143_((Property)STAGE) > 0) {
            level.m_7703_(null, FLDamageSources.ASH, null, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), 10.0f, true, Explosion.BlockInteraction.BREAK);
        }
    }

    public void m_6256_(BlockState state, Level level, BlockPos pos, Player player) {
        ItemStack held = player.m_21205_();
        if (Helpers.isItem((ItemStack)held, (Item)((Item)((RegistryObject)TFCItems.POWDERS.get(Powder.WOOD_ASH)).get()))) {
            FLHelpers.readInventory(level, pos, FLBlockEntities.ASHTRAY, (ashtray, inv) -> {
                InteractionResult res = FLHelpers.insertOne(level, held, 0, inv, player);
                if (res.m_19077_()) {
                    Helpers.playSound((Level)level, (BlockPos)pos, (SoundEvent)SoundEvents.f_12334_);
                }
                ashtray.updateBlockState();
            });
        }
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder.m_61104_(new Property[]{STAGE}));
    }
}

