/*
 * Decompiled with CFR 0.152.
 */
package com.eerussianguy.firmalife.common.blockentities;

import com.eerussianguy.firmalife.common.FLHelpers;
import com.eerussianguy.firmalife.common.blockentities.BoilingBlockEntity;
import com.eerussianguy.firmalife.common.blockentities.FLBlockEntities;
import com.eerussianguy.firmalife.common.blocks.VatBlock;
import com.eerussianguy.firmalife.common.items.FLItems;
import com.eerussianguy.firmalife.common.recipes.FLRecipeTypes;
import com.eerussianguy.firmalife.common.recipes.VatRecipe;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blockentities.InventoryBlockEntity;
import net.dries007.tfc.common.capabilities.FluidTankCallback;
import net.dries007.tfc.common.capabilities.InventoryFluidTank;
import net.dries007.tfc.common.capabilities.PartialItemHandler;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.Nullable;

public class VatBlockEntity
extends BoilingBlockEntity<VatInventory> {
    public static final int CAPACITY = 10000;
    @Nullable
    private VatRecipe cachedRecipe = null;

    public static void serverTick(Level level, BlockPos pos, BlockState state, VatBlockEntity vat) {
        List<ItemStack> excess;
        vat.checkForLastTickSync();
        vat.checkForCalendarUpdate();
        if (vat.needsRecipeUpdate) {
            vat.updateCachedRecipe();
        }
        if (!(excess = ((VatInventory)vat.inventory).excess).isEmpty() && ((VatInventory)vat.inventory).getStackInSlot(0).m_41619_()) {
            ((VatInventory)vat.inventory).setStackInSlot(0, excess.remove(0));
        }
        vat.handleJarring();
        vat.tickTemperature();
        vat.handleCooking();
    }

    public VatBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)FLBlockEntities.VAT.get(), pos, state, VatInventory::new, FLHelpers.blockEntityName("vat"));
        this.sidedInventory.on((Object)new PartialItemHandler(this.inventory).insert(new int[0]), (Predicate)Direction.Plane.HORIZONTAL);
    }

    public void handleJarring() {
        int maxFill;
        int jars;
        FluidStack fluid = ((VatInventory)this.inventory).getFluidInTank(0);
        ItemStack stack = ((VatInventory)this.inventory).getStackInSlot(0);
        if (fluid.hasTag() && fluid.getTag().m_128425_("fruit", 10) && Helpers.isItem((ItemStack)stack, (Item)((Item)FLItems.EMPTY_JAR.get())) && (jars = stack.m_41613_()) <= (maxFill = fluid.getAmount() / 500) && maxFill > 0) {
            ItemStack newStack = ItemStack.m_41712_((CompoundTag)fluid.getTag().m_128469_("fruit"));
            newStack.m_41764_(jars);
            ((VatInventory)this.inventory).setStackInSlot(0, newStack);
            ((VatInventory)this.inventory).drain(500 * jars, IFluidHandler.FluidAction.EXECUTE);
            this.markForSync();
        }
    }

    public void updateCachedRecipe() {
        assert (this.f_58857_ != null);
        this.cachedRecipe = ((VatInventory)this.inventory).excess.isEmpty() ? (VatRecipe)this.f_58857_.m_7465_().m_44015_((RecipeType)FLRecipeTypes.VAT.get(), (Container)((VatInventory)this.inventory), this.f_58857_).orElse(null) : null;
        this.needsRecipeUpdate = false;
    }

    public void handleCooking() {
        assert (this.f_58857_ != null);
        if (this.isBoiling()) {
            assert (this.cachedRecipe != null);
            if (this.boilingTicks < this.cachedRecipe.getDuration()) {
                ++this.boilingTicks;
                if (this.boilingTicks == 1) {
                    this.markForSync();
                }
            } else {
                VatRecipe recipe = this.cachedRecipe;
                this.cachedRecipe = null;
                recipe.assembleOutputs((VatInventory)this.inventory);
                this.boilingTicks = 0;
                this.updateCachedRecipe();
                this.markForSync();
                if (this.m_58900_().m_61138_((Property)VatBlock.SEALED)) {
                    this.f_58857_.m_46597_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_((Property)VatBlock.SEALED, (Comparable)Boolean.valueOf(false)));
                }
            }
        } else if (this.boilingTicks > 0) {
            this.boilingTicks = 0;
            this.markForSync();
        }
    }

    @Override
    public boolean isBoiling() {
        assert (this.f_58857_ != null);
        if (this.m_58900_().m_61138_((Property)VatBlock.SEALED) && !((Boolean)this.m_58900_().m_61143_((Property)VatBlock.SEALED)).booleanValue()) {
            return false;
        }
        if (this.f_58857_.f_46443_) {
            return this.boilingTicks > 0;
        }
        return this.cachedRecipe != null && this.temperature > this.cachedRecipe.getTemperature();
    }

    public static class VatInventory
    extends BoilingBlockEntity.BoilingInventory {
        private final List<ItemStack> excess = new ArrayList<ItemStack>();

        public VatInventory(InventoryBlockEntity<?> entity) {
            super(entity, 1, new InventoryFluidTank(10000, fluid -> Helpers.isFluid((Fluid)fluid.getFluid(), (TagKey)TFCTags.Fluids.USABLE_IN_POT), (FluidTankCallback)((VatBlockEntity)entity)));
        }

        public void insertItemWithOverflow(ItemStack stack) {
            ItemStack remainder = this.inventory.insertItem(0, stack, false);
            if (!remainder.m_41619_()) {
                this.excess.add(remainder);
            }
        }

        @Override
        public CompoundTag serializeNBT() {
            CompoundTag nbt = super.serializeNBT();
            FLHelpers.writeItemStackList(this.excess, nbt, "excess");
            return nbt;
        }

        @Override
        public void deserializeNBT(CompoundTag nbt) {
            super.deserializeNBT(nbt);
            FLHelpers.readItemStackList(this.excess, nbt, "excess");
        }
    }
}

