/*
 * Decompiled with CFR 0.152.
 */
package com.eerussianguy.firmalife.common.blockentities;

import com.eerussianguy.firmalife.common.blockentities.ApplianceBlockEntity;
import java.util.function.Predicate;
import net.dries007.tfc.common.blockentities.InventoryBlockEntity;
import net.dries007.tfc.common.capabilities.Capabilities;
import net.dries007.tfc.common.capabilities.DelegateFluidHandler;
import net.dries007.tfc.common.capabilities.FluidTankCallback;
import net.dries007.tfc.common.capabilities.InventoryFluidTank;
import net.dries007.tfc.common.capabilities.PartialFluidHandler;
import net.dries007.tfc.common.capabilities.SidedHandler;
import net.dries007.tfc.util.calendar.ICalendarTickable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BoilingBlockEntity<C extends IItemHandlerModifiable & INBTSerializable<CompoundTag> & IFluidHandler>
extends ApplianceBlockEntity<C>
implements ICalendarTickable,
FluidTankCallback {
    protected int boilingTicks = 0;
    protected boolean needsRecipeUpdate = true;
    private final SidedHandler.Builder<IFluidHandler> sidedFluidInventory = new SidedHandler.Builder((Object)((IFluidHandler)this.inventory));

    public BoilingBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state, InventoryBlockEntity.InventoryFactory<C> inventoryFactory, Component name) {
        super(type, pos, state, inventoryFactory, name);
        this.sidedFluidInventory.on((Object)new PartialFluidHandler((IFluidHandler)this.inventory).insert(), new Direction[]{Direction.UP}).on((Object)new PartialFluidHandler((IFluidHandler)this.inventory).extract(), (Predicate)Direction.Plane.HORIZONTAL);
    }

    @Override
    @NotNull
    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        if (cap == Capabilities.FLUID) {
            return this.sidedFluidInventory.getSidedHandler(side).cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    public void ranOutDueToCalendar() {
        this.boilingTicks = 0;
    }

    public void fluidTankChanged() {
        super.fluidTankChanged();
        this.needsRecipeUpdate = true;
    }

    public void setAndUpdateSlots(int slot) {
        super.setAndUpdateSlots(slot);
        this.needsRecipeUpdate = true;
    }

    @Override
    public void loadAdditional(CompoundTag nbt) {
        this.boilingTicks = nbt.m_128451_("boilingTicks");
        this.needsRecipeUpdate = true;
        super.loadAdditional(nbt);
    }

    @Override
    public void m_183515_(CompoundTag nbt) {
        nbt.m_128405_("boilingTicks", this.boilingTicks);
        super.m_183515_(nbt);
    }

    abstract boolean isBoiling();

    public static class BoilingInventory
    extends ApplianceBlockEntity.ApplianceInventory
    implements DelegateFluidHandler,
    FluidTankCallback {
        protected final InventoryFluidTank tank;
        private final BoilingBlockEntity<?> boiling;

        public BoilingInventory(InventoryBlockEntity<?> entity, int slots, InventoryFluidTank tank) {
            super(entity, slots);
            this.tank = tank;
            this.boiling = (BoilingBlockEntity)entity;
        }

        public IFluidHandler getFluidHandler() {
            return this.tank;
        }

        @NotNull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return this.boiling.isBoiling() ? ItemStack.f_41583_ : this.inventory.extractItem(slot, amount, simulate);
        }

        @Override
        public CompoundTag serializeNBT() {
            CompoundTag nbt = super.serializeNBT();
            nbt.m_128365_("tank", (Tag)this.tank.writeToNBT(new CompoundTag()));
            return nbt;
        }

        @Override
        public void deserializeNBT(CompoundTag nbt) {
            super.deserializeNBT(nbt);
            this.tank.readFromNBT(nbt.m_128469_("tank"));
        }
    }
}

