/*
 * Decompiled with CFR 0.152.
 */
package com.eerussianguy.firmalife.client.render;

import com.eerussianguy.firmalife.common.FLHelpers;
import com.eerussianguy.firmalife.common.blockentities.JarbnetBlockEntity;
import com.eerussianguy.firmalife.common.blocks.JarbnetBlock;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import net.dries007.tfc.common.capabilities.Capabilities;
import net.dries007.tfc.common.items.CandleBlockItem;
import net.dries007.tfc.common.items.JugItem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.CandleBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;

public class JarbnetBlockEntityRenderer
implements BlockEntityRenderer<JarbnetBlockEntity> {
    public static final ResourceLocation JUG_LOCATION = FLHelpers.identifier("block/jar_jug");
    public static final int[] CANDLE_AMOUNTS = new int[]{3, 1, 2, 2, 3, 1};

    public void render(JarbnetBlockEntity jarbnet, float partialTicks, PoseStack poseStack, MultiBufferSource buffers, int combinedLight, int combinedOverlay) {
        if (jarbnet.m_58900_().m_60734_() instanceof JarbnetBlock) {
            int angle;
            Direction facing = (Direction)jarbnet.m_58900_().m_61143_((Property)JarbnetBlock.FACING);
            switch (facing) {
                default: {
                    throw new IncompatibleClassChangeError();
                }
                case SOUTH: {
                    int n = 0;
                    break;
                }
                case EAST: {
                    int n = 90;
                    break;
                }
                case WEST: 
                case DOWN: 
                case UP: {
                    int n = 270;
                    break;
                }
                case NORTH: {
                    int n = angle = 180;
                }
            }
            if (((Boolean)jarbnet.m_58900_().m_61143_((Property)JarbnetBlock.OPEN)).booleanValue()) {
                jarbnet.getCapability(Capabilities.ITEM).ifPresent(inv -> {
                    poseStack.m_85836_();
                    poseStack.m_85837_(0.5, 0.5, 0.5);
                    poseStack.m_85841_(0.8f, 0.8f, 0.8f);
                    poseStack.m_85845_(Vector3f.f_122225_.m_122240_((float)angle));
                    BlockRenderDispatcher renderer = Minecraft.m_91087_().m_91289_();
                    for (int i = 0; i < 6; ++i) {
                        Item item = inv.getStackInSlot(i).m_41720_();
                        boolean isJug = item instanceof JugItem;
                        boolean isCandle = item instanceof CandleBlockItem;
                        poseStack.m_85836_();
                        int dx = i > 2 ? i - 3 : i;
                        poseStack.m_85837_((double)((float)dx * -0.35f - 0.4f), i > 2 ? (double)-0.53f : (double)0.02f, (double)-0.65f);
                        if (isCandle) {
                            poseStack.m_85837_((double)0.3f, 0.0, 0.0);
                        }
                        if (item instanceof BlockItem) {
                            BlockItem bi = (BlockItem)item;
                            BlockState state = bi.m_40614_().m_49966_();
                            if (isCandle) {
                                state = (BlockState)state.m_61124_((Property)CandleBlock.f_152790_, (Comparable)Integer.valueOf(CANDLE_AMOUNTS[i]));
                                if (((Boolean)jarbnet.m_58900_().m_61143_((Property)JarbnetBlock.LIT)).booleanValue()) {
                                    state = (BlockState)state.m_61124_((Property)CandleBlock.f_152791_, (Comparable)Boolean.valueOf(true));
                                }
                            }
                            renderer.renderSingleBlock(state, poseStack, buffers, combinedLight, combinedOverlay, (IModelData)EmptyModelData.INSTANCE);
                        } else if (isJug) {
                            Minecraft mc = Minecraft.m_91087_();
                            BakedModel baked = mc.m_91304_().getModel(JUG_LOCATION);
                            VertexConsumer buffer = buffers.m_6299_(RenderType.m_110463_());
                            mc.m_91289_().m_110937_().renderModel(poseStack.m_85850_(), buffer, null, baked, 1.0f, 1.0f, 1.0f, combinedLight, combinedOverlay, (IModelData)EmptyModelData.INSTANCE);
                        }
                        poseStack.m_85849_();
                    }
                    poseStack.m_85849_();
                });
            }
        }
    }
}

