/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gt5r.loader.machines;

import java.util.ArrayList;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.tuple.Pair;
import org.gtreimagined.gt5r.GT5RConfig;
import org.gtreimagined.gt5r.data.GT5RMaterialTags;
import org.gtreimagined.gt5r.data.GT5RTags;
import org.gtreimagined.gt5r.data.Materials;
import org.gtreimagined.gt5r.data.RecipeMaps;
import org.gtreimagined.gtcore.data.GTCoreItems;
import org.gtreimagined.gtlib.data.GTMaterialTypes;
import org.gtreimagined.gtlib.material.IMaterialTag;
import org.gtreimagined.gtlib.material.Material;
import org.gtreimagined.gtlib.material.MaterialTags;
import org.gtreimagined.gtlib.recipe.ingredient.FluidIngredient;
import org.gtreimagined.gtlib.recipe.ingredient.RecipeIngredient;
import org.gtreimagined.gtlib.recipe.map.RecipeBuilder;

public class ElectrolyzerLoader {
    public static void init() {
        ArrayList<Material> elecMaterials = new ArrayList<Material>(GT5RMaterialTags.ELEC.all().stream().toList());
        if (!GT5RConfig.HARDER_ALUMINIUM_PROCESSING.get()) {
            elecMaterials.add(Materials.Alumina);
        }
        elecMaterials.forEach(t -> {
            FluidStack[] fluids;
            if (!(t.has(new IMaterialTag[]{GTMaterialTypes.DUST}) || t.has(new IMaterialTag[]{GTMaterialTypes.LIQUID}) || t.has(new IMaterialTag[]{GTMaterialTypes.GAS}))) {
                return;
            }
            for (FluidStack fluid : fluids = (FluidStack[])t.getProcessInto().stream().filter(mat -> (mat.m.has(new IMaterialTag[]{GTMaterialTypes.GAS}) || mat.m.has(new IMaterialTag[]{GTMaterialTypes.LIQUID})) && !mat.m.has(new IMaterialTag[]{GTMaterialTypes.DUST})).map(mat -> mat.m.has(new IMaterialTag[]{GTMaterialTypes.GAS}) ? mat.m.getGas(mat.s * 1000) : mat.m.getLiquid(mat.s * 1000)).toArray(FluidStack[]::new)) {
                if (!fluid.isEmpty()) continue;
                return;
            }
            if (fluids.length > 6) {
                return;
            }
            int euPerTick = t.has(new IMaterialTag[]{GT5RMaterialTags.ELEC30}) ? 30 : (t.has(new IMaterialTag[]{GT5RMaterialTags.ELEC60}) || t == Materials.Alumina ? 60 : (t.has(new IMaterialTag[]{GT5RMaterialTags.ELEC90}) ? 90 : 120));
            ItemStack[] items = (ItemStack[])t.getProcessInto().stream().filter(mat -> mat.m.has(new IMaterialTag[]{GTMaterialTypes.DUST})).map(mat -> GTMaterialTypes.DUST.get(mat.m, mat.s)).toArray(ItemStack[]::new);
            int inputAmount = (Integer)((Pair)MaterialTags.PROCESS_INTO.get(t)).getRight() > 0 ? ((Integer)((Pair)MaterialTags.PROCESS_INTO.get(t)).getRight()).intValue() : t.getProcessInto().stream().mapToInt(mat -> mat.s).sum();
            RecipeBuilder b = RecipeMaps.ELECTROLYZER.RB();
            String prefix = "dust";
            if (t.has(new IMaterialTag[]{GTMaterialTypes.DUST})) {
                b.ii(new Ingredient[]{GTMaterialTypes.DUST.getMaterialIngredient(t, inputAmount)});
            } else {
                prefix = "fluid";
                b.fi(new FluidIngredient[]{t.getFluidIngredient(inputAmount * 1000)});
            }
            if (t.has(new IMaterialTag[]{GT5RMaterialTags.ELEC_CIRCUIT})) {
                b.ii(new Ingredient[]{(Ingredient)GTCoreItems.SELECTOR_TAG_INGREDIENTS.get((Object)1)});
            }
            long duration = t.has(new IMaterialTag[]{GT5RMaterialTags.ELEC_TICKS}) ? (long)GT5RMaterialTags.ELEC_TICKS.getInt(t) : t.getMass() * 20L;
            b.io(items).fo(fluids).add(prefix + "_" + t.getId(), duration, (long)euPerTick);
        });
        RecipeMaps.ELECTROLYZER.RB().ii(new Ingredient[]{GTMaterialTypes.DUST.getMaterialIngredient(Materials.SodiumBisulfate, 2), GTMaterialTypes.FINE_WIRE.getMaterialIngredient(Materials.Platinum, 1).setNoConsume()}).io(new Item[]{GTMaterialTypes.DUST.get(Materials.SodiumPersulfate)}).fo(new FluidStack[]{Materials.Hydrogen.getGas(1000)}).add("sodium_persulfate_creation", 600L, 30L);
        RecipeMaps.ELECTROLYZER.RB().ii(new Ingredient[]{RecipeIngredient.of((TagKey)ItemTags.f_13137_, (int)8)}).io(new Item[]{GTMaterialTypes.DUST.get(Materials.SiliconDioxide)}).add("sand_to_silicon_dioxide", 500L, 25L);
        RecipeMaps.ELECTROLYZER.RB().ii(new Ingredient[]{RecipeIngredient.of(GT5RTags.DUST_SANDS, (int)32)}).io(new Item[]{GTMaterialTypes.DUST.get(Materials.SiliconDioxide)}).add("sand_dusts_to_silicon_dioxide", 500L, 25L);
        RecipeMaps.ELECTROLYZER.RB().ii(new Ingredient[]{RecipeIngredient.of((ItemLike)Items.f_42499_, (int)3)}).io(new Item[]{GTMaterialTypes.DUST.get(Materials.Calcium)}).add("bone_meal", 98L, 26L);
        RecipeMaps.ELECTROLYZER.RB().ii(new Ingredient[]{GTMaterialTypes.DUST.getMaterialIngredient(Materials.Bentonite, 33)}).io(new ItemStack[]{GTMaterialTypes.SMALL_DUST.get(Materials.Sodium, 2), GTMaterialTypes.DUST.get(Materials.Magnesium, 3), GTMaterialTypes.DUST.get(Materials.Silicon, 6)}).fo(new FluidStack[]{Materials.Hydrogen.getGas(3000), Materials.Water.getLiquid(2500), Materials.Oxygen.getGas(18000)}).add("dust_bentonite", 240L, 120L);
        if (GT5RConfig.HARDER_ALUMINIUM_PROCESSING.get()) {
            RecipeMaps.ELECTROLYZER.RB().ii(new Ingredient[]{GTMaterialTypes.DUST.getMaterialIngredient(Materials.Carbon, 3), GTMaterialTypes.DUST.getMaterialIngredient(Materials.Alumina, 10)}).fi(new FluidStack[]{Materials.AluminiumFluoride.getLiquid(4), Materials.Cryolite.getLiquid(2)}).io(new ItemStack[]{GTMaterialTypes.DUST.get(Materials.Aluminium, 4)}).fo(new FluidStack[]{Materials.CarbonDioxide.getGas(9000), Materials.Fluorine.getGas(29)}).add("alumina_carbon", 2040L, 16L);
            RecipeMaps.ELECTROLYZER.RB().ii(new Ingredient[]{GTMaterialTypes.DUST.getMaterialIngredient(Materials.Charcoal, 3), GTMaterialTypes.DUST.getMaterialIngredient(Materials.Alumina, 10)}).fi(new FluidStack[]{Materials.AluminiumFluoride.getLiquid(4), Materials.Cryolite.getLiquid(2)}).io(new ItemStack[]{GTMaterialTypes.DUST.get(Materials.Aluminium, 4)}).fo(new FluidStack[]{Materials.CarbonDioxide.getGas(9000), Materials.Fluorine.getGas(29)}).add("alumina_charcoal", 2040L, 16L);
            RecipeMaps.ELECTROLYZER.RB().ii(new Ingredient[]{GTMaterialTypes.DUST.getMaterialIngredient(Materials.Coal, 3), GTMaterialTypes.DUST.getMaterialIngredient(Materials.Alumina, 10)}).fi(new FluidStack[]{Materials.AluminiumFluoride.getLiquid(4), Materials.Cryolite.getLiquid(2)}).io(new ItemStack[]{GTMaterialTypes.DUST.get(Materials.Aluminium, 4)}).fo(new FluidStack[]{Materials.CarbonDioxide.getGas(9000), Materials.Fluorine.getGas(29)}).add("alumina_coal", 2040L, 16L);
            RecipeMaps.ELECTROLYZER.RB().ii(new Ingredient[]{GTMaterialTypes.DUST.getMaterialIngredient(Materials.CoalCoke, 3), GTMaterialTypes.DUST.getMaterialIngredient(Materials.Alumina, 10)}).fi(new FluidStack[]{Materials.AluminiumFluoride.getLiquid(4), Materials.Cryolite.getLiquid(2)}).io(new ItemStack[]{GTMaterialTypes.DUST.get(Materials.Aluminium, 4)}).fo(new FluidStack[]{Materials.CarbonDioxide.getGas(9000), Materials.Fluorine.getGas(29)}).add("alumina_coke", 2040L, 16L);
            RecipeMaps.ELECTROLYZER.RB().ii(new Ingredient[]{GTMaterialTypes.DUST.getMaterialIngredient(Materials.Graphite, 3), GTMaterialTypes.DUST.getMaterialIngredient(Materials.Alumina, 10)}).fi(new FluidStack[]{Materials.AluminiumFluoride.getLiquid(4), Materials.Cryolite.getLiquid(2)}).io(new ItemStack[]{GTMaterialTypes.DUST.get(Materials.Aluminium, 4)}).fo(new FluidStack[]{Materials.CarbonDioxide.getGas(9000), Materials.Fluorine.getGas(29)}).add("alumina_graphite", 2040L, 16L);
            ElectrolyzerLoader.addVitriolRecipe(Materials.BlueVitriol, Materials.Copper);
            ElectrolyzerLoader.addVitriolRecipe(Materials.GreenVitriol, Materials.Iron);
            ElectrolyzerLoader.addVitriolRecipe(Materials.RedVitriol, Materials.Cobalt);
            ElectrolyzerLoader.addVitriolRecipe(Materials.PinkVitriol, Materials.Magnesium);
            ElectrolyzerLoader.addVitriolRecipe(Materials.CyanVitriol, Materials.Nickel);
            ElectrolyzerLoader.addVitriolRecipe(Materials.WhiteVitriol, Materials.Zinc);
            ElectrolyzerLoader.addVitriolRecipe(Materials.GrayVitriol, Materials.Manganese);
            RecipeMaps.ELECTROLYZER.RB().fi(new FluidStack[]{Materials.Water.getLiquid(900), Materials.VitriolOfClay.getLiquid(1700)}).ii(new Ingredient[]{(Ingredient)GTCoreItems.SELECTOR_TAG_INGREDIENTS.get((Object)1)}).io(new ItemStack[]{GTMaterialTypes.SMALL_DUST.get(Materials.Alumina, 2)}).fo(new FluidStack[]{Materials.SulfuricAcid.getLiquid(2100)}).add("vitriol_of_clay_to_alumina", 19L, 64L);
            RecipeMaps.ELECTROLYZER.RB().fi(new FluidStack[]{Materials.DistilledWater.getLiquid(900), Materials.VitriolOfClay.getLiquid(1700)}).ii(new Ingredient[]{(Ingredient)GTCoreItems.SELECTOR_TAG_INGREDIENTS.get((Object)1)}).io(new ItemStack[]{GTMaterialTypes.SMALL_DUST.get(Materials.Alumina, 2)}).fo(new FluidStack[]{Materials.SulfuricAcid.getLiquid(2100)}).add("vitriol_of_clay_to_alumina_distilled", 19L, 64L);
            RecipeMaps.ELECTROLYZER.RB().fi(new FluidStack[]{Materials.Water.getLiquid(6000), Materials.ChloroplatinicAcid.getLiquid(9000)}).ii(new Ingredient[]{(Ingredient)GTCoreItems.SELECTOR_TAG_INGREDIENTS.get((Object)2)}).io(new Item[]{GTMaterialTypes.DUST.get(Materials.Platinum)}).fo(new FluidStack[]{Materials.HydrochloricAcid.getLiquid(12000), Materials.Oxygen.getGas(2000)}).add("chloroplatinic_acid", 96L, 64L);
            RecipeMaps.ELECTROLYZER.RB().fi(new FluidStack[]{Materials.DistilledWater.getLiquid(6000), Materials.ChloroplatinicAcid.getLiquid(9000)}).ii(new Ingredient[]{(Ingredient)GTCoreItems.SELECTOR_TAG_INGREDIENTS.get((Object)2)}).io(new Item[]{GTMaterialTypes.DUST.get(Materials.Platinum)}).fo(new FluidStack[]{Materials.HydrochloricAcid.getLiquid(12000), Materials.Oxygen.getGas(2000)}).add("chloroplatinic_acid_distilled", 96L, 64L);
        }
    }

    private static void addVitriolRecipe(Material vitriol, Material dust) {
        RecipeMaps.ELECTROLYZER.RB().fi(new FluidStack[]{vitriol.getLiquid(6000), Materials.Water.getLiquid(3000)}).ii(new Ingredient[]{(Ingredient)GTCoreItems.SELECTOR_TAG_INGREDIENTS.get((Object)2)}).io(new Item[]{GTMaterialTypes.DUST.get(dust)}).fo(new FluidStack[]{Materials.SulfuricAcid.getLiquid(7000), Materials.Oxygen.getGas(1000)}).add(vitriol.getId() + "_to_" + dust.getId(), 64L, 64L);
        RecipeMaps.ELECTROLYZER.RB().fi(new FluidStack[]{vitriol.getLiquid(6000), Materials.DistilledWater.getLiquid(3000)}).ii(new Ingredient[]{(Ingredient)GTCoreItems.SELECTOR_TAG_INGREDIENTS.get((Object)2)}).io(new Item[]{GTMaterialTypes.DUST.get(dust)}).fo(new FluidStack[]{Materials.SulfuricAcid.getLiquid(7000), Materials.Oxygen.getGas(1000)}).add(vitriol.getId() + "_to_" + dust.getId() + "_distilled", 64L, 64L);
    }
}

