/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gt5r.items;

import java.util.function.Supplier;
import javax.annotation.Nullable;
import lombok.Generated;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.wrappers.FluidBucketWrapper;
import org.gtreimagined.gt5r.data.GT5RItems;
import org.gtreimagined.gtlib.GTAPI;
import org.gtreimagined.gtlib.Ref;
import org.gtreimagined.gtlib.datagen.builder.GTItemModelBuilder;
import org.gtreimagined.gtlib.datagen.providers.GTItemModelProvider;
import org.gtreimagined.gtlib.registration.IGTObject;
import org.gtreimagined.gtlib.registration.IModelProvider;
import org.gtreimagined.gtlib.registration.ITextureProvider;
import org.gtreimagined.gtlib.texture.Texture;
import org.jetbrains.annotations.NotNull;

public class ItemWoodenBucket
extends BucketItem
implements IGTObject,
ITextureProvider,
IModelProvider {
    private final String id;

    public ItemWoodenBucket(Supplier<? extends Fluid> supplier, String id) {
        super(supplier, new Item.Properties().m_41491_(Ref.TAB_ITEMS).m_41487_(1));
        this.id = id;
        GTAPI.register(ItemWoodenBucket.class, (IGTObject)this);
    }

    public String getDomain() {
        return "gt5r";
    }

    public Texture[] getTextures() {
        return new Texture[]{new Texture(this.getDomain(), "item/basic/" + this.getId())};
    }

    public int getItemStackLimit(ItemStack stack) {
        return this.getFluid() == Fluids.f_76191_ ? 16 : 1;
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        return new FluidBucketWrapper(stack){

            protected void setFluid(@NotNull FluidStack fluidStack) {
                if (fluidStack.isEmpty()) {
                    this.container = new ItemStack((ItemLike)GT5RItems.WOODEN_BUCKET);
                } else {
                    Item found = ItemWoodenBucket.findFilledBucket(fluidStack.getFluid());
                    if (found != Items.f_41852_) {
                        this.container = new ItemStack((ItemLike)found);
                    }
                }
            }

            public boolean isFluidValid(int tank, @NotNull FluidStack stack) {
                return ItemWoodenBucket.findFilledBucket(stack.getFluid()) != Items.f_41852_;
            }

            public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
                if (!this.isFluidValid(0, resource)) {
                    return 0;
                }
                return super.fill(resource, action);
            }
        };
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        BlockHitResult blockhitresult;
        ItemStack itemstack = player.m_21120_(hand);
        InteractionResultHolder ret = ForgeEventFactory.onBucketUse((Player)player, (Level)level, (ItemStack)itemstack, (HitResult)(blockhitresult = ItemWoodenBucket.m_41435_((Level)level, (Player)player, (ClipContext.Fluid)(this.getFluid() == Fluids.f_76191_ ? ClipContext.Fluid.SOURCE_ONLY : ClipContext.Fluid.NONE))));
        if (ret != null) {
            return ret;
        }
        if (blockhitresult.m_6662_() == HitResult.Type.MISS) {
            return InteractionResultHolder.m_19098_((Object)itemstack);
        }
        if (blockhitresult.m_6662_() != HitResult.Type.BLOCK) {
            return InteractionResultHolder.m_19098_((Object)itemstack);
        }
        BlockPos blockpos = blockhitresult.m_82425_();
        Direction direction = blockhitresult.m_82434_();
        BlockPos blockpos1 = blockpos.m_142300_(direction);
        if (level.m_7966_(player, blockpos) && player.m_36204_(blockpos1, direction, itemstack)) {
            BlockPos blockpos2;
            if (this.getFluid() == Fluids.f_76191_) {
                BucketItem bucketItem;
                Item bucket;
                Item item;
                BucketPickup bucketpickup;
                ItemStack forgeBucket;
                BlockState blockstate1 = level.m_8055_(blockpos);
                Block block = blockstate1.m_60734_();
                if (block instanceof BucketPickup && !(forgeBucket = (bucketpickup = (BucketPickup)block).m_142598_((LevelAccessor)level, blockpos, blockstate1)).m_41619_() && (item = forgeBucket.m_41720_()) instanceof BucketItem && (bucket = ItemWoodenBucket.findFilledBucket((bucketItem = (BucketItem)item).getFluid())) != Items.f_41852_) {
                    ItemStack bucketStack = new ItemStack((ItemLike)bucket);
                    player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
                    bucketpickup.getPickupSound(blockstate1).ifPresent(p_150709_ -> player.m_5496_(p_150709_, 1.0f, 1.0f));
                    level.m_142346_((Entity)player, GameEvent.f_157816_, blockpos);
                    ItemStack itemstack2 = ItemUtils.m_41813_((ItemStack)itemstack, (Player)player, (ItemStack)bucketStack);
                    if (!level.f_46443_) {
                        CriteriaTriggers.f_10576_.m_38772_((ServerPlayer)player, bucketStack);
                    }
                    return InteractionResultHolder.m_19092_((Object)itemstack2, (boolean)level.m_5776_());
                }
                return InteractionResultHolder.m_19100_((Object)itemstack);
            }
            BlockState blockstate = level.m_8055_(blockpos);
            BlockPos blockPos = blockpos2 = this.canBlockContainFluid(level, blockpos, blockstate) ? blockpos : blockpos1;
            if (this.m_142073_(player, level, blockpos2, blockhitresult)) {
                this.m_142131_(player, level, itemstack, blockpos2);
                if (player instanceof ServerPlayer) {
                    CriteriaTriggers.f_10591_.m_59469_((ServerPlayer)player, blockpos2, itemstack);
                }
                player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
                return InteractionResultHolder.m_19092_((Object)ItemWoodenBucket.getEmptyBucket(itemstack, player), (boolean)level.m_5776_());
            }
            return InteractionResultHolder.m_19100_((Object)itemstack);
        }
        return InteractionResultHolder.m_19100_((Object)itemstack);
    }

    public static InteractionResult fillBucket(BlockState blockState, Level level, BlockPos pos, Player player, InteractionHand hand, ItemStack stack) {
        if ((Integer)blockState.m_61143_((Property)LayeredCauldronBlock.f_153514_) != 3) {
            return InteractionResult.PASS;
        }
        if (!level.f_46443_) {
            Item item = stack.m_41720_();
            player.m_21008_(hand, ItemUtils.m_41813_((ItemStack)stack, (Player)player, (ItemStack)new ItemStack((ItemLike)GT5RItems.WOODEN_WATER_BUCKET)));
            player.m_36220_(Stats.f_12944_);
            player.m_36246_(Stats.f_12982_.m_12902_((Object)item));
            level.m_46597_(pos, Blocks.f_50256_.m_49966_());
            level.m_5594_(null, pos, SoundEvents.f_11781_, SoundSource.BLOCKS, 1.0f, 1.0f);
            level.m_142346_(null, GameEvent.f_157816_, pos);
        }
        return InteractionResult.m_19078_((boolean)level.f_46443_);
    }

    public static InteractionResult emptyBucket(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, ItemStack stack) {
        if (!level.f_46443_) {
            Item item = stack.m_41720_();
            player.m_21008_(hand, ItemUtils.m_41813_((ItemStack)stack, (Player)player, (ItemStack)new ItemStack((ItemLike)GT5RItems.WOODEN_BUCKET)));
            player.m_36220_(Stats.f_12943_);
            player.m_36246_(Stats.f_12982_.m_12902_((Object)item));
            level.m_46597_(pos, (BlockState)Blocks.f_152476_.m_49966_().m_61124_((Property)LayeredCauldronBlock.f_153514_, (Comparable)Integer.valueOf(3)));
            level.m_5594_(null, pos, SoundEvents.f_11778_, SoundSource.BLOCKS, 1.0f, 1.0f);
            level.m_142346_(null, GameEvent.f_157769_, pos);
        }
        return InteractionResult.m_19078_((boolean)level.f_46443_);
    }

    private boolean canBlockContainFluid(Level worldIn, BlockPos posIn, BlockState blockstate) {
        return blockstate.m_60734_() instanceof LiquidBlockContainer && ((LiquidBlockContainer)blockstate.m_60734_()).m_6044_((BlockGetter)worldIn, posIn, blockstate, this.getFluid());
    }

    private static ItemStack getEmptyBucket(ItemStack bucketStack, Player player) {
        return !player.m_150110_().f_35937_ ? new ItemStack((ItemLike)GT5RItems.WOODEN_BUCKET) : bucketStack;
    }

    private static Item findFilledBucket(Fluid fluid) {
        return GTAPI.all(ItemWoodenBucket.class).stream().filter(w -> w.getFluid() == fluid).findFirst().map(Item::m_5456_).orElse(Items.f_41852_);
    }

    public void onItemModelBuild(ItemLike item, GTItemModelProvider prov) {
        ((GTItemModelBuilder)prov.getGTBuilder(item).bucketProperties(this.getFluid(), true, false).parent(new ResourceLocation("gtlib:item/bucket"))).tex(map -> {
            String id = "wooden_bucket";
            map.put("base", this.getDomain() + ":item/basic/" + id);
            map.put("cover", this.getDomain() + ":item/other/" + id + "_cover");
            map.put("fluid", this.getDomain() + ":item/other/" + id + "_fluid");
        });
    }

    @Generated
    public String getId() {
        return this.id;
    }
}

