/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gt5r.integration.tfc.finishedrecipes;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Map;
import net.dries007.tfc.common.recipes.TFCRecipeSerializers;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import org.gtreimagined.gtlib.recipe.RecipeUtil;
import org.gtreimagined.gtlib.util.RegistryUtils;
import org.gtreimagined.gtlib.util.Utils;
import org.jetbrains.annotations.Nullable;

public record AdvancedShapedCraftingFinishedRecipe(ResourceLocation id, ItemStack result, int inputRow, int inputColumn, String[] modifiers, ImmutableMap<Character, Object> inputs, String[] pattern) implements FinishedRecipe
{
    public void m_7917_(JsonObject jsonObject) {
        if (this.inputs.isEmpty()) {
            Utils.onInvalidData((String)"Inputs should not be empty!");
        }
        if (this.pattern.length < 1 || this.pattern.length > 3) {
            Utils.onInvalidData((String)"Input pattern must have between 1 and 3 rows!");
        }
        JsonArray patternObject = new JsonArray();
        for (String s : this.pattern) {
            if (s.length() > 3) {
                Utils.onInvalidData((String)"Input pattern rows must have between 0 and 3 characters!");
            }
            patternObject.add(s);
        }
        jsonObject.add("pattern", (JsonElement)patternObject);
        jsonObject.add("key", (JsonElement)this.resolveKeys(this.inputs));
        JsonObject resultObject = new JsonObject();
        resultObject.add("stack", (JsonElement)RecipeUtil.itemstackToJson((ItemStack)this.result));
        JsonArray modifiers = new JsonArray();
        for (String m : this.modifiers) {
            modifiers.add(m);
        }
        if (!modifiers.isEmpty()) {
            resultObject.add("modifiers", (JsonElement)modifiers);
        }
        jsonObject.add("result", (JsonElement)resultObject);
        jsonObject.addProperty("input_row", (Number)this.inputRow);
        jsonObject.addProperty("input_column", (Number)this.inputColumn);
    }

    protected JsonObject resolveKeys(ImmutableMap<Character, Object> inputs) {
        JsonObject key = new JsonObject();
        for (Map.Entry entry : inputs.entrySet()) {
            JsonObject object = new JsonObject();
            Object v = entry.getValue();
            if (v instanceof ItemLike) {
                ItemLike l = (ItemLike)v;
                object.addProperty("item", RegistryUtils.getIdFromItem((Item)l.m_5456_()).toString());
            } else {
                v = entry.getValue();
                if (v instanceof ItemStack) {
                    ItemStack stack = (ItemStack)v;
                    object.addProperty("item", RegistryUtils.getIdFromItem((Item)stack.m_41720_()).toString());
                } else {
                    v = entry.getValue();
                    if (v instanceof TagKey) {
                        TagKey tagKey = (TagKey)v;
                        object.addProperty("tag", tagKey.f_203868_().toString());
                    } else {
                        v = entry.getValue();
                        if (v instanceof Ingredient) {
                            Ingredient i = (Ingredient)v;
                            object = i.m_43942_().getAsJsonObject();
                        }
                    }
                }
            }
            key.add(((Character)entry.getKey()).toString(), (JsonElement)object);
        }
        return key;
    }

    public ResourceLocation m_6445_() {
        return this.id;
    }

    public RecipeSerializer<?> m_6637_() {
        return (RecipeSerializer)TFCRecipeSerializers.ADVANCED_SHAPED_CRAFTING.get();
    }

    @Nullable
    public JsonObject m_5860_() {
        return null;
    }

    @Nullable
    public ResourceLocation m_6448_() {
        return null;
    }
}

