/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gt5r.integration.tfc.data;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import org.gtreimagined.gt5r.integration.tfc.behaviours.ProspectingBehaviour;
import org.gtreimagined.gt5r.integration.tfc.behaviours.ScythHarvestBehaviour;
import org.gtreimagined.gt5r.integration.tfc.data.TFCMaterialTypes;
import org.gtreimagined.gt5r.integration.tfc.item.MaterialJavelin;
import org.gtreimagined.gtlib.GTAPI;
import org.gtreimagined.gtlib.behaviour.IBehaviour;
import org.gtreimagined.gtlib.data.GTTools;
import org.gtreimagined.gtlib.material.IMaterialTag;
import org.gtreimagined.gtlib.material.MaterialTags;
import org.gtreimagined.gtlib.recipe.ingredient.PropertyIngredient;
import org.gtreimagined.gtlib.recipe.material.MaterialRecipe;
import org.gtreimagined.gtlib.registration.IGTObject;
import org.gtreimagined.gtlib.tool.GTToolType;
import org.gtreimagined.gtlib.tool.IGTTool;
import org.jetbrains.annotations.NotNull;

public class TFCToolTypes {
    public static final GTToolType PROPICK = ((GTToolType)GTAPI.register(GTToolType.class, (IGTObject)new GTToolType("gt5r", "propick", 1, 2, 10, 1.0f, -2.8f, false))).setHasContainer(false).setMaterialTypeItem(TFCMaterialTypes.PROPICK_HEAD).setMaterialTypeItemPredicate(m -> !m.has(new IMaterialTag[]{MaterialTags.FLINT}));
    public static final GTToolType JAVELIN = ((GTToolType)GTAPI.register(GTToolType.class, (IGTObject)new GTToolType("gt5r", "javelin", 2, 1, 10, 3.0f, -2.2f, false))).addEffectiveBlocks(new Block[]{Blocks.f_50033_}).setUseAction(UseAnim.SPEAR).setToolSupplier(MaterialJavelin::new).setMaterialTypeItem(TFCMaterialTypes.JAVELIN_HEAD);
    public static final MaterialRecipe.Provider PART_BUILDER = MaterialRecipe.registerProvider((String)"part_builder", (String)"gt5r", id -> new MaterialRecipe.ItemBuilder(){

        public ItemStack build(CraftingContainer inv, MaterialRecipe.Result mats) {
            int forgeQuality = (Integer)mats.mats.get("primary");
            ResourceLocation location = new ResourceLocation(id.replace('-', '_'));
            IGTTool type = (IGTTool)GTAPI.get(IGTTool.class, (String)location.m_135815_(), (String)location.m_135827_());
            ItemStack tool = type.asItemStack(type.getPrimaryMaterial(ItemStack.f_41583_), type.getSecondaryMaterial(ItemStack.f_41583_));
            if (forgeQuality > 0) {
                tool.m_41784_().m_128405_("tfc:forging_bonus", forgeQuality);
            }
            return tool;
        }

        public Map<String, Object> getFromResult(@NotNull ItemStack stack) {
            return ImmutableMap.of();
        }
    });

    public static void init() {
        GTTools.SCYTHE.addTags(new String[]{"hoe"}).addBehaviour(new IBehaviour[]{ScythHarvestBehaviour.INSTANCE});
        PROPICK.setCustomName("Prospector's Pick").addBehaviour(new IBehaviour[]{ProspectingBehaviour.INSTANCE});
    }

    public static void postInit() {
        GTToolType[] toolTypes = new GTToolType[]{GTTools.SWORD, GTTools.PICKAXE, GTTools.SHOVEL, GTTools.AXE, GTTools.HOE, GTTools.HAMMER, GTTools.SAW, GTTools.FILE, GTTools.KNIFE, GTTools.SCYTHE, PROPICK, JAVELIN};
        MaterialTags.TOOLS.getAll().forEach((m, t) -> {
            for (GTToolType toolType : toolTypes) {
                if (!t.toolTypes().contains(toolType) || !m.has(new IMaterialTag[]{toolType.getMaterialTypeItem()}) || toolType.getMaterialTypeItem() == null) continue;
                PropertyIngredient.addGetter((ResourceLocation)toolType.getMaterialTypeItem().getMaterialTag(m).f_203868_(), TFCToolTypes::getForgingBonus);
            }
        });
    }

    public static int getForgingBonus(ItemStack stack) {
        if (stack.m_41783_() != null && stack.m_41783_().m_128441_("tfc:forging_bonus")) {
            return stack.m_41783_().m_128451_("tfc:forging_bonus");
        }
        return 0;
    }
}

