/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gt5r.integration.tfc;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import it.unimi.dsi.fastutil.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.devtech.arrp.json.tags.JTag;
import net.dries007.tfc.common.blocks.rock.Ore;
import net.dries007.tfc.config.TFCConfig;
import net.minecraft.resources.ResourceLocation;
import org.gtreimagined.gt5r.data.Materials;
import org.gtreimagined.gt5r.integration.SpaceModRegistrar;
import org.gtreimagined.gtlib.GTAPI;
import org.gtreimagined.gtlib.datagen.GTLibDynamics;
import org.gtreimagined.gtlib.material.Material;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TFCOreGen {
    public static List<String> veins = new ArrayList<String>();
    public static List<ResourceLocation> veinsToRemove = new ArrayList<ResourceLocation>();

    public static void init() {
        String[] tfcVeinsToRemove;
        TFCOreGen.initTFCReplacements();
        TFCOreGen.initAdditions();
        JTag tag = JTag.tag();
        for (String vein : veins) {
            tag.add(new ResourceLocation("gt5r", "vein/" + vein));
        }
        for (String vein : tfcVeinsToRemove = new String[]{"normal_hematite", "deep_hematite", "normal_garnierite", "normal_malachite", "normal_magnetite", "deep_magnetite", "normal_limonite", "deep_limonite", "normal_sphalerite", "surface_sphalerite", "normal_tetrahedrite", "surface_tetrahedrite", "normal_native_copper", "surface_native_copper", "normal_native_silver", "cinnabar", "lapis_lazuli"}) {
            veinsToRemove.add(new ResourceLocation("tfc", "vein/" + vein));
        }
        if (GTAPI.isModLoaded((String)"firmalife")) {
            veinsToRemove.add(new ResourceLocation("firmalife", "vein/normal_chromite"));
            veinsToRemove.add(new ResourceLocation("firmalife", "vein/deep_chromite"));
        }
        GTLibDynamics.RUNTIME_DATA_PACK.addTag(new ResourceLocation("tfc", "worldgen/placed_feature/in_biome/veins"), tag);
    }

    public static void initTFCReplacements() {
        TFCOreGen.createClusterVein("surface_tetrahedrite", 20, 20, 0.5, 60, 210, TFCOreGen.ofM(TFCOreGen.ofOre(Ore.TETRAHEDRITE, Ore.Grade.POOR, 36), TFCOreGen.ofOre(Ore.TETRAHEDRITE, Ore.Grade.NORMAL, 18), TFCOreGen.ofOre(Ore.TETRAHEDRITE, Ore.Grade.RICH, 6), TFCOreGen.ofOre(Ore.NATIVE_COPPER, Ore.Grade.POOR, 12), TFCOreGen.ofOre(Ore.NATIVE_COPPER, Ore.Grade.NORMAL, 6), TFCOreGen.ofOre(Ore.NATIVE_COPPER, Ore.Grade.RICH, 2), TFCOreGen.ofOre(Materials.Stibnite, 20)), new String[]{"quartzite", "slate", "phyllite", "schist", "gneiss", "marble"}, new Indicator(12, TFCOreGen.ofRock(Ore.TETRAHEDRITE, 80), TFCOreGen.ofRock(Ore.NATIVE_COPPER, 20)));
        TFCOreGen.createClusterVein("surface_sphalerite", 20, 20, 0.5, 60, 210, TFCOreGen.ofM(TFCOreGen.ofOre(Ore.SPHALERITE, Ore.Grade.POOR, 36), TFCOreGen.ofOre(Ore.SPHALERITE, Ore.Grade.NORMAL, 18), TFCOreGen.ofOre(Ore.SPHALERITE, Ore.Grade.RICH, 6), TFCOreGen.ofOre(Materials.Chalcopyrite, 20), TFCOreGen.ofOre(Ore.PYRITE, 20)), new String[]{"quartzite", "slate", "phyllite", "schist", "gneiss", "marble"}, new Indicator(12, TFCOreGen.ofRock(Ore.SPHALERITE, 60), TFCOreGen.ofRock(Materials.Chalcopyrite, 20), TFCOreGen.ofRock(Ore.PYRITE, 20)));
        TFCOreGen.createClusterVein("surface_native_copper", 60, 20, 0.6, 60, 210, TFCOreGen.ofM(TFCOreGen.ofOre(Ore.NATIVE_COPPER, Ore.Grade.POOR, 42), TFCOreGen.ofOre(Ore.NATIVE_COPPER, Ore.Grade.NORMAL, 21), TFCOreGen.ofOre(Ore.NATIVE_COPPER, Ore.Grade.RICH, 7), TFCOreGen.ofOre(Ore.TETRAHEDRITE, Ore.Grade.POOR, 12), TFCOreGen.ofOre(Ore.TETRAHEDRITE, Ore.Grade.NORMAL, 6), TFCOreGen.ofOre(Ore.TETRAHEDRITE, Ore.Grade.RICH, 2), TFCOreGen.ofOre(Materials.Stibnite, 10)), new String[]{"rhyolite", "basalt", "andesite", "dacite"}, new Indicator(12, TFCOreGen.ofRock(Ore.NATIVE_COPPER, 70), TFCOreGen.ofRock(Ore.TETRAHEDRITE, 20), TFCOreGen.ofRock(Materials.Stibnite, 10)));
        TFCOreGen.createClusterVein("deep_magnetite", 100, 35, 0.7, -64, 30, TFCOreGen.ofM(TFCOreGen.ofOre(Ore.MAGNETITE, Ore.Grade.POOR, 7), TFCOreGen.ofOre(Ore.MAGNETITE, Ore.Grade.NORMAL, 21), TFCOreGen.ofOre(Ore.MAGNETITE, Ore.Grade.RICH, 42), TFCOreGen.ofOre(Ore.HEMATITE, Ore.Grade.POOR, 2), TFCOreGen.ofOre(Ore.HEMATITE, Ore.Grade.NORMAL, 6), TFCOreGen.ofOre(Ore.HEMATITE, Ore.Grade.RICH, 12), TFCOreGen.ofOre(Materials.VanadiumMagnetite, 10)), new String[]{"shale", "claystone", "limestone", "conglomerate", "dolomite", "chert", "chalk"}, new Indicator(12, TFCOreGen.ofRock(Ore.MAGNETITE, 70), TFCOreGen.ofRock(Ore.HEMATITE, 20), TFCOreGen.ofRock(Materials.VanadiumMagnetite, 10)));
        TFCOreGen.createClusterVein("deep_hematite", 100, 35, 0.7, -64, 30, TFCOreGen.ofM(TFCOreGen.ofOre(Ore.HEMATITE, Ore.Grade.POOR, 7), TFCOreGen.ofOre(Ore.HEMATITE, Ore.Grade.NORMAL, 21), TFCOreGen.ofOre(Ore.HEMATITE, Ore.Grade.RICH, 42), TFCOreGen.ofOre(Ore.MAGNETITE, Ore.Grade.POOR, 2), TFCOreGen.ofOre(Ore.MAGNETITE, Ore.Grade.NORMAL, 6), TFCOreGen.ofOre(Ore.MAGNETITE, Ore.Grade.RICH, 12), TFCOreGen.ofOre(Materials.VanadiumMagnetite, 10)), new String[]{"rhyolite", "andesite", "basalt", "dacite"}, new Indicator(12, TFCOreGen.ofRock(Ore.HEMATITE, 70), TFCOreGen.ofRock(Ore.MAGNETITE, 20), TFCOreGen.ofRock(Materials.VanadiumMagnetite, 10)));
        TFCOreGen.createClusterVein("deep_limonite", 100, 35, 0.7, -64, 30, TFCOreGen.ofM(TFCOreGen.ofOre(Ore.LIMONITE, Ore.Grade.POOR, 4), TFCOreGen.ofOre(Ore.LIMONITE, Ore.Grade.NORMAL, 12), TFCOreGen.ofOre(Ore.LIMONITE, Ore.Grade.RICH, 24), TFCOreGen.ofOre(Materials.BrownLimonite, 40), TFCOreGen.ofOre(Ore.HEMATITE, Ore.Grade.NORMAL, 4), TFCOreGen.ofOre(Ore.HEMATITE, Ore.Grade.RICH, 6), TFCOreGen.ofOre(Ore.MALACHITE, Ore.Grade.NORMAL, 4), TFCOreGen.ofOre(Ore.MALACHITE, Ore.Grade.RICH, 6)), new String[]{"shale", "claystone", "limestone", "conglomerate", "dolomite", "chert", "chalk"}, new Indicator(12, TFCOreGen.ofRock(Ore.LIMONITE, 40), TFCOreGen.ofRock(Materials.BrownLimonite, 40), TFCOreGen.ofRock(Ore.HEMATITE, 10), TFCOreGen.ofRock(Ore.MALACHITE, 10)));
        TFCOreGen.createClusterVein("normal_tetrahedrite", 60, 25, 0.6, -32, 75, TFCOreGen.ofM(TFCOreGen.ofOre(Ore.TETRAHEDRITE, Ore.Grade.POOR, 12), TFCOreGen.ofOre(Ore.TETRAHEDRITE, Ore.Grade.NORMAL, 30), TFCOreGen.ofOre(Ore.TETRAHEDRITE, Ore.Grade.RICH, 18), TFCOreGen.ofOre(Ore.NATIVE_COPPER, Ore.Grade.POOR, 4), TFCOreGen.ofOre(Ore.NATIVE_COPPER, Ore.Grade.NORMAL, 10), TFCOreGen.ofOre(Ore.NATIVE_COPPER, Ore.Grade.RICH, 6), TFCOreGen.ofOre(Materials.Stibnite, 20)), new String[]{"quartzite", "slate", "phyllite", "schist", "gneiss", "marble"}, new Indicator(12, TFCOreGen.ofRock(Ore.TETRAHEDRITE, 80), TFCOreGen.ofRock(Ore.NATIVE_COPPER, 20)));
        TFCOreGen.createClusterVein("normal_sphalerite", 60, 25, 0.6, -32, 75, TFCOreGen.ofM(TFCOreGen.ofOre(Ore.SPHALERITE, Ore.Grade.POOR, 12), TFCOreGen.ofOre(Ore.SPHALERITE, Ore.Grade.NORMAL, 30), TFCOreGen.ofOre(Ore.SPHALERITE, Ore.Grade.RICH, 18), TFCOreGen.ofOre(Ore.PYRITE, 20), TFCOreGen.ofOre(Materials.Chalcopyrite, 20)), new String[]{"quartzite", "slate", "phyllite", "schist", "gneiss", "marble"}, new Indicator(12, TFCOreGen.ofRock(Ore.SPHALERITE, 60), TFCOreGen.ofRock(Materials.Chalcopyrite, 20), TFCOreGen.ofRock(Ore.PYRITE, 20)));
        TFCOreGen.createClusterVein("normal_malachite", 60, 25, 0.6, -32, 75, TFCOreGen.ofM(TFCOreGen.ofOre(Ore.MALACHITE, Ore.Grade.POOR, 16), TFCOreGen.ofOre(Ore.MALACHITE, Ore.Grade.NORMAL, 40), TFCOreGen.ofOre(Ore.MALACHITE, Ore.Grade.RICH, 24), TFCOreGen.ofOre(Ore.LIMONITE, Ore.Grade.POOR, 4), TFCOreGen.ofOre(Ore.LIMONITE, Ore.Grade.NORMAL, 10), TFCOreGen.ofOre(Ore.LIMONITE, Ore.Grade.RICH, 6), TFCOreGen.ofOre(Ore.GYPSUM, null, 11, s -> s.equals("limestone"))), new String[]{"marble", "limestone"}, new Indicator(12, TFCOreGen.ofRock(Ore.MALACHITE, 80), TFCOreGen.ofRock(Ore.LIMONITE, 20)));
        TFCOreGen.createClusterVein("normal_magnetite", 60, 25, 0.6, -32, 75, TFCOreGen.ofM(TFCOreGen.ofOre(Ore.MAGNETITE, Ore.Grade.POOR, 14), TFCOreGen.ofOre(Ore.MAGNETITE, Ore.Grade.NORMAL, 35), TFCOreGen.ofOre(Ore.MAGNETITE, Ore.Grade.RICH, 21), TFCOreGen.ofOre(Ore.HEMATITE, Ore.Grade.POOR, 4), TFCOreGen.ofOre(Ore.HEMATITE, Ore.Grade.NORMAL, 10), TFCOreGen.ofOre(Ore.HEMATITE, Ore.Grade.RICH, 6), TFCOreGen.ofOre(Materials.VanadiumMagnetite, 10)), new String[]{"shale", "claystone", "limestone", "conglomerate", "dolomite", "chert", "chalk"}, new Indicator(12, TFCOreGen.ofRock(Ore.MAGNETITE, 70), TFCOreGen.ofRock(Ore.HEMATITE, 20), TFCOreGen.ofRock(Materials.VanadiumMagnetite, 10)));
        TFCOreGen.createClusterVein("normal_hematite", 60, 25, 0.6, -32, 75, TFCOreGen.ofM(TFCOreGen.ofOre(Ore.HEMATITE, Ore.Grade.POOR, 14), TFCOreGen.ofOre(Ore.HEMATITE, Ore.Grade.NORMAL, 35), TFCOreGen.ofOre(Ore.HEMATITE, Ore.Grade.RICH, 21), TFCOreGen.ofOre(Ore.MAGNETITE, Ore.Grade.POOR, 4), TFCOreGen.ofOre(Ore.MAGNETITE, Ore.Grade.NORMAL, 10), TFCOreGen.ofOre(Ore.MAGNETITE, Ore.Grade.RICH, 6), TFCOreGen.ofOre(Materials.VanadiumMagnetite, 10)), new String[]{"rhyolite", "andesite", "basalt", "dacite"}, new Indicator(12, TFCOreGen.ofRock(Ore.HEMATITE, 70), TFCOreGen.ofRock(Ore.MAGNETITE, 20), TFCOreGen.ofRock(Materials.VanadiumMagnetite, 10)));
        TFCOreGen.createClusterVein("normal_limonite", 60, 25, 0.6, -32, 75, TFCOreGen.ofM(TFCOreGen.ofOre(Ore.LIMONITE, Ore.Grade.POOR, 8), TFCOreGen.ofOre(Ore.LIMONITE, Ore.Grade.NORMAL, 20), TFCOreGen.ofOre(Ore.LIMONITE, Ore.Grade.RICH, 12), TFCOreGen.ofOre(Materials.BrownLimonite, 40), TFCOreGen.ofOre(Ore.HEMATITE, Ore.Grade.POOR, 2), TFCOreGen.ofOre(Ore.HEMATITE, Ore.Grade.NORMAL, 5), TFCOreGen.ofOre(Ore.HEMATITE, Ore.Grade.RICH, 3), TFCOreGen.ofOre(Ore.MALACHITE, Ore.Grade.POOR, 2), TFCOreGen.ofOre(Ore.MALACHITE, Ore.Grade.NORMAL, 5), TFCOreGen.ofOre(Ore.MALACHITE, Ore.Grade.POOR, 3)), new String[]{"shale", "claystone", "limestone", "conglomerate", "dolomite", "chert", "chalk"}, new Indicator(12, TFCOreGen.ofRock(Ore.LIMONITE, 40), TFCOreGen.ofRock(Materials.BrownLimonite, 40), TFCOreGen.ofRock(Ore.HEMATITE, 10), TFCOreGen.ofRock(Ore.MALACHITE, 10)));
        TFCOreGen.createClusterVein("normal_garnierite", 70, 20, 0.6, -32, 60, TFCOreGen.ofM(TFCOreGen.ofOre(Ore.GARNIERITE, Ore.Grade.POOR, 14), TFCOreGen.ofOre(Ore.GARNIERITE, Ore.Grade.NORMAL, 35), TFCOreGen.ofOre(Ore.GARNIERITE, Ore.Grade.RICH, 21), TFCOreGen.ofOre(Materials.Cobaltite, 20), TFCOreGen.ofOre(Materials.Pentlandite, 10)), new String[]{"gabbro"}, new Indicator(12, TFCOreGen.ofRock(Ore.GARNIERITE, 70), TFCOreGen.ofRock(Materials.Cobaltite, 20), TFCOreGen.ofRock(Materials.Pentlandite, 10)));
        TFCOreGen.createClusterVein("normal_native_silver", 60, 22, 0.6, -32, 75, TFCOreGen.ofM(TFCOreGen.ofOre(Ore.NATIVE_SILVER, Ore.Grade.POOR, 16), TFCOreGen.ofOre(Ore.NATIVE_SILVER, Ore.Grade.NORMAL, 40), TFCOreGen.ofOre(Ore.NATIVE_SILVER, Ore.Grade.RICH, 24), TFCOreGen.ofOre(Materials.Lead, 20)), new String[]{"granite", "gneiss"}, new Indicator(12, TFCOreGen.ofRock(Ore.NATIVE_SILVER, 80), TFCOreGen.ofRock(Materials.Lead, 20)));
        TFCOreGen.createClusterVein("normal_native_copper", 60, 25, 0.6, -32, 75, TFCOreGen.ofM(TFCOreGen.ofOre(Ore.NATIVE_COPPER, Ore.Grade.POOR, 14), TFCOreGen.ofOre(Ore.NATIVE_COPPER, Ore.Grade.NORMAL, 35), TFCOreGen.ofOre(Ore.NATIVE_COPPER, Ore.Grade.RICH, 21), TFCOreGen.ofOre(Ore.TETRAHEDRITE, Ore.Grade.POOR, 4), TFCOreGen.ofOre(Ore.TETRAHEDRITE, Ore.Grade.NORMAL, 10), TFCOreGen.ofOre(Ore.TETRAHEDRITE, Ore.Grade.RICH, 6), TFCOreGen.ofOre(Materials.Stibnite, 10)), new String[]{"rhyolite", "basalt", "andesite", "dacite"}, new Indicator(12, TFCOreGen.ofRock(Ore.NATIVE_COPPER, 70), TFCOreGen.ofRock(Ore.TETRAHEDRITE, 20), TFCOreGen.ofRock(Materials.Stibnite, 10)));
        TFCOreGen.createClusterVein("cinnabar", 120, 20, 0.6, -48, 100, TFCOreGen.ofM(TFCOreGen.ofOre(Materials.Redstone, 60), TFCOreGen.ofOre(Materials.Cinnabar, 30), TFCOreGen.ofOre(Materials.Ruby, 10)), new String[]{"rhyolite", "basalt", "andesite", "dacite", "quartzite", "shale"}, new Indicator(12, TFCOreGen.ofRock(Materials.Redstone, 60), TFCOreGen.ofRock(Materials.Cinnabar, 30), TFCOreGen.ofRock(Materials.Ruby, 10)));
        TFCOreGen.createClusterVein("lapis_lazuli", 120, 20, 0.6, -48, 100, TFCOreGen.ofM(TFCOreGen.ofOre(Materials.Lazurite, 35), TFCOreGen.ofOre(Materials.Sodalite, 35), TFCOreGen.ofOre(Materials.Lapis, 30)), new String[]{"limestone", "marble"}, null);
    }

    public static void initAdditions() {
        TFCOreGen.createClusterVein("surface_kaolinite", 60, 20, 0.6, 50, 210, TFCOreGen.ofM(TFCOreGen.ofOre(Ore.KAOLINITE, 1)), new String[]{"shale", "claystone", "limestone", "conglomerate", "dolomite", "chert", "chalk"}, new Indicator(12, TFCOreGen.ofRock(Material.get((String)"kaolinite"), 1)));
        TFCOreGen.createClusterVein("kaolinite", 60, 20, 0.6, 20, 60, TFCOreGen.ofM(TFCOreGen.ofOre(Ore.KAOLINITE, 1)), new String[]{"shale", "claystone", "limestone", "conglomerate", "dolomite", "chert", "chalk"}, new Indicator(12, TFCOreGen.ofRock(Material.get((String)"kaolinite"), 1)));
        TFCOreGen.createClusterVein("chalcopyrite", 90, 30, 0.6, -32, 60, TFCOreGen.ofM(TFCOreGen.ofOre(Materials.Chalcopyrite, 30), TFCOreGen.ofOre(Ore.PYRITE, 30), TFCOreGen.ofOre(Ore.HEMATITE, Ore.Grade.POOR, 6), TFCOreGen.ofOre(Ore.HEMATITE, Ore.Grade.NORMAL, 15), TFCOreGen.ofOre(Ore.HEMATITE, Ore.Grade.RICH, 9), TFCOreGen.ofOre(Ore.NATIVE_COPPER, Ore.Grade.NORMAL, 10)), new String[]{"shale", "claystone", "limestone", "conglomerate", "dolomite", "chert", "chalk"}, new Indicator(40, 12, TFCOreGen.ofRock(Materials.Chalcopyrite, 30), TFCOreGen.ofRock(Ore.HEMATITE, 30), TFCOreGen.ofRock(Ore.PYRITE, 30), TFCOreGen.ofRock(Ore.NATIVE_COPPER, 10)));
        TFCOreGen.createClusterVein("salts", 100, 15, 0.6, 0, 90, TFCOreGen.ofM(TFCOreGen.ofOre(Ore.SYLVITE, 35), TFCOreGen.ofOre(Ore.HALITE, 35), TFCOreGen.ofOre(Materials.Lepidolite, 20), TFCOreGen.ofOre(Materials.Spodumene, 10)), new String[]{"shale", "claystone", "limestone", "conglomerate", "dolomite", "chert", "chalk"}, new Indicator(40, 12, TFCOreGen.ofRock(Materials.Sylvite, 35), TFCOreGen.ofRock(Materials.Salt, 35), TFCOreGen.ofRock(Materials.Lepidolite, 20), TFCOreGen.ofRock(Materials.Spodumene, 10)));
        TFCOreGen.createClusterVein("pitchblende", 220, 24, 0.45, -64, -20, TFCOreGen.ofM(TFCOreGen.ofOre(Materials.Pitchblende, 60), TFCOreGen.ofOre(Materials.Uraninite, 40)), new String[]{"granite", "diorite", "gabbro"}, null);
        TFCOreGen.createClusterVein("soapstone", 120, 35, 0.6, -32, 48, TFCOreGen.ofM(TFCOreGen.ofOre(Materials.Soapstone, 35), TFCOreGen.ofOre(Materials.Talc, 35), TFCOreGen.ofOre(Materials.Glauconite, 20), TFCOreGen.ofOre(Materials.Pentlandite, 10)), new String[]{"quartzite", "slate", "phyllite", "schist", "gneiss", "marble"}, new Indicator(40, 12, TFCOreGen.ofRock(Materials.Soapstone, 35), TFCOreGen.ofRock(Materials.Talc, 35), TFCOreGen.ofRock(Materials.Glauconite, 20), TFCOreGen.ofRock(Materials.Pentlandite, 10)));
        TFCOreGen.createClusterVein("platinum", 300, 30, 0.3, -64, 0, TFCOreGen.ofM(TFCOreGen.ofOre(Materials.Sheldonite, 35), TFCOreGen.ofOre(Materials.Sperrylite, 35), TFCOreGen.ofOre(Materials.Platinum, 20), TFCOreGen.ofOre(Materials.Iridium, 10)), new String[]{"granite", "diorite", "gabbro"}, null);
        TFCOreGen.createClusterVein("chromite", 140, 25, 0.2, -32, 60, TFCOreGen.ofM(TFCOreGen.ofOre(Materials.Chromite, 1)), new String[]{"rhyolite", "basalt", "andesite", "dacite"}, null);
        TFCOreGen.createClusterVein("monazite", 185, 40, 0.25, -32, 50, TFCOreGen.ofM(TFCOreGen.ofOre(Materials.Bastnasite, 70), TFCOreGen.ofOre(Materials.Monazite, 20), TFCOreGen.ofOre(Materials.Neodymium, 10)), new String[]{"granite", "diorite", "gabbro"}, new Indicator(30, 12, TFCOreGen.ofRock(Materials.Bastnasite, 70), TFCOreGen.ofRock(Materials.Monazite, 20), TFCOreGen.ofRock(Materials.Neodymium, 10)));
        TFCOreGen.createClusterVein("molybdenum", 245, 26, 0.45, -64, 10, TFCOreGen.ofM(TFCOreGen.ofOre(Materials.Wulfenite, 35), TFCOreGen.ofOre(Materials.Molybdenite, 35), TFCOreGen.ofOre(Materials.Molybdenum, 20), TFCOreGen.ofOre(Materials.Powellite, 10)), new String[]{"rhyolite", "basalt", "andesite", "dacite", "granite", "diorite", "gabbro"}, null);
        TFCOreGen.createClusterVein("scheelite", 220, 28, 0.35, -64, 0, TFCOreGen.ofM(TFCOreGen.ofOre(Materials.Scheelite, 65), TFCOreGen.ofOre(Materials.Tungstate, 25), TFCOreGen.ofOre(Materials.Lithium, 10)), new String[]{"granite", "diorite", "gabbro"}, null);
        TFCOreGen.createDiscVein("sapphire", 180, 28, 8, 0.35, -64, 26, TFCOreGen.ofM(TFCOreGen.ofOre(Materials.Almandine, 35), TFCOreGen.ofOre(Materials.Pyrope, 35), TFCOreGen.ofOre(Materials.Sapphire, 15), TFCOreGen.ofOre(Materials.GreenSapphire, 15)), new String[]{"rhyolite", "basalt", "andesite", "dacite"}, null);
        TFCOreGen.createClusterVein("manganese", 195, 40, 0.3, -32, 60, TFCOreGen.ofM(TFCOreGen.ofOre(Materials.Grossular, 35), TFCOreGen.ofOre(Materials.Spessartine, 35), TFCOreGen.ofOre(Materials.Pyrolusite, 20), TFCOreGen.ofOre(Materials.Tantalite, 10)), new String[]{"rhyolite", "basalt", "andesite", "dacite", "shale", "claystone", "limestone", "conglomerate", "dolomite", "chert", "chalk"}, new Indicator(40, 12, TFCOreGen.ofRock(Materials.Grossular, 35), TFCOreGen.ofRock(Materials.Spessartine, 35), TFCOreGen.ofRock(Materials.Pyrolusite, 20), TFCOreGen.ofRock(Materials.Tantalite, 10)));
        WeightedBlock[] array = Materials.CertusQuartz.enabled ? TFCOreGen.ofM(TFCOreGen.ofOre(Materials.MilkyQuartz, 35), TFCOreGen.ofOre(Materials.CertusQuartz, 35), TFCOreGen.ofOre(Materials.Barite, 15), TFCOreGen.ofOre(Materials.Quartz, 15)) : TFCOreGen.ofM(TFCOreGen.ofOre(Materials.MilkyQuartz, 70), TFCOreGen.ofOre(Materials.Barite, 15), TFCOreGen.ofOre(Materials.Quartz, 15));
        TFCOreGen.createClusterVein("quartz", 150, 40, 0.3, -32, 100, array, new String[]{"shale", "quartzite", "schist", "gneiss"}, new Indicator(40, 15, array));
        TFCOreGen.createClusterVein("olivine", 180, 26, 0.25, -40, 30, TFCOreGen.ofM(TFCOreGen.ofOre(Materials.Bentonite, 35), TFCOreGen.ofOre(Materials.Magnesite, 35), TFCOreGen.ofOre(Materials.Olivine, 20), TFCOreGen.ofOre(Materials.Glauconite, 10)), new String[]{"rhyolite", "basalt", "andesite", "dacite", "granite", "diorite", "gabbro"}, new Indicator(12, TFCOreGen.ofRock(Materials.Bentonite, 35), TFCOreGen.ofRock(Materials.Magnesite, 35), TFCOreGen.ofRock(Materials.Olivine, 20), TFCOreGen.ofRock(Materials.Glauconite, 10)));
        TFCOreGen.createClusterVein("apatite", 110, 20, 0.5, 0, 180, TFCOreGen.ofM(TFCOreGen.ofOre(Materials.Apatite, 70), TFCOreGen.ofOre(Materials.TricalciumPhosphate, 20), TFCOreGen.ofOre(Materials.Phosphate, 10)), new String[]{"granite", "diorite", "gabbro", "quartzite", "slate", "phyllite", "schist", "gneiss", "marble"}, new Indicator(40, 12, TFCOreGen.ofRock(Materials.Apatite, 70), TFCOreGen.ofRock(Materials.TricalciumPhosphate, 20), TFCOreGen.ofRock(Materials.Phosphate, 10)));
        TFCOreGen.createClusterVein("galena", 160, 40, 0.4, -32, 75, TFCOreGen.ofM(TFCOreGen.ofOre(Materials.Galena, 60), TFCOreGen.ofOre(Materials.Lead, 10), TFCOreGen.ofOre(Ore.NATIVE_SILVER, Ore.Grade.POOR, 6), TFCOreGen.ofOre(Ore.NATIVE_SILVER, Ore.Grade.NORMAL, 15), TFCOreGen.ofOre(Ore.NATIVE_SILVER, Ore.Grade.RICH, 9)), new String[]{"granite", "gneiss"}, new Indicator(40, 12, TFCOreGen.ofRock(Materials.Galena, 60), TFCOreGen.ofRock(Ore.NATIVE_SILVER, 30), TFCOreGen.ofRock(Materials.Lead, 10)));
        TFCOreGen.createPipeVein("beryllium", 180, 10, 60, 6, 18, 0, 4, 0.0, 0.35, -32, 50, TFCOreGen.ofM(TFCOreGen.ofOre(Materials.Beryllium, 60), TFCOreGen.ofOre(Ore.EMERALD, 30), TFCOreGen.ofOre(Materials.Thorium, 10)), new String[]{"rhyolite", "basalt", "andesite", "dacite"}, new Indicator(40, 15, TFCOreGen.ofRock(Materials.Beryllium, 60), TFCOreGen.ofRock(Materials.Emerald, 30), TFCOreGen.ofRock(Materials.Thorium, 10)));
        TFCOreGen.createClusterVein("bauxite", 185, 40, 0.3, -32, 60, TFCOreGen.ofM(TFCOreGen.ofOre(Materials.Bauxite, 70), TFCOreGen.ofOre(Materials.Alumina, 20), TFCOreGen.ofOre(Materials.Ilmenite, 10)), new String[]{"shale", "claystone", "limestone", "conglomerate", "dolomite", "chert", "chalk"}, new Indicator(12, TFCOreGen.ofRock(Materials.Bauxite, 70), TFCOreGen.ofRock(Materials.Alumina, 20), TFCOreGen.ofRock(Materials.Ilmenite, 10)));
        TFCOreGen.createClusterVein("oil_shale", 185, 55, 0.2, 0, 60, TFCOreGen.ofM(TFCOreGen.ofOre(Materials.OilShale, 1)), new String[]{"shale", "claystone", "limestone", "conglomerate", "dolomite", "chert", "chalk"}, new Indicator(12, TFCOreGen.ofRock(Materials.OilShale, 1)));
        if (!GTAPI.isModLoaded((String)"beneath") && !((Boolean)TFCConfig.SERVER.enableNetherPortals.get()).booleanValue()) {
            TFCOreGen.createClusterVein("nether_materials", 150, 20, 0.6, 0, 60, TFCOreGen.ofM(new WeightedBlock(s -> "minecraft:glowstone", 90, s -> true), new WeightedBlock(s -> "minecraft:ancient_debris", 10, s -> true)), new String[]{"quartzite", "slate", "phyllite", "schist", "gneiss", "marble"}, null);
        }
        if (!SpaceModRegistrar.INSTANCE.isEnabled()) {
            TFCOreGen.createClusterVein("naquadah", 310, 32, 0.3, -64, -20, TFCOreGen.ofM(TFCOreGen.ofOre(Materials.Naquadah, 1)), new String[]{"quartzite", "slate", "phyllite", "schist", "gneiss", "marble"}, null);
        }
    }

    public static void createClusterVein(String id, int rarity, int size, double density, int minY, int maxY, WeightedBlock[] materials, String[] stones, Indicator indicator) {
        TFCOreGen.createVein("cluster", id, rarity, size, density, minY, maxY, materials, stones, indicator, new JsonObject());
    }

    public static void createDiscVein(String id, int rarity, int radius, int height, double density, int minY, int maxY, WeightedBlock[] materials, String[] stones, Indicator indicator) {
        JsonObject config = new JsonObject();
        config.addProperty("height", (Number)height);
        TFCOreGen.createVein("disc", id, rarity, radius, density, minY, maxY, materials, stones, indicator, config);
    }

    public static void createPipeVein(String id, int rarity, int radius, int height, int minSkew, int maxSkew, int minSlant, int maxSlant, double sign, double density, int minY, int maxY, WeightedBlock[] materials, String[] stones, Indicator indicator) {
        JsonObject config = new JsonObject();
        config.addProperty("radius", (Number)radius);
        config.addProperty("height", (Number)height);
        config.addProperty("minSkew", (Number)minSkew);
        config.addProperty("maxSkew", (Number)maxSkew);
        config.addProperty("minSlant", (Number)minSlant);
        config.addProperty("maxSlant", (Number)maxSlant);
        config.addProperty("sign", (Number)sign);
        TFCOreGen.createVein("disc", id, rarity, radius, density, minY, maxY, materials, stones, indicator, config);
    }

    public static void createVein(String type, String id, int rarity, int radius, double density, int minY, int maxY, WeightedBlock[] materials, String[] stones, Indicator indicator, JsonObject config) {
        JsonObject root = new JsonObject();
        root.addProperty("type", "tfc:" + type + "_vein");
        root.add("config", (JsonElement)config);
        TFCOreGen.addCommonValues(id, rarity, radius, density, minY, maxY, config);
        JsonArray blocks = new JsonArray();
        for (String stone : stones) {
            JsonObject block = TFCOreGen.getBlock(materials, stone);
            blocks.add((JsonElement)block);
        }
        config.add("blocks", (JsonElement)blocks);
        if (indicator != null) {
            JsonObject jIndicator = TFCOreGen.getIndicator(indicator);
            config.add("indicator", (JsonElement)jIndicator);
        }
        GTLibDynamics.RUNTIME_DATA_PACK.addData(new ResourceLocation("gt5r", "worldgen/configured_feature/vein/" + id + ".json"), root.toString().getBytes());
        TFCOreGen.createPlacedFeature(id);
    }

    private static void addCommonValues(String id, int rarity, int size, double density, int minY, int maxY, JsonObject config) {
        config.addProperty("rarity", (Number)rarity);
        config.addProperty("size", (Number)size);
        config.addProperty("density", (Number)density);
        JsonObject yObj = new JsonObject();
        yObj.addProperty("absolute", (Number)minY);
        config.add("min_y", (JsonElement)yObj);
        yObj = new JsonObject();
        yObj.addProperty("absolute", (Number)maxY);
        config.add("max_y", (JsonElement)yObj);
        config.addProperty("random_name", id);
    }

    private static void createPlacedFeature(String id) {
        JsonObject placed = new JsonObject();
        placed.addProperty("feature", "gt5r:vein/" + id);
        JsonArray placement = new JsonArray();
        placed.add("placement", (JsonElement)placement);
        GTLibDynamics.RUNTIME_DATA_PACK.addData(new ResourceLocation("gt5r", "worldgen/placed_feature/vein/" + id + ".json"), placed.toString().getBytes());
        veins.add(id);
    }

    @NotNull
    private static JsonObject getIndicator(@NotNull Indicator indicator) {
        JsonObject object = new JsonObject();
        object.addProperty("rarity", (Number)indicator.rarity);
        object.addProperty("depth", (Number)indicator.depth);
        JsonArray blocks = new JsonArray();
        for (Pair<String, Integer> block : indicator.blocks) {
            JsonObject b = new JsonObject();
            b.addProperty("block", (String)block.key());
            b.addProperty("weight", (Number)block.value());
            blocks.add((JsonElement)b);
        }
        object.add("blocks", (JsonElement)blocks);
        return object;
    }

    @NotNull
    private static JsonObject getBlock(WeightedBlock[] materials, String stone) {
        JsonObject block = new JsonObject();
        JsonArray replace = new JsonArray();
        replace.add("tfc:rock/raw/" + stone);
        block.add("replace", (JsonElement)replace);
        JsonArray with = new JsonArray();
        for (WeightedBlock material : materials) {
            if (!material.filter.test(stone)) continue;
            JsonObject materialBlock = new JsonObject();
            materialBlock.addProperty("block", material.block.apply(stone));
            materialBlock.addProperty("weight", (Number)material.weight);
            with.add((JsonElement)materialBlock);
        }
        block.add("with", (JsonElement)with);
        return block;
    }

    private static WeightedBlock[] ofM(WeightedBlock ... materials) {
        return materials;
    }

    private static WeightedBlock ofOre(Ore ore, @Nullable Ore.Grade grade, int weight, Predicate<String> filter) {
        return new WeightedBlock(s -> "tfc:ore/" + (String)(grade == null ? "" : grade.name().toLowerCase() + "_") + ore.name().toLowerCase() + "/" + s, weight, filter);
    }

    private static WeightedBlock ofOre(Ore ore, int weight) {
        return TFCOreGen.ofOre(ore, null, weight, s -> true);
    }

    private static WeightedBlock ofOre(Ore ore, Ore.Grade grade, int weight) {
        return TFCOreGen.ofOre(ore, grade, weight, s -> true);
    }

    private static WeightedBlock ofOre(Material material, int weight, Predicate<String> filter) {
        return new WeightedBlock(s -> "antimatter_shared:ore_" + material.getId() + "_raw_" + s, weight, filter);
    }

    private static WeightedBlock ofOre(Material material, int weight) {
        return TFCOreGen.ofOre(material, weight, s -> true);
    }

    private static WeightedBlock ofRock(Material material, int weight) {
        return new WeightedBlock(s -> "antimatter_shared:surface_rock_" + material.getId() + "_stone", weight, s -> true);
    }

    private static WeightedBlock ofRock(Ore ore, int weight) {
        return new WeightedBlock(s -> "tfc:ore/small_" + ore.name().toLowerCase(), weight, s -> true);
    }

    public record WeightedBlock(Function<String, String> block, int weight, Predicate<String> filter) {
    }

    public record Indicator(int depth, int rarity, List<Pair<String, Integer>> blocks) {
        public Indicator(int rarity, WeightedBlock ... blocks) {
            this(35, rarity, blocks);
        }

        public Indicator(int depth, int rarity, WeightedBlock ... blocks) {
            this(depth, rarity, Stream.of(blocks).map(w -> Pair.of((Object)w.block.apply(""), (Object)w.weight)).toList());
        }
    }
}

