/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gt5r.integration.tfc;

import java.util.Map;
import java.util.function.ToLongFunction;
import net.dries007.tfc.common.blocks.rock.Ore;
import net.dries007.tfc.common.blocks.wood.Wood;
import net.dries007.tfc.common.items.TFCItems;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.Metal;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.RegistryObject;
import org.gtreimagined.gt5r.GT5Reimagined;
import org.gtreimagined.gt5r.data.GT5RMaterialTags;
import org.gtreimagined.gt5r.data.Materials;
import org.gtreimagined.gt5r.data.RecipeMaps;
import org.gtreimagined.gt5r.integration.tfc.data.TFCMaterialTypes;
import org.gtreimagined.gt5r.loader.machines.CutterLoader;
import org.gtreimagined.gtcore.data.GTCoreItems;
import org.gtreimagined.gtcore.data.GTCoreTags;
import org.gtreimagined.gtcore.integration.tfc.TFCRubberData;
import org.gtreimagined.gtlib.data.GTMaterialTypes;
import org.gtreimagined.gtlib.material.IMaterialTag;
import org.gtreimagined.gtlib.material.Material;
import org.gtreimagined.gtlib.material.MaterialTags;
import org.gtreimagined.gtlib.recipe.ingredient.RecipeIngredient;
import org.gtreimagined.gtlib.util.RegistryUtils;
import org.gtreimagined.gtlib.util.TagUtils;
import org.gtreimagined.gtlib.util.Utils;

public class MachineRecipes {
    public static void init() {
        MachineRecipes.initMaceratorRecipes();
    }

    public static void initMaceratorRecipes() {
        MachineRecipes.addMaceratorRecipe(Ore.NATIVE_COPPER, Materials.Copper);
        MachineRecipes.addMaceratorRecipe(Ore.NATIVE_GOLD, Materials.Gold);
        MachineRecipes.addMaceratorRecipe(Ore.NATIVE_SILVER, Materials.Silver);
        MachineRecipes.addMaceratorRecipe(Ore.HEMATITE, Materials.Hematite);
        MachineRecipes.addMaceratorRecipe(Ore.CASSITERITE, Materials.Cassiterite);
        MachineRecipes.addMaceratorRecipe(Ore.BISMUTHINITE, Materials.Bismuth);
        MachineRecipes.addMaceratorRecipe(Ore.GARNIERITE, Materials.Garnierite);
        MachineRecipes.addMaceratorRecipe(Ore.MALACHITE, Materials.Malachite);
        MachineRecipes.addMaceratorRecipe(Ore.MAGNETITE, Materials.Magnetite);
        MachineRecipes.addMaceratorRecipe(Ore.LIMONITE, Materials.YellowLimonite);
        MachineRecipes.addMaceratorRecipe(Ore.SPHALERITE, Materials.Sphalerite);
        MachineRecipes.addMaceratorRecipe(Ore.TETRAHEDRITE, Materials.Tetrahedrite);
        MachineRecipes.addMaceratorRecipe(Ore.BITUMINOUS_COAL, Materials.Coal);
        MachineRecipes.addMaceratorRecipe(Ore.LIGNITE, Materials.Lignite);
        MachineRecipes.addMaceratorRecipe(Ore.GRAPHITE, Materials.Graphite);
        MachineRecipes.addMaceratorRecipe(Ore.SULFUR, Materials.Sulfur);
        MachineRecipes.addMaceratorRecipe(Ore.CINNABAR, Materials.Cinnabar);
        MachineRecipes.addMaceratorRecipe(Ore.CRYOLITE, Materials.Redstone);
        MachineRecipes.addMaceratorRecipe(Ore.SALTPETER, Materials.Saltpeter);
        MachineRecipes.addMaceratorRecipe(Ore.HALITE, Materials.Salt);
        MachineRecipes.addMaceratorRecipe(Ore.SYLVITE, Materials.Sylvite);
        MachineRecipes.addMaceratorRecipe(Ore.LAPIS_LAZULI, Materials.Lapis);
        MachineRecipes.addMaceratorRecipe(Ore.EMERALD, Materials.Emerald);
        MachineRecipes.addMaceratorRecipe(Ore.DIAMOND, Materials.Diamond);
        MachineRecipes.addMaceratorRecipe(Ore.PYRITE, Materials.Pyrite);
        MachineRecipes.addMaceratorRecipe(Ore.RUBY, Materials.Ruby);
        MachineRecipes.addMaceratorRecipe(Ore.SAPPHIRE, Materials.Sapphire);
        MachineRecipes.addMaceratorRecipe(Ore.TOPAZ, Materials.Topaz);
        MachineRecipes.addMaceratorRecipe(Ore.OPAL, Materials.Opal);
        MachineRecipes.addMaceratorRecipe(Ore.AMETHYST, Materials.Amethyst);
        Helpers.mapOfKeys(Wood.class, w -> {
            CutterLoader.addWoodRecipe((TagKey<Item>)TagUtils.getItemTag((ResourceLocation)new ResourceLocation("tfc", w.name().toLowerCase() + "_logs")), RegistryUtils.getItemFromID((String)"tfc", (String)("wood/lumber/" + w.name().toLowerCase())), 2, w.name().toLowerCase() + "_lumber", 200, 8);
            return true;
        });
        ToLongFunction<Material> baseDuration = m -> {
            if (m.has(new IMaterialTag[]{GT5RMaterialTags.RECIPE_MASS})) {
                return ((Integer)GT5RMaterialTags.RECIPE_MASS.get(m)).intValue();
            }
            return m.getMass();
        };
        TFCMaterialTypes.SHEET.all().stream().filter(m -> m.has(new IMaterialTag[]{GTMaterialTypes.INGOT})).forEach(material -> RecipeMaps.BENDER.RB().ii(new Ingredient[]{GTMaterialTypes.INGOT.getMaterialIngredient(material, 2), (Ingredient)GTCoreItems.SELECTOR_TAG_INGREDIENTS.get((Object)2)}).io(new Item[]{TFCMaterialTypes.SHEET.get(material)}).add(material.getId() + "_sheet", baseDuration.applyAsLong((Material)material) * 2L, 24L));
        Helpers.mapOfKeys(Metal.Default.class, d -> {
            Material material = Material.get((String)d.m_7912_());
            if (material != Material.NULL && material.has(new IMaterialTag[]{GTMaterialTypes.INGOT}) && d.hasParts()) {
                RecipeMaps.BENDER.RB().ii(new Ingredient[]{GTMaterialTypes.INGOT.getMaterialIngredient(material, 4), (Ingredient)GTCoreItems.SELECTOR_TAG_INGREDIENTS.get((Object)4)}).io(new Item[]{RegistryUtils.getItemFromID((String)"tfc", (String)("metal/double_sheet/" + material.getId()))}).add(material.getId() + "_double_sheet", baseDuration.applyAsLong(material) * 2L, 24L);
            }
            return true;
        });
        CutterLoader.addWoodRecipe((TagKey<Item>)GTCoreTags.RUBBER_LOGS, (Item)TFCRubberData.RUBBER_LUMBER, 2, "rubber_lumber", 200, 8);
        RecipeMaps.FLUID_PRESS.RB().ii(new Ingredient[]{RecipeIngredient.m_204132_((TagKey)TagUtils.getItemTag((ResourceLocation)new ResourceLocation("tfc:seeds")))}).fo(new FluidStack[]{Materials.SeedOil.getLiquid(10)}).add("seed_oil_tfc", 32L, 2L);
        RecipeMaps.FLUID_PRESS.RB().ii(new ItemLike[]{RegistryUtils.getItemFromID((String)"tfc", (String)"food/cod")}).fo(new FluidStack[]{Materials.FishOil.getLiquid(40)}).add("fish_oil_cod_tfc", 16L, 4L);
        RecipeMaps.FLUID_PRESS.RB().ii(new ItemLike[]{RegistryUtils.getItemFromID((String)"tfc", (String)"food/salmon")}).fo(new FluidStack[]{Materials.FishOil.getLiquid(60)}).add("fish_oil_salmon_tfc", 16L, 4L);
        RecipeMaps.FLUID_PRESS.RB().ii(new ItemLike[]{RegistryUtils.getItemFromID((String)"tfc", (String)"food/tropical_fish")}).fo(new FluidStack[]{Materials.FishOil.getLiquid(70)}).add("fish_oil_tropical_fish_tfc", 16L, 4L);
    }

    private static void addMaceratorRecipe(Ore input, Material material) {
        Material oreByProduct1;
        int multiplier = MaterialTags.ORE_MULTI.getInt(material);
        ItemStack crushedStack = GTMaterialTypes.CRUSHED_ORE.get(MaterialTags.MACERATE_INTO.getMapping(material), multiplier);
        Material material2 = oreByProduct1 = !material.getByProducts().isEmpty() ? (Material)material.getByProducts().get(0) : MaterialTags.MACERATE_INTO.getMapping(material);
        if (input.isGraded()) {
            RecipeMaps.PULVERIZER.RB().ii(new ItemLike[]{(ItemLike)((RegistryObject)((Map)TFCItems.GRADED_ORES.get(input)).get(Ore.Grade.POOR)).get()}).io(new ItemStack[]{crushedStack, GTMaterialTypes.DUST.get(oreByProduct1, 1)}).outputChances(new double[]{1.0, 0.05 * (double)multiplier}).tags(new String[]{"macerator_ore_processing"}).add("poor_" + material.getId() + "_tfc", 400L, 2L);
            RecipeMaps.PULVERIZER.RB().ii(new ItemLike[]{(ItemLike)((RegistryObject)((Map)TFCItems.GRADED_ORES.get(input)).get(Ore.Grade.NORMAL)).get()}).io(new ItemStack[]{Utils.ca((int)(multiplier * 2), (ItemStack)crushedStack), GTMaterialTypes.DUST.get(oreByProduct1, 1)}).outputChances(new double[]{1.0, 0.1 * (double)multiplier}).tags(new String[]{"macerator_ore_processing"}).add("normal_" + material.getId() + "_tfc", 400L, 2L);
            RecipeMaps.PULVERIZER.RB().ii(new ItemLike[]{(ItemLike)((RegistryObject)((Map)TFCItems.GRADED_ORES.get(input)).get(Ore.Grade.RICH)).get()}).io(new ItemStack[]{Utils.ca((int)(multiplier * 4), (ItemStack)crushedStack), GTMaterialTypes.DUST.get(oreByProduct1, 1)}).outputChances(new double[]{1.0, 0.15 * (double)multiplier}).tags(new String[]{"macerator_ore_processing"}).add("rich_" + material.getId() + "_tfc", 400L, 2L);
        } else {
            RecipeMaps.PULVERIZER.RB().ii(new ItemLike[]{(ItemLike)((RegistryObject)TFCItems.ORES.get(input)).get()}).io(new ItemStack[]{Utils.ca((int)(multiplier * 2), (ItemStack)crushedStack), GTMaterialTypes.DUST.get(oreByProduct1, 1)}).outputChances(new double[]{1.0, 0.1 * (double)multiplier}).tags(new String[]{"macerator_ore_processing"}).add("normal_" + material.getId() + "_tfc", 400L, 2L);
        }
    }

    private static void addMaceratorRecipe(Material material) {
        int multiplier = MaterialTags.ORE_MULTI.getInt(material);
        ItemStack crushedStack = GTMaterialTypes.CRUSHED_ORE.get(MaterialTags.MACERATE_INTO.getMapping(material), multiplier);
        Material oreByProduct1 = !material.getByProducts().isEmpty() ? (Material)material.getByProducts().get(0) : MaterialTags.MACERATE_INTO.getMapping(material);
        RecipeMaps.PULVERIZER.RB().ii(new ItemLike[]{(ItemLike)GT5Reimagined.get(Item.class, "poor_" + material.getId())}).io(new ItemStack[]{crushedStack, GTMaterialTypes.DUST.get(oreByProduct1, 1)}).outputChances(new double[]{1.0, 0.05 * (double)multiplier}).add("poor_" + material.getId() + "_tfc", 400L, 2L);
        RecipeMaps.PULVERIZER.RB().ii(new ItemLike[]{(ItemLike)GT5Reimagined.get(Item.class, "normal_" + material.getId())}).io(new ItemStack[]{Utils.ca((int)(multiplier * 2), (ItemStack)crushedStack), GTMaterialTypes.DUST.get(oreByProduct1, 1)}).outputChances(new double[]{1.0, 0.1 * (double)multiplier}).add("normal_" + material.getId() + "_tfc", 400L, 2L);
        RecipeMaps.PULVERIZER.RB().ii(new ItemLike[]{(ItemLike)GT5Reimagined.get(Item.class, "rich_" + material.getId())}).io(new ItemStack[]{Utils.ca((int)(multiplier * 3), (ItemStack)crushedStack), GTMaterialTypes.DUST.get(oreByProduct1, 1)}).outputChances(new double[]{1.0, 0.15 * (double)multiplier}).add("rich_" + material.getId() + "_tfc", 400L, 2L);
    }
}

