/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gt5r.integration.rei;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import lombok.Generated;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.entry.type.EntryType;
import me.shedaniel.rei.api.common.entry.type.VanillaEntryTypes;
import me.shedaniel.rei.api.common.util.EntryStacks;
import net.minecraft.world.item.crafting.Ingredient;
import org.gtreimagined.gt5r.data.GT5RMaterialTags;
import org.gtreimagined.gt5r.integration.rei.OreProcessingCategory;
import org.gtreimagined.gt5r.integration.xei.OreByProduct;
import org.gtreimagined.gtlib.data.GTMaterialTypes;
import org.gtreimagined.gtlib.material.IMaterialTag;
import org.gtreimagined.gtlib.material.Material;

public class OreProcessingDisplay
implements Display {
    OreByProduct oreByProduct;
    private final List<EntryIngredient> input;
    private final List<EntryIngredient> output;

    public OreProcessingDisplay(OreByProduct oreByProduct) {
        this.oreByProduct = oreByProduct;
        this.input = OreProcessingDisplay.createInputEntries(List.of(GTMaterialTypes.ORE.getMaterialIngredient(oreByProduct.material(), 1)));
        ArrayList<EntryStack> outputs = new ArrayList<EntryStack>();
        outputs.add(EntryStack.of((EntryType)VanillaEntryTypes.ITEM, (Object)GTMaterialTypes.CRUSHED_ORE.get(oreByProduct.getMacerateInto(), 1)));
        outputs.add(EntryStack.of((EntryType)VanillaEntryTypes.ITEM, (Object)GTMaterialTypes.PURIFIED_ORE.get(oreByProduct.getMacerateInto(), 1)));
        outputs.add(EntryStack.of((EntryType)VanillaEntryTypes.ITEM, (Object)GTMaterialTypes.REFINED_ORE.get(oreByProduct.getMacerateInto(), 1)));
        outputs.add(EntryStack.of((EntryType)VanillaEntryTypes.ITEM, (Object)GTMaterialTypes.IMPURE_DUST.get(oreByProduct.getMacerateInto(), 1)));
        outputs.add(EntryStack.of((EntryType)VanillaEntryTypes.ITEM, (Object)GTMaterialTypes.PURE_DUST.get(oreByProduct.getMacerateInto(), 1)));
        outputs.add(EntryStack.of((EntryType)VanillaEntryTypes.ITEM, (Object)GTMaterialTypes.DUST.get(oreByProduct.getMacerateInto(), 1)));
        if (!oreByProduct.material().getByProducts().isEmpty()) {
            for (Material byProduct : oreByProduct.material().getByProducts()) {
                outputs.add(EntryStack.of((EntryType)VanillaEntryTypes.ITEM, (Object)GTMaterialTypes.DUST.get(byProduct, 1)));
            }
        }
        if (oreByProduct.material().has(new IMaterialTag[]{GT5RMaterialTags.THERMAL_CENTRIFUGE_EXPLICIT})) {
            outputs.add(EntryStack.of((EntryType)VanillaEntryTypes.ITEM, (Object)GTMaterialTypes.DUST.get((Material)GT5RMaterialTags.THERMAL_CENTRIFUGE_EXPLICIT.get(oreByProduct.material()), 1)));
        }
        this.output = List.of(EntryIngredient.of(outputs));
    }

    public static List<EntryIngredient> createInputEntries(List<Ingredient> input) {
        return input.stream().map(i -> Arrays.stream(i.m_43908_()).map(EntryStacks::of).toList()).map(EntryIngredient::of).toList();
    }

    public List<EntryIngredient> getInputEntries() {
        return this.input;
    }

    public List<EntryIngredient> getOutputEntries() {
        return this.output;
    }

    public CategoryIdentifier<?> getCategoryIdentifier() {
        return OreProcessingCategory.id;
    }

    @Generated
    public OreByProduct getOreByProduct() {
        return this.oreByProduct;
    }
}

