/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gt5r.gui.widgets;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.gtreimagined.gt5r.blockentity.multi.BlockEntityFusionReactor;
import org.gtreimagined.gtlib.gui.GuiInstance;
import org.gtreimagined.gtlib.gui.ICanSyncData;
import org.gtreimagined.gtlib.gui.IGuiElement;
import org.gtreimagined.gtlib.gui.Widget;
import org.gtreimagined.gtlib.gui.widget.WidgetSupplier;
import org.gtreimagined.gtlib.integration.xei.GTLibXEIPlugin;
import org.gtreimagined.gtlib.machine.Tier;
import org.gtreimagined.gtlib.machine.types.Machine;
import org.gtreimagined.gtlib.util.Utils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FusionButtonWidget
extends Widget {
    ResourceLocation middle = new ResourceLocation("gt5r", "textures/gui/background/fusion_computer_middle_overlay.png");
    ResourceLocation top_bottom = new ResourceLocation("gt5r", "textures/gui/background/fusion_computer_top_bottom_overlay.png");
    BlockEntityFusionReactor.Display display = BlockEntityFusionReactor.Display.REGULAR;

    protected FusionButtonWidget(@NotNull GuiInstance gui, @Nullable IGuiElement parent) {
        super(gui, parent);
        this.setW(176);
        this.setH(182);
    }

    public void init() {
        this.gui.syncInt(() -> this.getTile().getDisplay().ordinal(), i -> {
            this.display = BlockEntityFusionReactor.Display.values()[i];
        }, ICanSyncData.SyncDirection.SERVER_TO_CLIENT);
    }

    private BlockEntityFusionReactor getTile() {
        return (BlockEntityFusionReactor)this.gui.handler;
    }

    public void onClick(double mouseX, double mouseY, int button) {
        super.onClick(mouseX, mouseY, button);
        if (this.isInside(154, 4, 18, 18, mouseX, mouseY)) {
            GTLibXEIPlugin.showCategory((Machine)this.getTile().getMachineType(), (Tier)this.getTile().getMachineTier());
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        return this.isInside(154, 4, 18, 18, mouseX, mouseY) && super.mouseClicked(mouseX, mouseY, button);
    }

    public void mouseOver(PoseStack stack, double mouseX, double mouseY, float partialTicks) {
        super.mouseOver(stack, mouseX, mouseY, partialTicks);
        if (this.isInside(154, 4, 18, 18, mouseX, mouseY)) {
            this.renderTooltip(stack, (Component)Utils.translatable((String)"gtlib.gui.show_recipes", (Object[])new Object[0]), mouseX, mouseY);
        }
    }

    public boolean isInside(int x, int y, int w, int h, double mouseX, double mouseY) {
        int realX = this.realX() + x;
        int realY = this.realY() + y;
        return mouseX >= (double)realX && mouseX <= (double)(realX + w) && mouseY >= (double)realY && mouseY <= (double)(realY + h);
    }

    public static WidgetSupplier build() {
        return FusionButtonWidget.builder(FusionButtonWidget::new);
    }

    public void render(PoseStack matrixStack, double mouseX, double mouseY, float partialTicks) {
        BlockEntityFusionReactor tile = this.getTile();
        if (this.display == BlockEntityFusionReactor.Display.REGULAR) {
            this.drawTexture(matrixStack, this.gui.handler.getGuiTexture(), this.realX() + 154, this.realY() + 22, 176, 0, 18, 18);
        } else if (this.display == BlockEntityFusionReactor.Display.MIDDLE) {
            this.drawTexture(matrixStack, this.gui.handler.getGuiTexture(), this.realX() + 154, this.realY() + 40, 176, 18, 18, 18);
            this.drawTexture(matrixStack, this.middle, this.realX() + 6, this.realY() + 6, 0, 0, 145, 145);
        } else {
            this.drawTexture(matrixStack, this.gui.handler.getGuiTexture(), this.realX() + 154, this.realY() + 58, 176, 36, 18, 18);
            this.drawTexture(matrixStack, this.top_bottom, this.realX() + 6, this.realY() + 6, 0, 0, 145, 145);
        }
    }
}

