/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gt5r.datagen;

import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import org.gtreimagined.gt5r.block.BlockAsphalt;
import org.gtreimagined.gt5r.block.BlockAsphaltSlab;
import org.gtreimagined.gt5r.block.BlockAsphaltStair;
import org.gtreimagined.gt5r.block.BlockBedrockFlower;
import org.gtreimagined.gt5r.block.BlockCasing;
import org.gtreimagined.gt5r.block.BlockCoil;
import org.gtreimagined.gt5r.block.BlockColoredWall;
import org.gtreimagined.gt5r.block.BlockFakeCasing;
import org.gtreimagined.gt5r.data.GT5RBlocks;
import org.gtreimagined.gt5r.data.GT5RCovers;
import org.gtreimagined.gt5r.data.GT5RItems;
import org.gtreimagined.gt5r.data.GT5RMachines;
import org.gtreimagined.gt5r.data.Materials;
import org.gtreimagined.gt5r.items.ItemDepletedRod;
import org.gtreimagined.gt5r.items.ItemNuclearFuelRod;
import org.gtreimagined.gt5r.items.ItemWoodenBucket;
import org.gtreimagined.gtlib.GTAPI;
import org.gtreimagined.gtlib.datagen.providers.GTLanguageProvider;
import org.gtreimagined.gtlib.item.ItemBasic;
import org.gtreimagined.gtlib.machine.Tier;
import org.gtreimagined.gtlib.machine.types.Machine;
import org.gtreimagined.gtlib.material.Material;
import org.gtreimagined.gtlib.registration.IGTObject;
import org.gtreimagined.gtlib.util.Utils;

public class GT5RLocalizations {

    public static class en_US
    extends GTLanguageProvider {
        public en_US() {
            super("gt5r", "GT5 Reimagined en_us Localization", "en_us");
        }

        protected void addTranslations() {
            super.addTranslations();
            this.add("gt5r.advancements.greg", "GT5 Reimagined");
            this.add("gt5r.advancements.greg.desc", "Getting familiar with your surroundings");
            this.add("gt5r.rei.tooltip.ore.byproducts", "Ore Byproducts Tree");
            this.add("gt5r.rei.tooltip.material_tree", "Material Tree");
            this.add("machine.transformer.voltage_info", "%s -> %s (Use Soft Hammer to invert)");
            this.add("machine.upgraded_batch.parallel", "Runs up to %s recipes at a time");
            this.add("gt5r.rotor.tooltip.efficiency", "Turbine Efficiency: %s");
            this.add("gt5r.rotor.tooltip.steam_flow", "Optimal Steam flow: %sL/sec");
            this.add("gt5r.rotor.tooltip.gas_flow", "Optimal Gas flow(EU burnvalue per tick): %sEU/t");
            this.add("tooltip.gt5r.redstone_mode.2", "Ignore Redstone");
            this.add("tooltip.gt5r.redstone_mode.1", "Invert Conditional");
            this.add("tooltip.gt5r.redstone_mode.0", "Conditional");
            this.add("tooltip.gt5r.redstone_mode.normal", "Normal");
            this.add("tooltip.gt5r.redstone_mode.inverted", "Inverted");
            this.add("tooltip.gt5r.export_mode.0", "Export");
            this.add("tooltip.gt5r.export_mode.1", "Import");
            this.add("tooltip.gt5r.export_mode.2", "Export allow Import");
            this.add("tooltip.gt5r.export_mode.3", "Import allow Export");
            this.add("tooltip.gt5r.filter_mode.0", "Filter on both Export and Import");
            this.add("tooltip.gt5r.filter_mode.1", "Filter on Import only");
            this.add("tooltip.gt5r.filter_mode.2", "Filter on Export only");
            this.add("tooltip.gt5r.whitelist", "Whitelist");
            this.add("tooltip.gt5r.blacklist", "Blacklist");
            this.add("tooltip.gt5r.nbt.on", "Don't ignore nbt");
            this.add("tooltip.gt5r.nbt.off", "Ignore nbt");
            this.add("tooltip.gt5r.data_stick.raw_prospection_data", "Raw Prospection Data");
            this.add("tooltip.gt5r.data_stick.analyzed_prospection_data", "Analyzed Prospection Data");
            this.add("tooltip.gt5r.data_stick.by", "By X: %s Z: %s Dim: %s");
            this.add("tooltip.gt5r.data_stick.blueprint", "Contains scanned blueprint");
            this.add("tooltip.gt5r.data_orb.elemental_scan", "Elemental Scan");
            this.add("tooltip.gt5r.coil.percentage", "Pyrolysis oven processing speed percentage: %s");
            this.add("tooltip.gt5r.coil.maxSimultaneousRecipes", "Max simultaneous recipes in Multismelter: %s");
            this.add("tooltip.gt5r.coil.autoclaveBoosts", "Large Autoclave processing speed: %s");
            this.add("tooltip.gt5r.depleted_rod.depleted", "Depleted");
            this.add("tooltip.gt5r.depleted_rod.0", "This Rod is %s and will not output or accept any Neutrons");
            this.add("tooltip.gt5r.depleted_rod.1", "Can be centrifuged to get valuable materials");
            this.add("tooltip.gt5r.enriched_rod.0", "Emits half the Heat per Neutron on this Rod");
            this.add("tooltip.gt5r.enriched_rod.1", "Breed from %s");
            this.add("tooltip.gt5r.breeder_rod.0", "Absorbs Neutrons to breed into an %s");
            this.add("tooltip.gt5r.breeder_rod.1", "Emits half the Heat per Neutron on this Rod");
            this.add("tooltip.gt5r.breeder_rod.2", "Can't breed with Neutrons from %s Fuel Rods");
            this.add("tooltip.gt5r.breeder_rod.3", "The %s value gets subtracted from Neutrons entering this Rod");
            this.add("tooltip.gt5r.breeder_rod.4", "This applies to each side where Neutrons enter, not to the total of all sides");
            this.add("tooltip.gt5r.breeder_rod.5", "Remaining Neurons on this Rod get added to the breeding process");
            this.add("tooltip.gt5r.breeder_rod.6", "Turns into: %s");
            this.add("tooltip.gt5r.breeder_rod.7", "Needed: %s %s");
            this.add("tooltip.gt5r.breeder_rod.8", "Loss: %s %s");
            this.add("tooltip.gt5r.breeder_rod.loss", "Loss");
            this.add("tooltip.gt5r.breeder_rod.neutrons", "Neutrons");
            this.add("tooltip.gt5r.breeder_rod.enriched", "Enriched Rod");
            this.add("tooltip.gt5r.nuclear_rod.emission_1", "Emission");
            this.add("tooltip.gt5r.nuclear_rod.self_1", "Self");
            this.add("tooltip.gt5r.nuclear_rod.maximum_1", "Maximum");
            this.add("tooltip.gt5r.nuclear_rod.factor_1", "Factor");
            this.add("tooltip.gt5r.nuclear_rod.emission_info", "The %s describes how many Neutrons are emitted to adjacent Rods");
            this.add("tooltip.gt5r.nuclear_rod.self_info", "The %s describes how many Neutrons naturally onto this Rod");
            this.add("tooltip.gt5r.nuclear_rod.maximum_info", "The %s describes how many Neutrons can be on this Rod while lasting the advertised duration");
            this.add("tooltip.gt5r.nuclear_rod.factor_info", "A greater %s means the Rod emits more extra Neutrons for the amount of Neutrons on it");
            this.add("tooltip.gt5r.nuclear_rod.remaining", "Remaining: %s Minutes");
            this.add("tooltip.gt5r.nuclear_rod.emission", "Emission: %s %s");
            this.add("tooltip.gt5r.nuclear_rod.self", "Self: %s %s");
            this.add("tooltip.gt5r.nuclear_rod.maximum", "Maximum: %s %s");
            this.add("tooltip.gt5r.nuclear_rod.neutrons", "Neutrons/t");
            this.add("tooltip.gt5r.nuclear_rod.factor", "Factor: %s");
            this.add("tooltip.gt5r.nuclear_rod.critical.0", "This fuel is %s");
            this.add("tooltip.gt5r.nuclear_rod.critical.1", "Critical");
            this.add("tooltip.gt5r.nuclear_rod.moderated.0", "Fuel rods will be %s");
            this.add("tooltip.gt5r.nuclear_rod.moderated.1", "Moderated");
            this.add("tooltip.gt5r.nuclear_rod.heat", "%s the heat per Neutron");
            this.add("tooltip.gt5r.nuclear_rod.when_used.1", "When used with %s:");
            this.add("tooltip.gt5r.nuclear_rod.when_used.2", "When used with %s or %s:");
            this.add("tooltip.gt5r.empty_nuclear_fuel_rod.0", "Empty Reactor Rod, transparent to Neutrons.");
            this.add("tooltip.gt5r.neutron_absorber_rod.0", "Absorbs Neutrons and emits twice the Heat per Neutron to Coolant");
            this.add("tooltip.gt5r.neutron_reflector_rod.0", "Reflects Neutrons back to their Source, boosting the Reaction");
            this.add("tooltip.gt5r.neutron_moderator_rod.0", "Reflects Neutrons back times the number of fuel rods touching when active");
            this.add("tooltip.gt5r.neutron_moderator_rod.1", "Touching Fuel Rods become moderated and moderate touching Fuel Rods");
            this.add("tooltip.gt5r.neutron_moderator_rod.2", "Moderated Fuel Rods can't be used for Breeding and only last a quarter as long");
            this.add("tooltip.gt5r.int_circuit.0", "Right click to cycle mode forward");
            this.add("tooltip.gt5r.int_circuit.1", "Shift right click to cycle mode backward");
            this.add("message.gt5r.nuclear_reactor.off", "Reactor Block is OFF");
            this.add("message.gt5r.nuclear_reactor.on", "Reactor Block is ON");
            this.add("message.gt5r.nuclear_reactor.neutron_levels", "Neutron Levels: %sn; %sn; %sn; %sn");
            this.add("message.gt5r.mini_portal.connect", "Target at: x: %s y: %s z: %s in %s");
            this.add("message.gt5r.redstone_mode.normal", "Redstone Mode: Normal");
            this.add("message.gt5r.redstone_mode.inverted", "Redstone Mode: Inverted");
            this.add("message.gt5r.needs_maintenance.scaled.normal", "Outputs a scaled signal");
            this.add("message.gt5r.needs_maintenance.scaled.inverted", "Outputs a scaled signal (Inverted)");
            this.add("message.gt5r.needs_maintenance.unscaled.normal", "Outputs a flat signal");
            this.add("message.gt5r.needs_maintenance.unscaled.inverted", "Outputs a flat signal (Inverted)");
            this.add("tooltip.gt5r.spray_can.full", "Full");
            this.add("tooltip.gt5r.spray_can.used", "Used");
            this.add("tooltip.gt5r.spray_can_chlorine", "Cleans dyed pipes.");
            this.add("tooltip.gt5r.spray_can.0", "Can color things in %s");
            this.add("tooltip.gt5r.spray_can.1", "Remaining uses: %s");
            this.add("tooltip.gt5r.diversity_filter.on", "Diversity Filter: ON");
            this.add("tooltip.gt5r.diversity_filter.off", "Diversity Filter: OFF");
            this.add("tooltip.gt5r.small_heat_exchanger.heat_rate", "Rate of heating: %s HU/tick");
            this.add("tooltip.gt5r.small_heat_exchanger.efficiency", "Efficiency: %s");
            this.add("tooltip.gt5r.boiler", "Generates Steam from water.");
            this.add("tooltip.macerator.0", "Crushes Raw ores down to crushed ore and byproducts. Macerator gives no byproducts, Pulverizer gives byproducts");
            this.add("tooltip.gt5r.input_hatch", "Fluid Input for Multiblocks");
            this.add("tooltip.gt5r.output_hatch", "Fluid Output for Multiblocks");
            this.add("tooltip.gt5r.input_bus", "Item Input for Multiblocks");
            this.add("tooltip.gt5r.output_bus", "Item Output for Multiblocks");
            this.add("tooltip.gt5r.secondary_input_hatch", "Coolant Input for Fusion");
            this.add("tooltip.gt5r.secondary_output_hatch", "Coolant Output for Fusion");
            this.add("text.gt5r.prospected_book", "Prospection Data From:\nX: %s Z: %s Dim: %s\nProduces %sL %s");
            this.add("jei.category.macerator_recycling", "Macerator Recycling");
            this.add("jei.category.macerator_ore_processing", "Macerator Ore Processing");
            this.add("jei.category.arc_furnace_recycling", "Arc Furnace Recycling");
            this.add("jei.category.alloy_smelter_molds", "Alloy Smelter Molds");
            this.add("jei.category.gt5r.ore_byproducts_tree", "Ore Byproducts Tree");
            this.add("block.gt5r.lava", "Lava");
            GTAPI.all(ItemWoodenBucket.class).forEach(i -> this.add((Item)i, Utils.lowerUnderscoreToUpperSpaced((String)i.getId())));
            this.structureTranslations();
            this.advancements();
        }

        private void structureTranslations() {
            this.add("tooltip.bedrock_drill.0", "Controller Block for the Bedrock Drill");
            this.add("tooltip.bedrock_drill.1", "Size(WxHxD):3x8x3");
            this.add("tooltip.bedrock_drill.2", "Controller (Front middle on second layer)");
            this.add("tooltip.bedrock_drill.3", "3x1x3 Base of Bedrock Drill Heads");
            this.add("tooltip.bedrock_drill.4", "3x1x3 layer of Titanium Casings");
            this.add("tooltip.bedrock_drill.5", "1x3x1 Titanium Casing Pillar (Center of second layer)");
            this.add("tooltip.bedrock_drill.6", "1x3x1 Titanium Frames (Each pillar side and on top)");
            this.add("tooltip.bedrock_drill.7", "1x Input Hatch for lubricant (Any second layer casing)");
            this.add("tooltip.bedrock_drill.8", "1x EV+ Energy Hatch (Any second layer casing)");
            this.add("tooltip.bedrock_drill.9", "1x Output Bus (Any second layer casing)");
            this.add("tooltip.bedrock_drill.10", "Will not form unless there is at least one bedrock ore underneath the drill heads");
            this.add("tooltip.bedrock_drill.11", "Mines bedrock ores underneath the Bedrock Drill Heads");
            this.add("tooltip.electric_blast_furnace.0", "Controller Block for the Electric Blast Furnace");
            this.add("tooltip.electric_blast_furnace.1", "Size(WxHxD): 3x4x3 (Hollow) Controller (Front middle bottom)");
            this.add("tooltip.electric_blast_furnace.2", "16x Heating Coils (2 middle Layers, hollow)");
            this.add("tooltip.electric_blast_furnace.3", "1x Input Bus (Any bottom layer casing)");
            this.add("tooltip.electric_blast_furnace.4", "1x Output Bus (Any bottom layer casing)");
            this.add("tooltip.electric_blast_furnace.5", "1x Energy Hatch (Any bottom layer casing)");
            this.add("tooltip.electric_blast_furnace.6", "1x Muffler Hatch (Top middle)");
            this.add("tooltip.electric_blast_furnace.7", "Heat Proof Casings for the rest");
            this.add("tooltip.electric_blast_furnace.8", "Each 900K over the min. Heat Capacity grants 5% speedup (multiplicatively)");
            this.add("tooltip.electric_blast_furnace.9", "Each 1800K over the min. Heat Capacity allows for one upgraded overclock");
            this.add("tooltip.electric_blast_furnace.10", "Upgraded overclocks reduce recipe time to 25% and increase EU/t to 400%");
            this.add("tooltip.combustion_engine.0", "Controller Block for the Large Combustion Engine");
            this.add("tooltip.combustion_engine.1", "Size(WxHxD): 3x3x4, Controller (front centered)");
            this.add("tooltip.combustion_engine.2", "3x3x4 of Stable Titanium Casing (hollow, Min 16!)");
            this.add("tooltip.combustion_engine.3", "2x Titanium Gear Box Casing inside the Hollow Casing");
            this.add("tooltip.combustion_engine.4", "8x Engine Intake Casings (around controller)");
            this.add("tooltip.combustion_engine.5", "2x Input Hatch (one of the Casings next to a gearbox)");
            this.add("tooltip.combustion_engine.6", "1x Muffler Hatch (Top middle back, next to the rear gearbox)");
            this.add("tooltip.combustion_engine.7", "1x Dynamo Hatch (back centered) ");
            this.add("tooltip.combustion_engine.8", "Engine Intake Casings not obstructed (only air blocks)");
            this.add("tooltip.combustion_engine.9", "Supply Flammable Fuels and 1000L of Lubricant per hour to run");
            this.add("tooltip.combustion_engine.10", "Supply 40L of Oxygen per second to boost output (optional)");
            this.add("tooltip.combustion_engine.11", "Default: Produces 2048EU/t at 100% efficiency");
            this.add("tooltip.combustion_engine.12", "Boosted: Produces 6144EU/t at 150% efficiency");
            this.add("tooltip.cracking_unit.0", "Controller Block for the Oil Cracking Unit");
            this.add("tooltip.cracking_unit.1", "Size(WxHxD): 5x3x3 (Hollow) Controller (Front center)");
            this.add("tooltip.cracking_unit.2", "Ring of 8 Cupronickel Coils (Each side of Controller)");
            this.add("tooltip.cracking_unit.3", "1x Input Hatch (Left side center casing)(For hydrocarbons");
            this.add("tooltip.cracking_unit.4", "1x Input Hatch (Any middle ring casing)(For steam/Hydrogen)");
            this.add("tooltip.cracking_unit.5", "1x Output Hatch (Right side center casing) (Outputs cracked product");
            this.add("tooltip.cracking_unit.6", "1x Energy Hatch (Any middle ring casing)");
            this.add("tooltip.cracking_unit.7", "Clean Stainless Steel Casings for the rest (18 at least!)");
            this.add("tooltip.cracking_unit.8", "Optional 1x Item Hatch Input or 1x Item Hatch Output  on the middle Ring Casings");
            this.add("tooltip.distillation_tower.0", "Controller Block for the Distillation Tower");
            this.add("tooltip.distillation_tower.1", "Size(WxHxD): 3xhx3(with h ranging from 3 to 12)");
            this.add("tooltip.distillation_tower.2", "Controller (Front bottom)");
            this.add("tooltip.distillation_tower.3", "1x Input Hatch (Any bottom layer casing)");
            this.add("tooltip.distillation_tower.4", "2-11x Output Hatch (One per layer except bottom layer)");
            this.add("tooltip.distillation_tower.5", "1x Output Bus (Any bottom layer casing)");
            this.add("tooltip.distillation_tower.6", "1x Energy Hatch (Any bottom layer casing)");
            this.add("tooltip.distillation_tower.7", "Clean Stainless Steel Casings for the rest (7 x h - 4 at least)");
            this.add("tooltip.cryo_distillation_tower.0", "Controller Block for the Cryo Distillation Tower");
            this.add("tooltip.cryo_distillation_tower.1", "Size(WxHxD): 3xhx3(with h ranging from 3 to 12)");
            this.add("tooltip.cryo_distillation_tower.2", "Controller (Front bottom)");
            this.add("tooltip.cryo_distillation_tower.3", "1x Input Hatch (Any bottom layer casing)");
            this.add("tooltip.cryo_distillation_tower.4", "2-11x Output Hatch (One per layer except bottom layer)");
            this.add("tooltip.cryo_distillation_tower.5", "1x Output Bus (Any bottom layer casing)");
            this.add("tooltip.cryo_distillation_tower.6", "1x Energy Hatch (Any bottom layer casing)");
            this.add("tooltip.cryo_distillation_tower.7", "Frostproof Casings for the rest (7 x h - 4 at least)");
            this.add("tooltip.large_heat_exchanger.0", "Controller Block for the Heat Exchanger");
            this.add("tooltip.large_heat_exchanger.1", "Size(WxHxD): 3x4x3, Controller (Front middle at bottom)");
            this.add("tooltip.large_heat_exchanger.2", "3x3x4 of Stable Titanium Casings (hollow, min 24!)");
            this.add("tooltip.large_heat_exchanger.3", "2x Titanium Pipe Casing (Inside the Hollow Machine Casings)");
            this.add("tooltip.large_heat_exchanger.4", "1x Distilled Water Input (Any mid layer casing)");
            this.add("tooltip.large_heat_exchanger.5", "1x Steam Output (Any mid layer casing)");
            this.add("tooltip.large_heat_exchanger.6", "1x Hot Fluid Input (Top Center)");
            this.add("tooltip.large_heat_exchanger.7", "1x Cold Fluid Output (Bottom Center)");
            this.add("tooltip.implosion_compressor.0", "Controller Block for the Implosion Compressor");
            this.add("tooltip.implosion_compressor.1", "Size(WxHxD): 3x3x3 (Hollow), Controller (Front centered)");
            this.add("tooltip.implosion_compressor.2", "1x Input Bus (Any casing)");
            this.add("tooltip.implosion_compressor.3", "1x Output Bus (Any casing)");
            this.add("tooltip.implosion_compressor.4", "1x Muffler Hatch (Any casing)");
            this.add("tooltip.implosion_compressor.5", "1x Energy Hatch (Any casing)");
            this.add("tooltip.implosion_compressor.6", "Solid Steel Casings for the rest (17 at least!)");
            this.add("tooltip.large_autoclave.0", "Controller Block for the LArge Autoclave");
            this.add("tooltip.large_autoclave.1", "Runs up to 16 Items at once");
            this.add("tooltip.large_autoclave.2", "Size(WxHxD):3x3x3 (Hollow), Controller (Front middle at bottom)");
            this.add("tooltip.large_autoclave.3", "1x Coil at Bottom center");
            this.add("tooltip.large_autoclave.4", "1x Input Bus (Any casing)");
            this.add("tooltip.large_autoclave.5", "1x Output Bus (Any casing)");
            this.add("tooltip.large_autoclave.6", "1x Input Hatch (Any casing)");
            this.add("tooltip.large_autoclave.7", "1x Energy Hatch (Any casing)");
            this.add("tooltip.large_autoclave.8", "Stainless Steel Casings for the rest");
            this.add("tooltip.large_bathing_vat.0", "Controller Block for the Large Bathing Vat");
            this.add("tooltip.large_bathing_vat.1", "Runs up to 64 Items at once");
            this.add("tooltip.large_bathing_vat.2", "Size(WxHxD): 5x2x5, Controller (Front middle at bottom)");
            this.add("tooltip.large_bathing_vat.3", "1x Input Bus (Any casing)");
            this.add("tooltip.large_bathing_vat.4", "1x Output Bus (Any casing)");
            this.add("tooltip.large_bathing_vat.5", "1x Input Hatch (Any casing)");
            this.add("tooltip.large_bathing_vat.6", "1-3x Output Hatch (Any casing, optional)");
            this.add("tooltip.large_bathing_vat.7", "Stainless Steel Walls for the rest (46 at most!)");
            this.add("tooltip.large_boiler.0", "Controller Block for the Large Boiler");
            this.add("tooltip.large_boiler.1", "Produces %sL of Steam with 1 Coal at %sL/s");
            this.add("tooltip.large_boiler.2", "A Selector tag in the main block throttles the boiler (-1000L/s per config)");
            this.add("tooltip.large_boiler.3", "Size(WxHxD): 3x5x3, Controller (Front middle in fireboxes)");
            this.add("tooltip.large_boiler.4", "3x1x3 of %s (Bottom layer, Min 4)");
            this.add("tooltip.large_boiler.5", "3x4x3 of %s (above Fireboxes, hollow, Min 24!)");
            this.add("tooltip.large_boiler.6", "1x3x1 of %s (Inside the Hollow Casings/Plated Bricks)");
            this.add("tooltip.large_boiler.7", "1x Fuel Input Hatch (Any Firebox)");
            this.add("tooltip.large_boiler.8", "1x Water Input Hatch (Any Firebox)");
            this.add("tooltip.large_boiler.9", "1x Steam Output Hatch (Any Casing)");
            this.add("tooltip.large_boiler.10", "1x Muffler Hatch (Any Firebox)");
            this.add("tooltip.large_boiler.11", "Diesel fuels have 1/4 efficiency");
            this.add("tooltip.large_boiler.12", "Takes %s seconds to heat up");
            this.add("tooltip.large_centrifuge.0", "Controller Block for the Large Centrifuge");
            this.add("tooltip.large_centrifuge.1", "Runs up to 16 recipes at a time");
            this.add("tooltip.large_centrifuge.2", "Size(WxHxD): 3x2x3, Controller (Front middle at bottom)");
            this.add("tooltip.large_centrifuge.3", "1x Input Hatch/Bus (Any casing except top middle)");
            this.add("tooltip.large_centrifuge.4", "1x Output Hatch/Bus (Any casing except top middle)");
            this.add("tooltip.large_centrifuge.5", "1x Energy Hatch (Any casing except top middle)");
            this.add("tooltip.large_centrifuge.6", "Tungstensteel Casings for the rest (14 at most!)");
            this.add("tooltip.large_chemical_reactor.0", "Controller Block for the Large Chemical Reactor");
            this.add("tooltip.large_chemical_reactor.1", "Runs up to 16 recipes at a time");
            this.add("tooltip.large_chemical_reactor.2", "Size(WxHxD): 3x3x3");
            this.add("tooltip.large_chemical_reactor.3", "3x3x3 of Chemically Inert Casings (hollow, min 8!)");
            this.add("tooltip.large_chemical_reactor.4", "Controller (Front centered)");
            this.add("tooltip.large_chemical_reactor.5", "1x PTFE Pipe Casing (inside the hollow casings)");
            this.add("tooltip.large_chemical_reactor.6", "1x Cupronickel Coil Block (Below the PTFE Pipe Casing)");
            this.add("tooltip.large_chemical_reactor.7", "1x Input Hatch/Bus (Any inert casing)");
            this.add("tooltip.large_chemical_reactor.8", "1x Output Hatch/Bus (Any inert casing)");
            this.add("tooltip.large_chemical_reactor.9", "1x Energy Hatch (Any inert casing)");
            this.add("tooltip.large_electrolyzer.0", "Controller Block for the Large Electrolyzer");
            this.add("tooltip.large_electrolyzer.1", "Runs up to x recipes at a time (x is dependent on the coils used)");
            this.add("tooltip.large_electrolyzer.2", "Size(WxHxD): 5x2x5, Controller (Front middle at bottom)");
            this.add("tooltip.large_electrolyzer.3", "3x3 of Electrolytic Cells in top middle");
            this.add("tooltip.large_electrolyzer.4", "6 Nichrome coils to the left and right of the electrolytic cells(3 per side)");
            this.add("tooltip.large_electrolyzer.5", "1x Input Hatch/Bus (Any casing except top middle)");
            this.add("tooltip.large_electrolyzer.6", "1x Output Hatch/Bus (Any casing except top middle)");
            this.add("tooltip.large_electrolyzer.7", "1x Energy Hatch (Any casing except top middle)");
            this.add("tooltip.large_electrolyzer.8", "Stainless Steel Casings for the rest (32 at most!)");
            this.add("tooltip.large_ore_washer.0", "Controller Block for the Large Ore Washer");
            this.add("tooltip.large_ore_washer.1", "Runs up to 8-4096 recipes at a time depending on the energy hatch tier(8 * 2\u02e3)");
            this.add("tooltip.large_ore_washer.2", "Size(WxHxD): 3x3x7, Controller (Front middle at bottom)");
            this.add("tooltip.large_ore_washer.3", "3x2x7 Base of Titanium Walls (37 at most!)");
            this.add("tooltip.large_ore_washer.4", "3x1x7 of Ore Washing Parts (On top of walls, exactly 21!)");
            this.add("tooltip.large_ore_washer.5", "1x Input Bus (Any Wall)");
            this.add("tooltip.large_ore_washer.6", "1x Input Hatch (Any Wall)");
            this.add("tooltip.large_ore_washer.7", "1x Output Bus (Any Wall)");
            this.add("tooltip.large_ore_washer.8", "1x Energy Hatch (Any Wall)");
            this.add("tooltip.large_pulverizer.0", "Controller Block for the Large Pulverizer(AKA Macerator)");
            this.add("tooltip.large_pulverizer.1", "Runs up to 16 recipes at a time");
            this.add("tooltip.large_pulverizer.2", "Size(WxHxD): 5x3x5, Controller (Front middle at bottom)");
            this.add("tooltip.large_pulverizer.3", "5x3x5 Basin of Tungstensteel Walls (Min 53!)");
            this.add("tooltip.large_pulverizer.4", "3x2x3 of Grinding Wheels (Inside basin, exactly 18!)");
            this.add("tooltip.large_pulverizer.5", "1x Input Bus (Any Casing)");
            this.add("tooltip.large_pulverizer.6", "1x Output Bus (Any Casing)");
            this.add("tooltip.large_pulverizer.7", "1x HV+ Energy Hatch (Any Casing)");
            this.add("tooltip.large_sifter.0", "Controller Block for the Large Sifter");
            this.add("tooltip.large_sifter.1", "Runs up to 64 recipes at a time");
            this.add("tooltip.large_sifter.2", "Size(WxHxD): 5x7x3 Controller (Front middle at bottom)");
            this.add("tooltip.large_sifter.3", "5x7x3 Basin of Titanium Casings (Max 78!)");
            this.add("tooltip.large_sifter.4", "3x6x1 of Filter Casings (Inside basin, exactly 18!)");
            this.add("tooltip.large_sifter.5", "1x Input Bus (Any Casing on top layer)");
            this.add("tooltip.large_sifter.6", "6x Output Bus (1 per layer except top layer)");
            this.add("tooltip.large_sifter.7", "1x HV+ Energy Hatch (Any Casing on bottom layer)");
            this.add("tooltip.large_turbine.0", "Controller Block for the %s");
            this.add("tooltip.large_turbine.1", "Size(WxHxD): 3x3x4 (Hollow), Controller (Front centered)");
            this.add("tooltip.large_turbine.2", "1x Input Hatch (Side centered)");
            this.add("tooltip.large_turbine.3", "1x Muffler Hatch (Side centered)");
            this.add("tooltip.large_turbine.4", "1x Dynamo Hatch (Back centered)");
            this.add("tooltip.large_turbine.5", "%s for the rest (24 at least!)");
            this.add("tooltip.large_turbine.6", "Needs a Turbine Item (Inside controller GUI)");
            this.add("tooltip.large_turbine.7", "Output depending on Rotor: %sEU/t");
            this.add("tooltip.multi_smelter.0", "Controller Block for the Multi Smelter");
            this.add("tooltip.multi_smelter.1", "Can make alloys if a selector tag with id of 1 is placed in the controller.");
            this.add("tooltip.multi_smelter.2", "Smelts up to 8-1024 Items at once");
            this.add("tooltip.multi_smelter.3", "Size(WxHxD):3x3x3 (Hollow), Controller (Front middle at bottom)");
            this.add("tooltip.multi_smelter.4", "8x Heating Coils (Middle layer, hollow)");
            this.add("tooltip.multi_smelter.5", "1x Input Bus (One of bottom)");
            this.add("tooltip.multi_smelter.6", "1x Output Bus (One of bottom)");
            this.add("tooltip.multi_smelter.7", "1x Muffler Hatch (Top middle)");
            this.add("tooltip.multi_smelter.8", "1x Energy Hatch (One of bottom)");
            this.add("tooltip.multi_smelter.9", "Heat Proof Casings for the rest");
            this.add("tooltip.oil_drilling_rig.0", "Controller Block for the Oil Drilling Rig");
            this.add("tooltip.oil_drilling_rig.1", "Size(WxHxD):3x7x3");
            this.add("tooltip.oil_drilling_rig.2", "Controller (Front middle at bottom)");
            this.add("tooltip.oil_drilling_rig.3", "3x1x3 Base of Solid Steel Casings");
            this.add("tooltip.oil_drilling_rig.4", "1x3x1 Solid Steel Casing Pillar (Center of base)");
            this.add("tooltip.oil_drilling_rig.5", "1x3x1 Steel Frames (Each pillar side and on top)");
            this.add("tooltip.oil_drilling_rig.6", "1x Output Hatch (Any bottom layer casing)");
            this.add("tooltip.oil_drilling_rig.7", "1x MV+ Energy Hatch (Any bottom layer casing)");
            this.add("tooltip.oil_drilling_rig.8", "1x Output Bus (Any bottom layer casing, optional)");
            this.add("tooltip.ore_mining_rig.0", "Controller Block for the Ore Mining Rig");
            this.add("tooltip.ore_mining_rig.1", "Formerly known as Advanced Miner II in gt5u");
            this.add("tooltip.ore_mining_rig.2", "Size(WxHxD):3x7x3");
            this.add("tooltip.ore_mining_rig.3", "Controller (Front middle at bottom)");
            this.add("tooltip.ore_mining_rig.4", "3x1x3 Base of Solid Steel Casings");
            this.add("tooltip.ore_mining_rig.5", "1x3x1 Solid Steel Casing Pillar (Center of base)");
            this.add("tooltip.ore_mining_rig.6", "1x3x1 Steel Frames (Each pillar side and on top)");
            this.add("tooltip.ore_mining_rig.7", "1x Input Hatch for drilling fluid (Any bottom layer casing)");
            this.add("tooltip.ore_mining_rig.8", "1x MV+ Energy Hatch (Any bottom layer casing)");
            this.add("tooltip.ore_mining_rig.9", "1x Output Bus (Any bottom layer casing)");
            this.add("tooltip.ore_mining_rig.10", "Mines a 3x3 chunk area around the mining pipe");
            this.add("tooltip.processing_array.0", "Controller Block for the Processing Array");
            this.add("tooltip.processing_array.1", "Runs supplied machines as if placed in the world");
            this.add("tooltip.processing_array.2", "Size(WxHxD):3x3x3 (Hollow), Controller (Front centered)");
            this.add("tooltip.processing_array.3", "1x Input Hatch/Bus (Any casing)");
            this.add("tooltip.processing_array.4", "1x Output Hatch/Bus (Any Casing)");
            this.add("tooltip.processing_array.5", "1x Energy Hatch (Any Casing)");
            this.add("tooltip.processing_array.6", "Robust Tungstensteel Casings for the rest");
            this.add("tooltip.processing_array.7", "Place up to 16 Single Block Machines into the GUI Inventory");
            this.add("tooltip.pyrolyse_oven.0", "Controller Block for the Pyrolyse Oven");
            this.add("tooltip.pyrolyse_oven.1", "Industrial Charcoal producer and Oil from Plants");
            this.add("tooltip.pyrolyse_oven.2", "Size(WxHxD):5x4x5 (Hollow), Controller (Bottom center)");
            this.add("tooltip.pyrolyse_oven.3", "3x1x3 of Coil Blocks (At the center of the bottom layer)");
            this.add("tooltip.pyrolyse_oven.4", "1x Input Hatch/Bus (Centered 3x1x3 area in Top layer)");
            this.add("tooltip.pyrolyse_oven.5", "1x Output Hatch/Bus (Any bottom layer Casing)");
            this.add("tooltip.pyrolyse_oven.6", "1x Muffler Hatch (Centered 3x1x3 area in Top layer)");
            this.add("tooltip.pyrolyse_oven.7", "1x Energy Hatch (Any bottom layer casing)");
            this.add("tooltip.pyrolyse_oven.8", "ULV Machine Casings for the rest (60 at least!)");
            this.add("tooltip.pyrolyse_oven.9", "Processing speed scales linearly with Coil tier:");
            this.add("tooltip.pyrolyse_oven.10", "CuN: 50%, FeAlCr: 100%, Ni4Cr: 150%, Fe50CW: 200%, ect.");
            this.add("tooltip.pyrolyse_oven.11", "EU/t is not affected by Coil tier");
            this.add("tooltip.tree_growth_simulator.0", "Controller Block for the Tree Growth Simulator");
            this.add("tooltip.tree_growth_simulator.1", "Size(WxHxD):5x9x5");
            this.add("tooltip.tree_growth_simulator.2", "Controller (Front middle at bottom)");
            this.add("tooltip.tree_growth_simulator.3", "5x1x5 Base of Black Bronze Casings");
            this.add("tooltip.tree_growth_simulator.4", "5x7x5 ring of Plastic Casings (hollow)");
            this.add("tooltip.tree_growth_simulator.5", "5x1x5 Layer of Plastic Casings at Top layer");
            this.add("tooltip.tree_growth_simulator.6", "3x1x3 centered layer of Dirt on top of the Black Bronze Casings");
            this.add("tooltip.tree_growth_simulator.7", "1x Input Hatch for water (Any Black Bronze Casing)");
            this.add("tooltip.tree_growth_simulator.8", "1x Input Bus (Any Black Bronze Casing)");
            this.add("tooltip.tree_growth_simulator.9", "1x Output Bus (Any Plastic Casing)");
            this.add("tooltip.tree_growth_simulator.10", "1x Energy Hatch (Any Plastic Casing)");
            this.add("tooltip.tree_growth_simulator.11", "Grows trees using fertilizer and water");
            this.add("tooltip.vacuum_freezer.0", "Controller Block for the Vacuum Freezer");
            this.add("tooltip.vacuum_freezer.1", "Super cools hot ingots and gases like Nitrogen");
            this.add("tooltip.vacuum_freezer.2", "Size(WxHxD):3x3x3 (Hollow), Controller (Front centered)");
            this.add("tooltip.vacuum_freezer.3", "1x Input Hatch/Bus (Any casing)");
            this.add("tooltip.vacuum_freezer.4", "1x Output Hatch/Bus (Any Casing)");
            this.add("tooltip.vacuum_freezer.5", "1x Energy Hatch (Any Casing)");
            this.add("tooltip.vacuum_freezer.6", "Frost Proof Casings for the rest");
            this.add("tooltip.fusion_control_computer.0", "It's over 9000!!!");
            this.add("tooltip.fusion_control_computer.1", "Fusion Casings around Fusion Coils");
            this.add("tooltip.fusion_control_computer.2", "2-16 Input Hatches/Buses");
            this.add("tooltip.fusion_control_computer.3", "1-16 Output Hatches/Buses");
            this.add("tooltip.fusion_control_computer.4", "1-16 Energy Hatches");
            this.add("tooltip.fusion_control_computer.5", "All Energy Hatches must be LuV or better");
            this.add("tooltip.fusion_control_computer.6", "8192EU/t and 40mio EU Cap per Energy Hatch");
        }

        private void advancements() {
            this.addAdvancement("gt5r", "GT5R", "Advancements of GT5R");
            this.addAdvancement("rock", "Pickup a rock of some kind");
            this.addAdvancement("flint_pickaxe", "No wood tools allowed!", "Craft a flint pickaxe");
            this.addAdvancement("raw_copper", "Find some copper ore and mine it");
            this.addAdvancement("raw_tin", "Find some tin ore and mine it");
            this.addAdvancement("mortar", "Craft a mortar");
            this.addAdvancement("bronze_dust", "Make some bronze dust using a mortar");
            this.addAdvancement("hammer", "Craft a hammer");
            this.addAdvancement("bronze_solid_fuel_boiler", "Craft a Solid Fuel Boiler");
            this.addAdvancement("bronze_steam_forge_hammer", "Craft a Steam Forge Hammer");
            this.addAdvancement("bronze_steam_compressor", "Craft a Steam Compressor");
            this.addAdvancement("fire_brick", "Craft a Fire Brick");
            this.addAdvancement("coke_oven", "Craft a Coke Oven");
        }

        private void addAdvancement(String key, String translatedTitle, String translatedDesc) {
            this.add("gt5r.advancements." + key + ".title", translatedTitle);
            this.add("gt5r.advancements." + key + ".desc", translatedDesc);
        }

        private void addAdvancement(String key, String translatedDesc) {
            this.add("gt5r.advancements." + key + ".title", Utils.lowerUnderscoreToUpperSpaced((String)key));
            this.add("gt5r.advancements." + key + ".desc", translatedDesc);
        }

        protected void english(String domain, String locale) {
            super.english(domain, locale);
            GTAPI.all(BlockCasing.class, (String)domain).forEach(i -> {
                if (i.getId().startsWith("casing_") || i.getId().startsWith("hull_")) {
                    this.add((Block)i, Utils.lowerUnderscoreToUpperSpacedRotated((String)i.getId()));
                    return;
                }
                if (i.getId().contains("long_distance_cable")) {
                    String tier = i.getId().replace("long_distance_cable_", "");
                    this.add((Block)i, "Long Distance Cable (" + tier.toUpperCase() + ")");
                }
                this.add((Block)i, Utils.lowerUnderscoreToUpperSpaced((String)i.getId()));
            });
            GTAPI.all(BlockBedrockFlower.class, (String)domain).forEach(b -> {
                if (b == GT5RBlocks.PRINCES_PLUME) {
                    this.add((Block)b, "Prince's Plume");
                } else {
                    this.add((Block)b, Utils.lowerUnderscoreToUpperSpaced((String)b.getId()));
                }
                String material = b.tooltipMaterial != Material.NULL ? (b.tooltipMaterial == Materials.Uranium ? "Uranium" : b.tooltipMaterial.getDisplayNameString()) : "Ore";
                String n = material.startsWith("A") || material.startsWith("E") || material.startsWith("I") || material.startsWith("O") || material.startsWith("U") ? "n" : "";
                this.add("tooltip." + b.getDomain() + "." + b.getId().replace("/", "."), "Indicates presence of a" + n + " " + material + " Deposit nearby");
            });
            this.add((Block)GT5RBlocks.MINING_PIPE, "Mining Pipe");
            this.add((Block)GT5RBlocks.MINING_PIPE_THIN, "Mining Pipe");
            this.add((Block)GT5RBlocks.BRITTLE_CHARCOAL, "Brittle Charcoal");
            this.add((Block)GT5RBlocks.SOLID_SUPER_FUEL, "Solid Super Fuel");
            GTAPI.all(BlockFakeCasing.class, (String)domain).forEach(i -> this.add((Block)i, Utils.lowerUnderscoreToUpperSpaced((String)i.getId())));
            GTAPI.all(BlockColoredWall.class, (String)domain).forEach(i -> this.add((Block)i, Utils.lowerUnderscoreToUpperSpaced((String)i.getId())));
            GTAPI.all(BlockAsphalt.class, (String)domain).forEach(i -> this.add((Block)i, Utils.lowerUnderscoreToUpperSpaced((String)i.getId())));
            GTAPI.all(BlockAsphaltSlab.class, (String)domain).forEach(i -> this.add((Block)i, Utils.lowerUnderscoreToUpperSpaced((String)i.getId())));
            GTAPI.all(BlockAsphaltStair.class, (String)domain).forEach(i -> this.add((Block)i, Utils.lowerUnderscoreToUpperSpaced((String)i.getId())));
            GTAPI.all(BlockCoil.class, (String)domain).forEach(i -> this.add((Block)i, Utils.lowerUnderscoreToUpperSpaced((String)i.getId())));
            GTAPI.all(ItemBasic.class, (String)domain).forEach(i -> this.override(i.m_5524_(), Utils.lowerUnderscoreToUpperSpaced((String)i.getId()).replace("Lv", "(LV)").replace("Mv", "(MV)").replace("Hv", "(HV)").replace("Ev", "(EV)").replace("Iv", "(IV)")));
            GTAPI.all(ItemNuclearFuelRod.class, (String)domain).forEach(i -> this.override(i.m_5524_(), Utils.getLocalizedType((IGTObject)i.getMaterial()) + " Fuel Rod"));
            GTAPI.all(ItemDepletedRod.class, (String)domain).forEach(i -> this.override(i.m_5524_(), "Depleted " + Utils.getLocalizedType((IGTObject)i.getMaterial()) + " Fuel Rod"));
            this.override((Machine)GT5RMachines.LARGE_TURBINE, Tier.HV, "Large Steam Turbine");
            this.override((Machine)GT5RMachines.LARGE_TURBINE, Tier.EV, "Large Gas Turbine");
            this.override((Machine)GT5RMachines.LARGE_TURBINE, Tier.IV, "Large HP Steam Turbine");
            this.override((Machine)GT5RMachines.LARGE_BOILER, Tier.LV, "Large Bronze Boiler");
            this.override((Machine)GT5RMachines.LARGE_BOILER, Tier.MV, "Large Steel Boiler");
            this.override((Machine)GT5RMachines.LARGE_BOILER, Tier.HV, "Large Titanium Boiler");
            this.override((Machine)GT5RMachines.LARGE_BOILER, Tier.EV, "Large Tungstensteel Boiler");
            this.override((Machine)GT5RMachines.INVENTORY_TANK_BRIDGE, Tier.NONE, "Inventory and Tank Bridge");
            this.override((Machine)GT5RMachines.INVENTORY_TANK_EXTENDER, Tier.NONE, "Inventory and Tank Extender");
            this.override((Machine)GT5RMachines.MACERATOR, Tier.HV, "Pulverizer (%s)");
            this.override((Machine)GT5RMachines.MACERATOR, Tier.EV, "Pulverizer (%s)");
            this.override(GT5RItems.EmptyGeigerCounter.m_5524_(), "Geiger Counter (Empty)");
            this.add((Block)GT5RBlocks.POWDER_BARREL, "Powder Barrel");
            this.override(GT5RBlocks.BRONZE_PLATED_BRICK_CASING.m_7705_(), "Bronze Plated Bricks");
            this.override("machine.hull", "%s " + GT5RMachines.HULL.getLang(locale));
            this.override(GT5RCovers.COVER_REDSTONE_CONDUCTOR_ACCEPT.getItem().m_41778_(), "Redstone Conductor (Accept)");
            this.override(GT5RCovers.COVER_REDSTONE_CONDUCTOR_EMIT.getItem().m_41778_(), "Redstone Conductor (Emit)");
            GT5RMachines.HULL.getTiers().forEach(tier -> this.override((Machine)GT5RMachines.HULL, (Tier)tier, tier.getId().toUpperCase() + " " + GT5RMachines.HULL.getLang(locale)));
        }

        protected void overrides() {
            String[] fluids;
            for (String s : fluids = new String[]{"hot_molten_lithium_chloride", "hot_molten_tin", "hot_molten_sodium"}) {
                this.override("fluid_type.antimatter_shared.liquid_" + s, Utils.lowerUnderscoreToUpperSpaced((String)s));
                this.override("item.antimatter_shared.liquid_" + s + "_bucket", Utils.lowerUnderscoreToUpperSpaced((String)s) + " Bucket");
            }
            this.override("fluid_type.antimatter_shared.liquid_nitrogen", Utils.lowerUnderscoreToUpperSpaced((String)"liquid_nitrogen"));
            this.override("item.antimatter_shared.liquid_nitrogen_bucket", Utils.lowerUnderscoreToUpperSpaced((String)"liquid_nitrogen") + " Bucket");
            this.override("fluid_type.antimatter_shared.concrete", "Wet Concrete");
            this.override("item.antimatter_shared.concrete_bucket", "Wet Concrete Bucket");
            this.override("gtlib", "jei.category.pulverizer", "Macerator/Pulverizer");
        }
    }
}

