/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gt5r.data;

import com.google.common.collect.ImmutableMap;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import org.apache.commons.lang3.function.TriFunction;
import org.gtreimagined.gt5r.GT5RConfig;
import org.gtreimagined.gt5r.data.GT5RBlocks;
import org.gtreimagined.gt5r.data.GT5RItems;
import org.gtreimagined.gt5r.data.Materials;
import org.gtreimagined.gtcore.data.GTCoreTags;
import org.gtreimagined.gtlib.data.GTMaterialTypes;
import org.gtreimagined.gtlib.item.ItemBasic;
import org.gtreimagined.gtlib.machine.Tier;
import org.gtreimagined.gtlib.material.Material;
import org.gtreimagined.gtlib.material.SubTag;
import org.gtreimagined.gtlib.pipe.PipeItemBlock;
import org.gtreimagined.gtlib.pipe.PipeSize;
import org.gtreimagined.gtlib.util.TagUtils;

public class TierMaps {
    public static final ImmutableMap<Tier, Material> TIER_MATERIALS;
    public static final ImmutableMap<Tier, Material> TIER_PIPE_MATERIAL;
    public static ImmutableMap<Tier, PipeItemBlock> TIER_WIRES;
    public static Function<Tier, TagKey<Item>> TIER_CIRCUITS;
    public static ImmutableMap<Tier, ItemBasic<?>> TIER_BOARDS;
    public static ImmutableMap<Tier, Material> EMITTER_RODS;
    public static ImmutableMap<Tier, Object> EMITTER_GEMS;
    public static ImmutableMap<Tier, Material> TIER_ROTORS;
    public static final BiFunction<PipeSize, Tier, Object> PIPE_GETTER;
    public static final BiFunction<PipeSize, Tier, Object> HATCH_PIPE_GETTER;
    public static final BiFunction<PipeSize, Tier, Object> WIRE_GETTER;
    public static final TriFunction<PipeSize, Tier, Boolean, Object> CABLE_GETTER;
    private static boolean doneMaps;

    public static void init() {
    }

    public static void providerInit() {
        if (doneMaps) {
            return;
        }
        doneMaps = true;
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)Tier.ULV, (Object)GT5RBlocks.WIRE_SOLDERING_ALLOY.getBlockItem(PipeSize.VTINY));
        builder.put((Object)Tier.LV, (Object)GT5RBlocks.WIRE_TIN.getBlockItem(PipeSize.VTINY));
        builder.put((Object)Tier.MV, (Object)GT5RBlocks.WIRE_COPPER.getBlockItem(PipeSize.VTINY));
        builder.put((Object)Tier.HV, (Object)GT5RBlocks.WIRE_GOLD.getBlockItem(PipeSize.VTINY));
        builder.put((Object)Tier.EV, (Object)GT5RBlocks.WIRE_ALUMINIUM.getBlockItem(PipeSize.VTINY));
        builder.put((Object)Tier.IV, (Object)GT5RBlocks.WIRE_TUNGSTEN.getBlockItem(PipeSize.VTINY));
        builder.put((Object)Tier.LUV, (Object)GT5RBlocks.WIRE_VANADIUM_GALLIUM.getBlockItem(PipeSize.VTINY));
        builder.put((Object)Tier.ZPM, (Object)GT5RBlocks.WIRE_NAQUADAH.getBlockItem(PipeSize.VTINY));
        builder.put((Object)Tier.UV, (Object)GT5RBlocks.WIRE_NAQUADAH_ALLOY.getBlockItem(PipeSize.SMALL));
        builder.put((Object)Tier.UHV, (Object)GT5RBlocks.WIRE_NAQUADAH_ALLOY.getBlockItem(PipeSize.VTINY));
        TIER_WIRES = builder.build();
        builder = ImmutableMap.builder();
        builder.put((Object)Tier.ULV, (Object)Materials.Bronze);
        builder.put((Object)Tier.LV, (Object)Materials.Tin);
        builder.put((Object)Tier.MV, (Object)Materials.Bronze);
        builder.put((Object)Tier.HV, (Object)Materials.Steel);
        builder.put((Object)Tier.EV, (Object)Materials.StainlessSteel);
        builder.put((Object)Tier.IV, (Object)Materials.TungstenSteel);
        TIER_ROTORS = builder.build();
        builder = ImmutableMap.builder();
        builder.put((Object)Tier.LV, (Object)Materials.Brass);
        builder.put((Object)Tier.MV, (Object)Materials.Electrum);
        builder.put((Object)Tier.HV, (Object)Materials.Chromium);
        builder.put((Object)Tier.EV, (Object)Materials.Platinum);
        builder.put((Object)Tier.IV, (Object)Materials.Osmium);
        EMITTER_RODS = builder.build();
        builder = ImmutableMap.builder();
        builder.put((Object)Tier.LV, (Object)GTMaterialTypes.GEM.getMaterialTag(Materials.MilkyQuartz));
        builder.put((Object)Tier.MV, (Object)Items.f_42692_);
        builder.put((Object)Tier.HV, (Object)Items.f_42616_);
        builder.put((Object)Tier.EV, (Object)Items.f_42584_);
        builder.put((Object)Tier.IV, (Object)Items.f_42545_);
        EMITTER_GEMS = builder.build();
        builder = ImmutableMap.builder();
        builder.put((Object)Tier.LV, (Object)GTCoreTags.CIRCUITS_BASIC);
        builder.put((Object)Tier.MV, (Object)GTCoreTags.CIRCUITS_GOOD);
        builder.put((Object)Tier.HV, (Object)GTCoreTags.CIRCUITS_ADVANCED);
        builder.put((Object)Tier.EV, (Object)GTCoreTags.CIRCUITS_ELITE);
        builder.put((Object)Tier.IV, (Object)GTCoreTags.CIRCUITS_MASTER);
        builder.put((Object)Tier.LUV, (Object)GTCoreTags.CIRCUITS_DATA_ORB);
        builder.put((Object)Tier.ZPM, (Object)GTCoreTags.CIRCUITS_DATA_ORB);
        TIER_CIRCUITS = t -> {
            boolean hardMode = GT5RConfig.HARDER_CIRCUITS;
            if (t == Tier.LV) {
                return GTCoreTags.CIRCUITS_BASIC;
            }
            if (t == Tier.MV) {
                return GTCoreTags.CIRCUITS_GOOD;
            }
            if (t == Tier.HV) {
                return GTCoreTags.CIRCUITS_ADVANCED;
            }
            if (t == Tier.EV) {
                return GTCoreTags.CIRCUITS_COMPLEX;
            }
            if (t == Tier.IV) {
                return GTCoreTags.CIRCUITS_ELITE;
            }
            if (t == Tier.LUV) {
                return GTCoreTags.CIRCUITS_MASTER;
            }
            if (t == Tier.ZPM) {
                return GTCoreTags.CIRCUITS_ULTIMATE;
            }
            if (t == Tier.UV) {
                return hardMode ? GTCoreTags.CIRCUITS_ULTIMATE : GTCoreTags.CIRCUITS_DATA_ORB;
            }
            if (t == Tier.UHV) {
                return hardMode ? GTCoreTags.CIRCUITS_ULTIMATE : GTCoreTags.CIRCUITS_DATA_ORB;
            }
            return GTCoreTags.CIRCUITS_BASIC;
        };
        builder = ImmutableMap.builder();
        builder.put((Object)Tier.LV, GT5RItems.CircuitBoardCoated);
        builder.put((Object)Tier.MV, GT5RItems.CircuitBoardPhenolic);
        builder.put((Object)Tier.HV, GT5RItems.CircuitBoardPlastic);
        builder.put((Object)Tier.EV, GT5RItems.CircuitBoardEpoxy);
        builder.put((Object)Tier.IV, GT5RItems.CircuitBoardFiber);
        builder.put((Object)Tier.LUV, GT5RItems.CircuitBoardMultiFiber);
        builder.put((Object)Tier.ZPM, GT5RItems.CircuitBoardWetware);
        TIER_BOARDS = builder.build();
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)Tier.ULV, (Object)Materials.WroughtIron);
        builder.put((Object)Tier.LV, (Object)Materials.Steel);
        builder.put((Object)Tier.MV, (Object)Materials.Aluminium);
        builder.put((Object)Tier.HV, (Object)Materials.StainlessSteel);
        builder.put((Object)Tier.EV, (Object)Materials.Titanium);
        builder.put((Object)Tier.IV, (Object)Materials.TungstenSteel);
        builder.put((Object)Tier.LUV, (Object)Materials.Chromium);
        builder.put((Object)Tier.ZPM, (Object)Materials.Iridium);
        builder.put((Object)Tier.UV, (Object)Materials.Osmium);
        builder.put((Object)Tier.UHV, (Object)Materials.Neutronium);
        TIER_MATERIALS = builder.build();
        builder = ImmutableMap.builder();
        builder.put((Object)Tier.ULV, (Object)Materials.Copper);
        builder.put((Object)Tier.LV, (Object)Materials.Bronze);
        builder.put((Object)Tier.MV, (Object)Materials.Steel);
        builder.put((Object)Tier.HV, (Object)Materials.StainlessSteel);
        builder.put((Object)Tier.EV, (Object)Materials.Titanium);
        builder.put((Object)Tier.IV, (Object)Materials.TungstenSteel);
        TIER_PIPE_MATERIAL = builder.build();
        WIRE_GETTER = (size, tier) -> {
            if (tier == Tier.LV) {
                return TagUtils.getItemTag((ResourceLocation)new ResourceLocation("gtlib", SubTag.COPPER_WIRE.getId() + "_" + size.getId()));
            }
            if (tier == Tier.MV) {
                return GT5RBlocks.WIRE_CUPRONICKEL.getBlockItem(size);
            }
            if (tier == Tier.HV) {
                return GT5RBlocks.WIRE_KANTHAL.getBlockItem(size);
            }
            if (tier == Tier.EV) {
                return GT5RBlocks.WIRE_NICHROME.getBlockItem(size);
            }
            if (tier == Tier.IV) {
                return GT5RBlocks.WIRE_TUNGSTEN_STEEL.getBlockItem(size);
            }
            throw new IllegalArgumentException("Too high tier in WIRE_GETTER");
        };
        CABLE_GETTER = (size, tier, machine) -> {
            if (tier == Tier.ULV) {
                return GT5RBlocks.CABLE_SOLDERING_ALLOY.getBlockItem(size);
            }
            if (tier == Tier.LV) {
                return GT5RBlocks.CABLE_TIN.getBlockItem(size);
            }
            if (tier == Tier.MV) {
                return TagUtils.getItemTag((ResourceLocation)new ResourceLocation("gtlib", SubTag.COPPER_CABLE.getId() + "_" + size.getId()));
            }
            if (tier == Tier.HV) {
                return GT5RBlocks.CABLE_GOLD.getBlockItem(size);
            }
            if (tier == Tier.EV) {
                return GT5RBlocks.CABLE_ALUMINIUM.getBlockItem(size);
            }
            if (tier == Tier.IV) {
                return machine != false ? GT5RBlocks.CABLE_PLATINUM.getBlockItem(size) : GT5RBlocks.CABLE_TUNGSTEN.getBlockItem(size);
            }
            if (tier == Tier.LUV) {
                return GT5RBlocks.CABLE_VANADIUM_GALLIUM.getBlockItem(size);
            }
            if (tier == Tier.ZPM) {
                return GT5RBlocks.CABLE_NAQUADAH.getBlockItem(size);
            }
            if (tier == Tier.UV) {
                return GT5RBlocks.CABLE_NAQUADAH_ALLOY.getBlockItem(size);
            }
            if (tier == Tier.UHV) {
                return GT5RBlocks.CABLE_NAQUADAH_ALLOY.getBlockItem(size);
            }
            throw new IllegalArgumentException("Invalid tier in CABLE_GETTER");
        };
        PIPE_GETTER = (size, tier) -> {
            if (tier == Tier.ULV) {
                return GT5RBlocks.FLUID_PIPE_COPPER.getBlockItem(size);
            }
            if (tier == Tier.LV) {
                return GT5RBlocks.FLUID_PIPE_BRONZE.getBlockItem(size);
            }
            if (tier == Tier.MV) {
                return GT5RBlocks.FLUID_PIPE_STEEL.getBlockItem(size);
            }
            if (tier == Tier.HV) {
                return GT5RBlocks.FLUID_PIPE_STAINLESS_STEEL.getBlockItem(size);
            }
            if (tier == Tier.EV) {
                return GT5RBlocks.FLUID_PIPE_TITANIUM.getBlockItem(size);
            }
            if (tier == Tier.IV) {
                return GT5RBlocks.FLUID_PIPE_TUNGSTEN_STEEL.getBlockItem(size);
            }
            if (tier == Tier.LUV || tier == Tier.ZPM || tier == Tier.UV || tier == Tier.UHV) {
                return GT5RBlocks.FLUID_PIPE_CHROMIUM.getBlockItem(size);
            }
            throw new IllegalArgumentException("Invalid tier in PIPE_GETTER");
        };
        HATCH_PIPE_GETTER = (size, tier) -> {
            if (tier == Tier.ULV) {
                return GT5RBlocks.FLUID_PIPE_PLASTIC.getBlockItem(size);
            }
            if (tier == Tier.LV) {
                return GT5RBlocks.FLUID_PIPE_PVC.getBlockItem(size);
            }
            if (tier == Tier.MV) {
                return GT5RBlocks.FLUID_PIPE_INVAR.getBlock(size);
            }
            if (tier == Tier.HV) {
                return GT5RBlocks.FLUID_PIPE_STEEL.getBlock(size);
            }
            if (tier == Tier.EV) {
                return GT5RBlocks.FLUID_PIPE_STAINLESS_STEEL.getBlockItem(size);
            }
            if (tier == Tier.IV) {
                return GT5RBlocks.FLUID_PIPE_CHROMIUM.getBlockItem(size);
            }
            if (tier == Tier.LUV) {
                return GT5RBlocks.FLUID_PIPE_TUNGSTEN_STEEL.getBlockItem(size);
            }
            if (tier == Tier.ZPM) {
                return GT5RBlocks.FLUID_PIPE_TUNGSTEN.getBlockItem(size);
            }
            if (tier == Tier.UV) {
                return GT5RBlocks.FLUID_PIPE_TUNGSTEN_CARBIDE.getBlockItem(size);
            }
            if (tier == Tier.UHV) {
                return GT5RBlocks.FLUID_PIPE_ADAMANTIUM.getBlockItem(size);
            }
            throw new IllegalArgumentException("Invalid tier in HATCH_PIPE_GETTER");
        };
        doneMaps = false;
    }
}

