/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gt5r.cover.redstone;

import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.gtreimagined.gt5r.cover.base.CoverBasicRedstoneOutput;
import org.gtreimagined.gtlib.blockentity.BlockEntityMachine;
import org.gtreimagined.gtlib.capability.ICoverHandler;
import org.gtreimagined.gtlib.capability.machine.MachineRecipeHandler;
import org.gtreimagined.gtlib.cover.CoverFactory;
import org.gtreimagined.gtlib.machine.Tier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CoverProgressSensor
extends CoverBasicRedstoneOutput {
    public CoverProgressSensor(@NotNull ICoverHandler<?> source, @Nullable Tier tier, Direction side, CoverFactory factory) {
        super(source, tier, side, factory);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean canPlace() {
        BlockEntity blockEntity = this.handler.getTile();
        if (!(blockEntity instanceof BlockEntityMachine)) return false;
        BlockEntityMachine machine = (BlockEntityMachine)blockEntity;
        if (!machine.recipeHandler.side(this.side).isPresent()) return false;
        return true;
    }

    public ResourceLocation getModel(String type, Direction dir) {
        if (type.equals("pipe")) {
            return PIPE_COVER_MODEL;
        }
        return CoverProgressSensor.getBasicModel();
    }

    public void onUpdate() {
        MachineRecipeHandler recipeHandler;
        if (this.handler.getTile().m_58904_() == null || this.handler.getTile().m_58904_().f_46443_) {
            return;
        }
        BlockEntity blockEntity = this.handler.getTile();
        if (blockEntity instanceof BlockEntityMachine) {
            BlockEntityMachine machine = (BlockEntityMachine)blockEntity;
            v0 = (MachineRecipeHandler)machine.recipeHandler.side(this.side).orElse(null);
        } else {
            v0 = recipeHandler = null;
        }
        if (recipeHandler != null) {
            long scale = recipeHandler.getMaxProgress() > 0 ? (long)recipeHandler.getMaxProgress() / 15L : 0L;
            long currentProgress = recipeHandler.getCurrentProgress();
            if (scale > 0L) {
                this.setOutputRedstone(this.inverted ? (int)(15L - currentProgress / scale) : (int)(currentProgress / scale));
            } else {
                this.setOutputRedstone(this.inverted ? 15 : 0);
            }
        }
    }
}

