/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gt5r.cover;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import org.gtreimagined.gt5r.cover.ICoverRedstoneSensitive;
import org.gtreimagined.gtlib.blockentity.pipe.BlockEntityPipe;
import org.gtreimagined.gtlib.capability.ICoverHandler;
import org.gtreimagined.gtlib.cover.BaseCover;
import org.gtreimagined.gtlib.cover.CoverFactory;
import org.gtreimagined.gtlib.data.GTTools;
import org.gtreimagined.gtlib.machine.Tier;
import org.gtreimagined.gtlib.tool.GTToolType;
import org.gtreimagined.gtlib.util.Utils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CoverShutter
extends BaseCover
implements ICoverRedstoneSensitive {
    Mode mode = Mode.OPEN_REDSTONE;
    boolean isPowered = false;
    boolean checkConnection = false;

    public CoverShutter(@NotNull ICoverHandler<?> source, @Nullable Tier tier, Direction side, CoverFactory factory) {
        super(source, tier, side, factory);
    }

    public boolean canPlace() {
        return this.handler.getTile() instanceof BlockEntityPipe;
    }

    public void onPlace() {
        super.onPlace();
        this.checkConnection = true;
    }

    public <T> boolean blocksInput(Class<T> cap, @Nullable Direction side) {
        return this.mode == Mode.OUTPUT_ONLY;
    }

    public <T> boolean blocksOutput(Class<T> cap, @Nullable Direction side) {
        return this.mode == Mode.INPUT_ONLY;
    }

    public InteractionResult onInteract(Player player, InteractionHand hand, Direction side, @Nullable GTToolType type) {
        if (type != null && type.getTag() == GTTools.SCREWDRIVER.getTag()) {
            this.mode = player.m_6144_() ? this.mode.cycleBackward() : this.mode.cycleForward();
            this.handler.getTile().m_6596_();
            switch (this.mode) {
                case OPEN_NO_REDSTONE: {
                    player.m_6352_((Component)Utils.literal((String)"Open if work disabled"), player.m_142081_());
                    break;
                }
                case OUTPUT_ONLY: {
                    player.m_6352_((Component)Utils.literal((String)"Output only"), player.m_142081_());
                    break;
                }
                case INPUT_ONLY: {
                    player.m_6352_((Component)Utils.literal((String)"Input only"), player.m_142081_());
                    break;
                }
                case OPEN_REDSTONE: {
                    player.m_6352_((Component)Utils.literal((String)"Open if work enabled"), player.m_142081_());
                }
            }
            return InteractionResult.SUCCESS;
        }
        return super.onInteract(player, hand, side, type);
    }

    public void onBlockUpdateAllSides() {
        this.checkConnection = true;
    }

    public void onUpdate() {
        super.onUpdate();
        if (this.checkConnection) {
            this.isPowered = this.isPowered(this.side);
            this.checkConnection = false;
        }
        this.checkPipeConnection();
    }

    private void checkPipeConnection() {
        BlockEntityPipe pipe = (BlockEntityPipe)this.handler.getTile();
        if (this.mode == Mode.OPEN_NO_REDSTONE || this.mode == Mode.OPEN_REDSTONE) {
            boolean remove;
            boolean bl = remove = this.mode == Mode.OPEN_NO_REDSTONE && this.isPowered || this.mode == Mode.OPEN_REDSTONE && !this.isPowered;
            if (remove) {
                pipe.clearConnection(this.side);
            } else {
                pipe.setConnection(this.side);
            }
        }
    }

    protected String getRenderId() {
        return "shutter";
    }

    public String getId() {
        return "shutter";
    }

    public ResourceLocation getModel(String type, Direction dir) {
        if (type.equals("pipe")) {
            return PIPE_COVER_MODEL;
        }
        return CoverShutter.getBasicModel();
    }

    public List<String> getInfo(boolean simple) {
        ArrayList<String> info = new ArrayList<String>();
        info.add("Shutter Mode: " + this.mode);
        return info;
    }

    public CompoundTag serialize() {
        CompoundTag nbt = super.serialize();
        nbt.m_128405_("mode", this.mode.ordinal());
        return nbt;
    }

    public void deserialize(CompoundTag nbt) {
        super.deserialize(nbt);
        this.mode = Mode.values()[nbt.m_128451_("mode")];
    }

    static enum Mode {
        INPUT_ONLY,
        OUTPUT_ONLY,
        OPEN_REDSTONE,
        OPEN_NO_REDSTONE;


        Mode cycleForward() {
            return switch (this) {
                default -> throw new IncompatibleClassChangeError();
                case OPEN_REDSTONE -> OPEN_NO_REDSTONE;
                case OPEN_NO_REDSTONE -> OUTPUT_ONLY;
                case OUTPUT_ONLY -> INPUT_ONLY;
                case INPUT_ONLY -> OPEN_REDSTONE;
            };
        }

        Mode cycleBackward() {
            return switch (this) {
                default -> throw new IncompatibleClassChangeError();
                case OPEN_REDSTONE -> INPUT_ONLY;
                case OPEN_NO_REDSTONE -> OPEN_REDSTONE;
                case OUTPUT_ONLY -> OPEN_NO_REDSTONE;
                case INPUT_ONLY -> OUTPUT_ONLY;
            };
        }
    }
}

