/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gt5r.client;

import com.google.common.collect.ImmutableMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.gtreimagined.gt5r.blockentity.single.BlockEntityNuclearReactorCore;
import org.gtreimagined.gt5r.data.GT5RCovers;
import org.gtreimagined.gtlib.GTLibProperties;
import org.gtreimagined.gtlib.Ref;
import org.gtreimagined.gtlib.blockentity.BlockEntityMachine;
import org.gtreimagined.gtlib.client.ModelUtils;
import org.gtreimagined.gtlib.client.baked.MachineBakedModel;
import org.gtreimagined.gtlib.client.dynamic.IDynamicModelProvider;
import org.gtreimagined.gtlib.cover.ICover;
import org.gtreimagined.gtlib.machine.MachineState;
import org.gtreimagined.gtlib.texture.Texture;
import org.jetbrains.annotations.NotNull;

public class ReactorBakedModel
extends MachineBakedModel {
    private final BakedModel[] rodModels;

    public ReactorBakedModel(TextureAtlasSprite particle, ImmutableMap<MachineState, BakedModel[]> sides, BakedModel[] rodModels) {
        super(particle, sides);
        this.rodModels = rodModels;
    }

    public List<BakedQuad> getBlockQuads(BlockState state, Direction side, Random rand, BlockAndTintGetter level, @NotNull BlockPos pos) {
        boolean isOutputCover;
        if (side == null) {
            return Collections.emptyList();
        }
        BlockEntity tile = level.m_7702_(pos);
        if (!(tile instanceof BlockEntityNuclearReactorCore)) {
            return Collections.emptyList();
        }
        BlockEntityNuclearReactorCore core = (BlockEntityNuclearReactorCore)tile;
        GTLibProperties.MachineProperties props = this.getMachineProperty(core);
        if (props == null) {
            return Collections.emptyList();
        }
        ObjectArrayList superBlockQuads = new ObjectArrayList(20);
        List coverQuads = this.getCoverQuads(state, side, rand, props, core, level, pos);
        ICover cover = props.covers[side.m_122411_()];
        boolean bl = isOutputCover = cover.getFactory() == GT5RCovers.COVER_REACTOR_OUTPUT || cover.getFactory() == GT5RCovers.COVER_REACTOR_OUTPUT_SECONDARY;
        if (!coverQuads.isEmpty()) {
            if (isOutputCover) {
                return coverQuads;
            }
            Function<Direction, Texture> ft = core.getMultiTexture();
            List machineQuads = props.machineTexturer.getQuads("machine", (List)new ObjectArrayList(), state, (IDynamicModelProvider)props.type, (Object)new BlockEntityMachine.DynamicKey(new ResourceLocation(props.type.getId()), ft.apply(side), side, props.state, props), side.m_122411_(), level, pos);
            for (int i = 0; i < 2; ++i) {
                BakedQuad quad = (BakedQuad)machineQuads.get(i);
                if (quad.m_111306_() != side.m_122424_()) continue;
                coverQuads.add(quad);
            }
            return coverQuads;
        }
        BakedModel model = this.getModel(state, side, props.state, props.type);
        Direction[] machineQuads = Ref.DIRS;
        int i = machineQuads.length;
        for (int quad = 0; quad < i; ++quad) {
            Direction dir = machineQuads[quad];
            superBlockQuads.addAll(ModelUtils.getQuadsFromBaked((BakedModel)model, (BlockState)state, (Direction)dir, (Random)rand, (BlockAndTintGetter)level, (BlockPos)pos));
        }
        superBlockQuads.addAll(ModelUtils.getQuadsFromBaked((BakedModel)model, (BlockState)state, null, (Random)rand, (BlockAndTintGetter)level, (BlockPos)pos));
        if (side == Direction.UP) {
            ArrayList<BakedQuad> list = new ArrayList<BakedQuad>();
            for (i = 0; i < 4; ++i) {
                ItemStack rod = core.getRod(i);
                if (rod.m_41619_()) continue;
                BakedModel rodModel = this.rodModels[i];
                for (Direction dir : Ref.DIRS) {
                    list.addAll(ModelUtils.getQuadsFromBaked((BakedModel)rodModel, (BlockState)state, (Direction)dir, (Random)rand, (BlockAndTintGetter)level, (BlockPos)pos));
                }
                list.addAll(ModelUtils.getQuadsFromBaked((BakedModel)rodModel, (BlockState)state, null, (Random)rand, (BlockAndTintGetter)level, (BlockPos)pos));
            }
            list.addAll((Collection<BakedQuad>)superBlockQuads);
            return list;
        }
        return superBlockQuads;
    }
}

