/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gt5r.blockentity.single;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockState;
import org.gtreimagined.gtlib.blockentity.BlockEntityMachine;
import org.gtreimagined.gtlib.capability.machine.MachineEnergyHandler;
import org.gtreimagined.gtlib.capability.machine.MachineFEHandler;
import org.gtreimagined.gtlib.machine.types.Machine;

public class BlockEntityFluxTransformer
extends BlockEntityMachine<BlockEntityFluxTransformer> {
    public BlockEntityFluxTransformer(Machine<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.feHandler.set(() -> new MachineFEHandler<BlockEntityFluxTransformer>(this, (int)this.getMachineTier().getVoltage() * 66 * 4, true){

            public boolean canExtract(Direction direction) {
                return super.canExtract(direction) && direction != ((BlockEntityFluxTransformer)this.tile).getFacing();
            }
        });
        this.energyHandler.set(() -> new MachineEnergyHandler<BlockEntityFluxTransformer>(this, false){

            public boolean canInput(Direction direction) {
                return super.canInput(direction) && direction == ((BlockEntityFluxTransformer)this.tile).getFacing();
            }

            public long insertEu(long voltage, boolean simulate) {
                if (voltage < 0L) {
                    return 0L;
                }
                if (this.inputAmperageCheck()) {
                    return 0L;
                }
                int loss = 1;
                if (!((BlockEntityFluxTransformer)this.tile).getMachineType().has("partial_amps") && this.cachedItems.isEmpty() && this.getEnergy() + (voltage -= (long)loss) > this.getCapacity()) {
                    return 0L;
                }
                int toAdd = (int)Math.min(voltage, this.getCapacity() - this.getEnergy());
                int inserted = ((BlockEntityFluxTransformer)this.tile).feHandler.map(fe -> fe.receiveEnergy(toAdd * 4, simulate)).orElse(0);
                return inserted > 0 ? (long)(inserted + loss) : 0L;
            }

            public long getEnergy() {
                return BlockEntityFluxTransformer.this.feHandler.map(fe -> fe.getEnergyStored() / 4).orElse(0).intValue();
            }
        });
    }
}

