/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gt5r.block;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.gtreimagined.gtlib.GTAPI;
import org.gtreimagined.gtlib.datagen.builder.GTBlockModelBuilder;
import org.gtreimagined.gtlib.datagen.builder.IModelLocation;
import org.gtreimagined.gtlib.datagen.providers.GTBlockStateProvider;
import org.gtreimagined.gtlib.datagen.providers.GTItemModelProvider;
import org.gtreimagined.gtlib.material.Material;
import org.gtreimagined.gtlib.registration.IGTObject;
import org.gtreimagined.gtlib.registration.IModelProvider;
import org.gtreimagined.gtlib.registration.ITextureProvider;
import org.gtreimagined.gtlib.texture.Texture;
import org.gtreimagined.gtlib.util.Utils;
import org.jetbrains.annotations.Nullable;

public class BlockBedrockFlower
extends BushBlock
implements IGTObject,
IModelProvider,
ITextureProvider {
    protected static final VoxelShape SHAPE = Block.m_49796_((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)10.0, (double)11.0);
    private final String domain;
    private final String id;
    public final Material tooltipMaterial;
    private final boolean sand;

    public BlockBedrockFlower(String domain, String id, Material tooltipMaterial, boolean sand) {
        this(domain, id, tooltipMaterial, sand, BlockBehaviour.Properties.m_60939_((net.minecraft.world.level.material.Material)net.minecraft.world.level.material.Material.f_76300_).m_60910_().m_60966_().m_60918_(SoundType.f_56740_));
    }

    public BlockBedrockFlower(String domain, String id, Material tooltipMaterial, boolean sand, BlockBehaviour.Properties props) {
        super(props);
        this.domain = domain;
        this.id = id;
        this.tooltipMaterial = tooltipMaterial;
        this.sand = sand;
        GTAPI.register(BlockBedrockFlower.class, (IGTObject)this);
    }

    public String getId() {
        return this.id;
    }

    public String getDomain() {
        return this.domain;
    }

    public void onItemModelBuild(ItemLike item, GTItemModelProvider prov) {
        prov.tex(item, (ResourceLocation[])this.getTextures());
    }

    public void onBlockModelBuild(Block block, GTBlockStateProvider prov) {
        GTBlockModelBuilder builder = prov.getBuilder(block);
        builder.parent(new ResourceLocation("block/cross"));
        Texture texture = this.getTextures()[0];
        builder.texture("cross", (ResourceLocation)texture);
        builder.property("particle", texture.toString());
        prov.state(block, (IModelLocation)builder);
    }

    public Texture[] getTextures() {
        return new Texture[]{new Texture(this.domain, "block/flower/" + this.getId())};
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        Vec3 vec3 = state.m_60824_(level, pos);
        return SHAPE.m_83216_(vec3.f_82479_, vec3.f_82480_, vec3.f_82481_);
    }

    public BlockBehaviour.OffsetType m_5858_() {
        return BlockBehaviour.OffsetType.XZ;
    }

    public boolean m_6266_(BlockState state, BlockGetter level, BlockPos pos) {
        if (this.sand) {
            return state.m_204336_(BlockTags.f_13029_);
        }
        return super.m_6266_(state, level, pos);
    }

    public void m_5871_(ItemStack stack, @Nullable BlockGetter level, List<Component> tooltip, TooltipFlag flag) {
        super.m_5871_(stack, level, tooltip, flag);
        tooltip.add((Component)Utils.translatable((String)("tooltip." + this.getDomain() + "." + this.getId().replace("/", ".")), (Object[])new Object[0]));
    }
}

