/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.processing.burner;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.content.processing.burner.BlazeBurnerBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ThrownEgg;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class BlazeBurnerHandler {
    @SubscribeEvent
    public static void onThrowableImpact(ProjectileImpactEvent event) {
        BlazeBurnerHandler.thrownEggsGetEatenByBurner(event);
        BlazeBurnerHandler.splashExtinguishesBurner(event);
    }

    public static void thrownEggsGetEatenByBurner(ProjectileImpactEvent event) {
        Projectile projectile = event.getProjectile();
        if (!(projectile instanceof ThrownEgg)) {
            return;
        }
        if (event.getRayTraceResult().m_6662_() != HitResult.Type.BLOCK) {
            return;
        }
        BlockEntity blockEntity = projectile.f_19853_.m_7702_(new BlockPos(event.getRayTraceResult().m_82450_()));
        if (!(blockEntity instanceof BlazeBurnerBlockEntity)) {
            return;
        }
        event.setCanceled(true);
        projectile.m_20256_(Vec3.f_82478_);
        projectile.m_146870_();
        Level world = projectile.f_19853_;
        if (world.f_46443_) {
            return;
        }
        BlazeBurnerBlockEntity heater = (BlazeBurnerBlockEntity)blockEntity;
        if (!heater.isCreative() && heater.activeFuel != BlazeBurnerBlockEntity.FuelType.SPECIAL) {
            heater.activeFuel = BlazeBurnerBlockEntity.FuelType.NORMAL;
            heater.remainingBurnTime = Mth.m_14045_((int)(heater.remainingBurnTime + 80), (int)0, (int)10000);
            heater.updateBlockState();
            heater.notifyUpdate();
        }
        AllSoundEvents.BLAZE_MUNCH.playOnServer(world, (Vec3i)heater.m_58899_());
    }

    public static void splashExtinguishesBurner(ProjectileImpactEvent event) {
        Projectile projectile = event.getProjectile();
        if (projectile.f_19853_.f_46443_) {
            return;
        }
        if (!(projectile instanceof ThrownPotion)) {
            return;
        }
        ThrownPotion entity = (ThrownPotion)projectile;
        if (event.getRayTraceResult().m_6662_() != HitResult.Type.BLOCK) {
            return;
        }
        ItemStack stack = entity.m_7846_();
        Potion potion = PotionUtils.m_43579_((ItemStack)stack);
        if (potion == Potions.f_43599_ && PotionUtils.m_43547_((ItemStack)stack).isEmpty()) {
            BlockHitResult result = (BlockHitResult)event.getRayTraceResult();
            Level world = entity.f_19853_;
            Direction face = result.m_82434_();
            BlockPos pos = result.m_82425_().m_142300_(face);
            BlazeBurnerHandler.extinguishLitBurners(world, pos, face);
            BlazeBurnerHandler.extinguishLitBurners(world, pos.m_142300_(face.m_122424_()), face);
            for (Direction face1 : Direction.Plane.HORIZONTAL) {
                BlazeBurnerHandler.extinguishLitBurners(world, pos.m_142300_(face1), face1);
            }
        }
    }

    private static void extinguishLitBurners(Level world, BlockPos pos, Direction direction) {
        BlockState state = world.m_8055_(pos);
        if (AllBlocks.LIT_BLAZE_BURNER.has(state)) {
            world.m_5594_(null, pos, SoundEvents.f_11937_, SoundSource.BLOCKS, 0.5f, 2.6f + (world.f_46441_.nextFloat() - world.f_46441_.nextFloat()) * 0.8f);
            world.m_46597_(pos, AllBlocks.BLAZE_BURNER.getDefaultState());
        }
    }
}

