/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.kinetics.deployer;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllRecipeTypes;
import com.simibubi.create.content.kinetics.deployer.DeployerApplicationRecipe;
import com.simibubi.create.content.kinetics.deployer.ItemApplicationRecipe;
import com.simibubi.create.content.processing.recipe.ProcessingOutput;
import com.simibubi.create.content.processing.recipe.ProcessingRecipeBuilder;
import com.simibubi.create.foundation.advancement.AllAdvancements;
import com.simibubi.create.foundation.advancement.CreateAdvancement;
import com.simibubi.create.foundation.utility.BlockHelper;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class ManualApplicationRecipe
extends ItemApplicationRecipe {
    @SubscribeEvent
    public static void manualApplicationRecipesApplyInWorld(PlayerInteractEvent.RightClickBlock event) {
        boolean keepHeld;
        Level level = event.getWorld();
        ItemStack heldItem = event.getItemStack();
        BlockPos pos = event.getPos();
        BlockState blockState = level.m_8055_(pos);
        if (heldItem.m_41619_()) {
            return;
        }
        if (blockState.m_60795_()) {
            return;
        }
        if (event.isCanceled()) {
            return;
        }
        Object type = AllRecipeTypes.ITEM_APPLICATION.getType();
        Optional<Recipe> foundRecipe = level.m_7465_().m_44013_(type).stream().filter(r -> {
            ManualApplicationRecipe mar = (ManualApplicationRecipe)r;
            return mar.testBlock(blockState) && ((Ingredient)mar.ingredients.get(1)).test(heldItem);
        }).findFirst();
        if (foundRecipe.isEmpty()) {
            return;
        }
        event.setCancellationResult(InteractionResult.SUCCESS);
        event.setCanceled(true);
        if (level.m_5776_()) {
            return;
        }
        level.m_5594_(null, pos, SoundEvents.f_144117_, SoundSource.PLAYERS, 1.0f, 1.45f);
        ManualApplicationRecipe recipe = (ManualApplicationRecipe)foundRecipe.get();
        level.m_46961_(pos, false);
        BlockState transformedBlock = recipe.transformBlock(blockState);
        level.m_7731_(pos, transformedBlock, 3);
        recipe.rollResults().forEach(stack -> Block.m_49840_((Level)level, (BlockPos)pos, (ItemStack)stack));
        boolean creative = event.getPlayer() != null && event.getPlayer().m_7500_();
        boolean unbreakable = heldItem.m_41782_() && heldItem.m_41783_().m_128471_("Unbreakable");
        boolean bl = keepHeld = recipe.shouldKeepHeldItem() || creative;
        if (!unbreakable && !keepHeld) {
            if (heldItem.m_41763_()) {
                heldItem.m_41622_(1, (LivingEntity)event.getPlayer(), s -> s.m_21190_(InteractionHand.MAIN_HAND));
            } else {
                heldItem.m_41774_(1);
            }
        }
        ManualApplicationRecipe.awardAdvancements(event.getPlayer(), transformedBlock);
    }

    private static void awardAdvancements(Player player, BlockState placed) {
        CreateAdvancement advancement = null;
        if (AllBlocks.ANDESITE_CASING.has(placed)) {
            advancement = AllAdvancements.ANDESITE_CASING;
        } else if (AllBlocks.BRASS_CASING.has(placed)) {
            advancement = AllAdvancements.BRASS_CASING;
        } else if (AllBlocks.COPPER_CASING.has(placed)) {
            advancement = AllAdvancements.COPPER_CASING;
        } else if (AllBlocks.RAILWAY_CASING.has(placed)) {
            advancement = AllAdvancements.TRAIN_CASING;
        } else {
            return;
        }
        advancement.awardTo(player);
    }

    public ManualApplicationRecipe(ProcessingRecipeBuilder.ProcessingRecipeParams params) {
        super(AllRecipeTypes.ITEM_APPLICATION, params);
    }

    public static DeployerApplicationRecipe asDeploying(Recipe<?> recipe) {
        ManualApplicationRecipe mar = (ManualApplicationRecipe)recipe;
        ProcessingRecipeBuilder<DeployerApplicationRecipe> builder = new ProcessingRecipeBuilder<DeployerApplicationRecipe>(DeployerApplicationRecipe::new, new ResourceLocation(mar.id.m_135827_(), mar.id.m_135815_() + "_using_deployer")).require((Ingredient)mar.ingredients.get(0)).require((Ingredient)mar.ingredients.get(1));
        for (ProcessingOutput output : mar.results) {
            builder.output(output);
        }
        if (mar.shouldKeepHeldItem()) {
            builder.toolNotConsumed();
        }
        return builder.build();
    }

    public boolean testBlock(BlockState in) {
        return ((Ingredient)this.ingredients.get(0)).test(new ItemStack((ItemLike)in.m_60734_().m_5456_()));
    }

    public BlockState transformBlock(BlockState in) {
        ProcessingOutput mainOutput = (ProcessingOutput)this.results.get(0);
        ItemStack output = mainOutput.rollOutput();
        Item item = output.m_41720_();
        if (item instanceof BlockItem) {
            BlockItem bi = (BlockItem)item;
            return BlockHelper.copyProperties(in, bi.m_40614_().m_49966_());
        }
        return Blocks.f_50016_.m_49966_();
    }

    @Override
    public List<ItemStack> rollResults() {
        return this.rollResults(this.getRollableResultsExceptBlock());
    }

    public List<ProcessingOutput> getRollableResultsExceptBlock() {
        ProcessingOutput mainOutput = (ProcessingOutput)this.results.get(0);
        if (mainOutput.getStack().m_41720_() instanceof BlockItem) {
            return this.results.subList(1, this.results.size());
        }
        return this.results;
    }
}

