/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.equipment.armor;

import com.simibubi.create.AllBlockEntityTypes;
import com.simibubi.create.AllEnchantments;
import com.simibubi.create.AllShapes;
import com.simibubi.create.content.equipment.armor.BacktankBlockEntity;
import com.simibubi.create.content.equipment.armor.BacktankItem;
import com.simibubi.create.content.kinetics.base.HorizontalKineticBlock;
import com.simibubi.create.content.schematics.requirement.ISpecialBlockItemRequirement;
import com.simibubi.create.content.schematics.requirement.ItemRequirement;
import com.simibubi.create.foundation.block.IBE;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.util.FakePlayer;

public class BacktankBlock
extends HorizontalKineticBlock
implements IBE<BacktankBlockEntity>,
SimpleWaterloggedBlock,
ISpecialBlockItemRequirement {
    public BacktankBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(false)));
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)BlockStateProperties.f_61362_) != false ? Fluids.f_76193_.m_76068_(false) : Fluids.f_76191_.m_76145_();
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{BlockStateProperties.f_61362_});
        super.m_7926_(builder);
    }

    public void m_49811_(CreativeModeTab pTab, NonNullList<ItemStack> pItems) {
    }

    public boolean m_7278_(BlockState p_149740_1_) {
        return true;
    }

    public int m_6782_(BlockState state, Level world, BlockPos pos) {
        return this.getBlockEntityOptional((BlockGetter)world, pos).map(BacktankBlockEntity::getComparatorOutput).orElse(0);
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighbourState, LevelAccessor world, BlockPos pos, BlockPos neighbourPos) {
        if (((Boolean)state.m_61143_((Property)BlockStateProperties.f_61362_)).booleanValue()) {
            world.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)world));
        }
        return state;
    }

    @Override
    public BlockState m_5573_(BlockPlaceContext context) {
        FluidState fluidState = context.m_43725_().m_6425_(context.m_8083_());
        return (BlockState)super.m_5573_(context).m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(fluidState.m_76152_() == Fluids.f_76193_));
    }

    @Override
    public boolean hasShaftTowards(LevelReader world, BlockPos pos, BlockState state, Direction face) {
        return face == Direction.UP;
    }

    @Override
    public Direction.Axis getRotationAxis(BlockState state) {
        return Direction.Axis.Y;
    }

    @Override
    public void m_6402_(Level worldIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        super.m_6402_(worldIn, pos, state, placer, stack);
        if (worldIn.f_46443_) {
            return;
        }
        if (stack == null) {
            return;
        }
        this.withBlockEntityDo((BlockGetter)worldIn, pos, be -> {
            CompoundTag nbt;
            be.setCapacityEnchantLevel(EnchantmentHelper.m_44843_((Enchantment)((Enchantment)AllEnchantments.CAPACITY.get()), (ItemStack)stack));
            CompoundTag vanillaTag = stack.m_41784_();
            be.setAirLevel(vanillaTag.m_128451_("Air"));
            if (stack.m_41788_()) {
                be.setCustomName(stack.m_41786_());
            }
            CompoundTag forgeCapsTag = (nbt = stack.serializeNBT()).m_128441_("ForgeCaps") ? nbt.m_128469_("ForgeCaps") : null;
            be.setTags(vanillaTag, forgeCapsTag);
        });
    }

    public List<ItemStack> m_7381_(BlockState pState, LootContext.Builder pBuilder) {
        List lootDrops = super.m_7381_(pState, pBuilder);
        BlockEntity blockEntity = (BlockEntity)pBuilder.m_78982_(LootContextParams.f_81462_);
        if (!(blockEntity instanceof BacktankBlockEntity)) {
            return lootDrops;
        }
        BacktankBlockEntity bbe = (BacktankBlockEntity)blockEntity;
        CompoundTag forgeCapsTag = bbe.getForgeCapsTag();
        if (forgeCapsTag == null) {
            return lootDrops;
        }
        return lootDrops.stream().map(stack -> {
            if (!(stack.m_41720_() instanceof BacktankItem)) {
                return stack;
            }
            ItemStack modifiedStack = new ItemStack((ItemLike)stack.m_41720_(), stack.m_41613_(), forgeCapsTag.m_6426_());
            modifiedStack.m_41751_(stack.m_41783_());
            return modifiedStack;
        }).toList();
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (player == null) {
            return InteractionResult.PASS;
        }
        if (player instanceof FakePlayer) {
            return InteractionResult.PASS;
        }
        if (player.m_6144_()) {
            return InteractionResult.PASS;
        }
        if (player.m_21205_().m_41720_() instanceof BlockItem) {
            return InteractionResult.PASS;
        }
        if (!player.m_6844_(EquipmentSlot.CHEST).m_41619_()) {
            return InteractionResult.PASS;
        }
        if (!world.f_46443_) {
            world.m_5594_(null, pos, SoundEvents.f_12019_, SoundSource.PLAYERS, 0.75f, 1.0f);
            player.m_8061_(EquipmentSlot.CHEST, this.m_7397_((BlockGetter)world, pos, state));
            world.m_46961_(pos, false);
        }
        return InteractionResult.SUCCESS;
    }

    public ItemStack m_7397_(BlockGetter blockGetter, BlockPos pos, BlockState state) {
        Item item = this.m_5456_();
        if (item instanceof BacktankItem.BacktankBlockItem) {
            BacktankItem.BacktankBlockItem placeable = (BacktankItem.BacktankBlockItem)item;
            item = placeable.getActualItem();
        }
        Optional blockEntityOptional = this.getBlockEntityOptional(blockGetter, pos);
        CompoundTag forgeCapsTag = blockEntityOptional.map(BacktankBlockEntity::getForgeCapsTag).orElse(null);
        CompoundTag vanillaTag = blockEntityOptional.map(BacktankBlockEntity::getVanillaTag).orElse(new CompoundTag());
        int air = blockEntityOptional.map(BacktankBlockEntity::getAirLevel).orElse(0);
        ItemStack stack = new ItemStack((ItemLike)item, 1, forgeCapsTag);
        vanillaTag.m_128405_("Air", air);
        stack.m_41751_(vanillaTag);
        return stack;
    }

    public VoxelShape m_5940_(BlockState p_220053_1_, BlockGetter p_220053_2_, BlockPos p_220053_3_, CollisionContext p_220053_4_) {
        return AllShapes.BACKTANK;
    }

    @Override
    public Class<BacktankBlockEntity> getBlockEntityClass() {
        return BacktankBlockEntity.class;
    }

    @Override
    public BlockEntityType<? extends BacktankBlockEntity> getBlockEntityType() {
        return (BlockEntityType)AllBlockEntityTypes.BACKTANK.get();
    }

    public boolean m_7357_(BlockState state, BlockGetter reader, BlockPos pos, PathComputationType type) {
        return false;
    }

    @Override
    public ItemRequirement getRequiredItems(BlockState state, BlockEntity blockEntity) {
        Item item = this.m_5456_();
        if (item instanceof BacktankItem.BacktankBlockItem) {
            BacktankItem.BacktankBlockItem placeable = (BacktankItem.BacktankBlockItem)item;
            item = placeable.getActualItem();
        }
        return new ItemRequirement(ItemRequirement.ItemUseType.CONSUME, item);
    }
}

