/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.render;

import appeng.api.client.AEStackRendering;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.AmountFormat;
import appeng.util.Platform;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.Direction;

public class BlockEntityRenderHelper {
    public static byte findSpin(Direction facing, Direction up) {
        Direction currentUp = switch (facing) {
            case Direction.UP -> Direction.NORTH;
            case Direction.DOWN -> Direction.SOUTH;
            default -> Direction.UP;
        };
        for (byte spin = 0; spin < 4; spin = (byte)(spin + 1)) {
            if (currentUp == up) {
                return spin;
            }
            currentUp = Platform.rotateAround(currentUp, facing);
        }
        return 0;
    }

    public static void rotateToFace(PoseStack mStack, Direction face, byte spin) {
        switch (face) {
            case UP: {
                mStack.m_85845_(Vector3f.f_122223_.m_122240_(270.0f));
                break;
            }
            case DOWN: {
                mStack.m_85845_(Vector3f.f_122223_.m_122240_(90.0f));
                break;
            }
            case EAST: {
                mStack.m_85845_(Vector3f.f_122225_.m_122240_(90.0f));
                break;
            }
            case WEST: {
                mStack.m_85845_(Vector3f.f_122225_.m_122240_(-90.0f));
                break;
            }
            case NORTH: {
                mStack.m_85845_(Vector3f.f_122225_.m_122240_(180.0f));
                break;
            }
        }
        mStack.m_85850_().m_85861_().m_27646_(Vector3f.f_122227_.m_122240_((float)(-spin) * 90.0f));
    }

    public static void renderItem2d(PoseStack poseStack, MultiBufferSource buffers, AEKey what, float scale, int combinedLightIn) {
        AEStackRendering.drawOnBlockFace(poseStack, buffers, what, scale, combinedLightIn);
    }

    public static void renderItem2dWithAmount(PoseStack poseStack, MultiBufferSource buffers, AEKey what, long amount, float itemScale, float spacing, int textColor) {
        BlockEntityRenderHelper.renderItem2d(poseStack, buffers, what, itemScale, 0xF000F0);
        String renderedStackSize = what.formatAmount(amount, AmountFormat.PREVIEW_REGULAR);
        Font fr = Minecraft.m_91087_().f_91062_;
        int width = fr.m_92895_(renderedStackSize);
        poseStack.m_85836_();
        poseStack.m_85837_(0.0, (double)spacing, (double)0.02f);
        poseStack.m_85841_(0.016129032f, -0.016129032f, 0.016129032f);
        poseStack.m_85841_(0.5f, 0.5f, 0.0f);
        poseStack.m_85837_((double)(-0.5f * (float)width), 0.0, 0.5);
        fr.m_92811_(renderedStackSize, 0.0f, 0.0f, textColor, false, poseStack.m_85850_().m_85861_(), buffers, false, 0, 0xF000F0);
        poseStack.m_85849_();
    }
}

