/*
 * Decompiled with CFR 0.152.
 */
package org.labellum.mc.waterflasks.setup;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.List;
import net.dries007.tfc.util.JsonHelpers;
import net.minecraft.Util;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.common.loot.LootModifier;
import org.jetbrains.annotations.NotNull;
import org.labellum.mc.waterflasks.Waterflasks;
import org.slf4j.Logger;

public class AddItemChanceModifier
extends LootModifier {
    private final ItemStack item;
    private final double chance;

    protected AddItemChanceModifier(LootItemCondition[] conditions, ItemStack item, double chance) {
        super(conditions);
        this.item = item;
        this.chance = chance;
    }

    @NotNull
    protected List<ItemStack> doApply(List<ItemStack> loot, LootContext context) {
        Player player = (Player)context.m_78953_(LootContextParams.f_81456_);
        double bonus = 0.0;
        if (player != null) {
            bonus = player.m_21133_(Attributes.f_22281_) / 30.0;
        }
        if (context.m_78933_().nextDouble() < this.chance + bonus) {
            loot.add(this.item.m_41777_());
        }
        return loot;
    }

    public static class Serializer
    extends GlobalLootModifierSerializer<AddItemChanceModifier> {
        public AddItemChanceModifier read(ResourceLocation location, JsonObject json, LootItemCondition[] conditions) {
            return new AddItemChanceModifier(conditions, JsonHelpers.getItemStack((JsonObject)json, (String)"item"), JsonHelpers.m_144742_((JsonObject)json, (String)"chance", (double)1.0));
        }

        public JsonObject write(AddItemChanceModifier instance) {
            JsonObject json = this.makeConditions(instance.conditions);
            json.add("item", Serializer.codecToJson(ItemStack.f_41582_, instance.item));
            json.add("chance", Serializer.codecToJson(Codec.DOUBLE, instance.chance));
            return json;
        }

        public static <T> JsonElement codecToJson(Codec<T> codec, T instance) {
            return (JsonElement)codec.encodeStart((DynamicOps)JsonOps.INSTANCE, instance).getOrThrow(false, Util.m_137489_((String)"Error encoding: ", arg_0 -> ((Logger)Waterflasks.LOGGER).error(arg_0)));
        }
    }
}

