/*
 * Decompiled with CFR 0.152.
 */
package com.hyperdash.firmaciv.events;

import com.hyperdash.firmaciv.block.blockentity.custom.CanoeComponentBlockEntity;
import com.hyperdash.firmaciv.block.custom.CanoeComponentBlock;
import com.hyperdash.firmaciv.config.FirmacivConfig;
import com.hyperdash.firmaciv.util.FirmacivTags;
import net.dries007.tfc.util.events.StartFireEvent;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="firmaciv", bus=Mod.EventBusSubscriber.Bus.FORGE)
public final class FirmacivBlockEvents {
    private FirmacivBlockEvents() {
    }

    @SubscribeEvent
    public static void registerFireStarterEvents(StartFireEvent event) {
        BlockEntity blockEntity;
        if (event.getState().m_204336_(FirmacivTags.Blocks.CANOE_COMPONENT_BLOCKS) && (Integer)event.getState().m_61143_((Property)CanoeComponentBlock.CANOE_CARVED) == 11 && (blockEntity = event.getPlayer().m_183503_().m_7702_(event.getPos())) instanceof CanoeComponentBlockEntity) {
            CanoeComponentBlockEntity ccBlockEntity = (CanoeComponentBlockEntity)blockEntity;
            ccBlockEntity.light();
        }
    }

    @SubscribeEvent
    public static void registerToolModificationEvents(BlockEvent.BlockToolModificationEvent event) {
        if (event.getToolAction() == ToolActions.AXE_STRIP && (event.getState().m_204336_(FirmacivTags.Blocks.CAN_MAKE_CANOE) || !((Boolean)FirmacivConfig.SERVER.canoeWoodRestriction.get()).booleanValue() && event.getState().m_204336_(FirmacivTags.Blocks.CAN_MAKE_CANOE_UNRESTRICTED)) && event.getPlayer().m_21120_(event.getPlayer().m_7655_()).m_204117_(FirmacivTags.Items.SAWS) && ((Direction.Axis)event.getState().m_61143_((Property)BlockStateProperties.f_61365_)).m_122479_()) {
            FirmacivBlockEvents.convertLogToCanoeComponent(event);
        }
        if (event.getToolAction() == ToolActions.AXE_STRIP && event.getState().m_204336_(FirmacivTags.Blocks.CANOE_COMPONENT_BLOCKS) && ((Direction.Axis)event.getState().m_61143_((Property)BlockStateProperties.f_61365_)).m_122479_()) {
            FirmacivBlockEvents.processCanoeComponent(event);
        }
    }

    private static void processCanoeComponent(BlockEvent.BlockToolModificationEvent event) {
        Block canoeComponentBlock = event.getState().m_60734_();
        BlockState canoeComponentBlockState = event.getState();
        BlockPos thisBlockPos = event.getPos();
        LevelAccessor world = event.getWorld();
        Direction.Axis axis = (Direction.Axis)event.getState().m_61143_(CanoeComponentBlock.AXIS);
        int nextCanoeCarvedState = (Integer)event.getState().m_61143_((Property)CanoeComponentBlock.CANOE_CARVED) + 1;
        if ((Integer)canoeComponentBlockState.m_61143_((Property)CanoeComponentBlock.CANOE_CARVED) < 5 && event.getPlayer().m_21120_(event.getPlayer().m_7655_()).m_204117_(FirmacivTags.Items.SAWS)) {
            world.m_7731_(thisBlockPos, (BlockState)event.getState().m_61124_((Property)CanoeComponentBlock.CANOE_CARVED, (Comparable)Integer.valueOf(nextCanoeCarvedState)), 2);
            event.getPlayer().f_19853_.m_142052_(thisBlockPos, canoeComponentBlockState);
            event.getPlayer().m_21120_(event.getContext().m_43724_()).m_41780_();
            world.m_5594_(event.getPlayer(), thisBlockPos, SoundEvents.f_11688_, SoundSource.BLOCKS, 1.0f, 1.0f);
            if (nextCanoeCarvedState == 5) {
                Block.m_49892_((BlockState)canoeComponentBlockState, (LevelAccessor)world, (BlockPos)thisBlockPos.m_7494_(), null);
            }
        } else if ((Integer)canoeComponentBlockState.m_61143_((Property)CanoeComponentBlock.CANOE_CARVED) >= 5 && (Integer)canoeComponentBlockState.m_61143_((Property)CanoeComponentBlock.CANOE_CARVED) < 11 && event.getPlayer().m_21120_(event.getPlayer().m_7655_()).m_204117_(FirmacivTags.Items.AXES)) {
            BlockPos blockPos1 = thisBlockPos.m_142629_(axis, -2);
            boolean flag = false;
            int row = 0;
            for (int i = -2; i <= 2; ++i) {
                blockPos1 = thisBlockPos.m_142629_(axis, i);
                if (world.m_8055_(blockPos1).m_60713_(canoeComponentBlock) && (Integer)world.m_8055_(blockPos1).m_61143_((Property)CanoeComponentBlock.CANOE_CARVED) >= 5) {
                    flag = ++row >= 3;
                    continue;
                }
                row = 0;
            }
            if (flag) {
                world.m_7731_(thisBlockPos, (BlockState)event.getState().m_61124_((Property)CanoeComponentBlock.CANOE_CARVED, (Comparable)Integer.valueOf(nextCanoeCarvedState)), 2);
                event.getPlayer().f_19853_.m_142052_(thisBlockPos, canoeComponentBlockState);
                event.getPlayer().m_21120_(event.getContext().m_43724_()).m_41780_();
                world.m_5594_(event.getPlayer(), thisBlockPos, SoundEvents.f_11688_, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
        }
    }

    private static void convertLogToCanoeComponent(BlockEvent.BlockToolModificationEvent event) {
        Block strippedLogBlock = event.getState().m_60734_();
        BlockPos thisBlockPos = event.getPos();
        LevelAccessor world = event.getWorld();
        Level level = event.getPlayer().m_183503_();
        if (CanoeComponentBlock.isValidCanoeShape(world, strippedLogBlock, thisBlockPos)) {
            world.m_5594_(event.getPlayer(), thisBlockPos, SoundEvents.f_11688_, SoundSource.BLOCKS, 1.0f, 1.0f);
            event.getPlayer().f_19853_.m_142052_(thisBlockPos, event.getState());
            Block canoeComponentBlock = CanoeComponentBlock.getByStripped(strippedLogBlock);
            canoeComponentBlock.m_49966_().m_61124_(CanoeComponentBlock.AXIS, (Comparable)Direction.Axis.Z);
            Direction.Axis axis = (Direction.Axis)event.getState().m_61143_(CanoeComponentBlock.AXIS);
            world.m_7731_(thisBlockPos, CanoeComponentBlock.getStateForPlacement(level, strippedLogBlock, thisBlockPos), 2);
            BlockPos blockPos1 = thisBlockPos.m_142629_(axis, 1);
            BlockPos blockPos2 = thisBlockPos.m_142629_(axis, -1);
            if (world.m_8055_(blockPos1).m_60713_(canoeComponentBlock) && world.m_8055_(blockPos2).m_60713_(canoeComponentBlock)) {
                CanoeComponentBlock.setEndPieces(event.getPlayer().m_183503_(), thisBlockPos, canoeComponentBlock, true);
                CanoeComponentBlock.setEndPieces(event.getPlayer().m_183503_(), thisBlockPos.m_142629_(axis, -1), canoeComponentBlock, false);
            } else if (level.m_8055_(blockPos1).m_60713_(canoeComponentBlock)) {
                CanoeComponentBlock.setEndPieces(level, blockPos1, canoeComponentBlock, true);
            } else {
                CanoeComponentBlock.setEndPieces(level, blockPos2, canoeComponentBlock, false);
            }
        }
    }
}

