/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.tool.behaviour;

import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.shapes.CollisionContext;
import org.gtreimagined.gtlib.behaviour.IItemUse;
import org.gtreimagined.gtlib.tool.IBasicGTTool;
import org.jetbrains.annotations.Nullable;

public class BehaviourTorchPlacing
implements IItemUse<IBasicGTTool> {
    public static final BehaviourTorchPlacing INSTANCE = new BehaviourTorchPlacing();

    @Override
    public String getId() {
        return "torch_placing";
    }

    @Override
    public InteractionResult onItemUse(IBasicGTTool instance, UseOnContext c) {
        InteractionResult resultType;
        ItemStack stack = ItemStack.f_41583_;
        if (c.m_43723_() == null) {
            return InteractionResult.PASS;
        }
        for (ItemStack stack1 : c.m_43723_().m_150109_().f_35974_) {
            if (stack1.m_41720_() != Items.f_42000_ && stack1.m_41720_() != Items.f_42053_) continue;
            stack = stack1;
            break;
        }
        if (!stack.m_41619_() && (resultType = stack.m_41661_(new UseOnContext(c.m_43723_().m_183503_(), c.m_43723_(), c.m_43724_(), stack, c.m_43718_()))).m_19077_()) {
            return resultType;
        }
        return InteractionResult.PASS;
    }

    public static InteractionResult tryPlace(BlockPlaceContext context, ItemStack torch) {
        if (!context.m_7059_()) {
            return InteractionResult.FAIL;
        }
        BlockState blockstate = BehaviourTorchPlacing.getStateForPlacement(context, torch);
        if (blockstate == null) {
            return InteractionResult.FAIL;
        }
        if (!BehaviourTorchPlacing.placeBlock(context, blockstate)) {
            return InteractionResult.FAIL;
        }
        BlockPos blockpos = context.m_8083_();
        Level level = context.m_43725_();
        Player player = context.m_43723_();
        BlockState blockstate2 = level.m_8055_(blockpos);
        Block block = blockstate2.m_60734_();
        if (block == blockstate.m_60734_()) {
            blockstate2 = BehaviourTorchPlacing.updateBlockStateFromTag(blockpos, level, torch, blockstate2);
            BlockItem.m_40582_((Level)level, (Player)player, (BlockPos)blockpos, (ItemStack)torch);
            block.m_6402_(level, blockpos, blockstate2, (LivingEntity)player, torch);
            if (player instanceof ServerPlayer) {
                CriteriaTriggers.f_10591_.m_59469_((ServerPlayer)player, blockpos, torch);
            }
        }
        level.m_142346_((Entity)player, GameEvent.f_157797_, blockpos);
        SoundType soundtype = blockstate2.m_60827_();
        level.m_5594_(player, blockpos, Blocks.f_50081_.m_49962_(blockstate2).m_56777_(), SoundSource.BLOCKS, (soundtype.m_56773_() + 1.0f) / 2.0f, soundtype.m_56774_() * 0.8f);
        return InteractionResult.m_19078_((boolean)level.f_46443_);
    }

    private static BlockState updateBlockStateFromTag(BlockPos pos, Level level, ItemStack stack, BlockState state) {
        BlockState blockState = state;
        CompoundTag compoundTag = stack.m_41783_();
        if (compoundTag != null) {
            CompoundTag compoundTag2 = compoundTag.m_128469_("BlockStateTag");
            StateDefinition stateDefinition = blockState.m_60734_().m_49965_();
            for (String string : compoundTag2.m_128431_()) {
                Property property = stateDefinition.m_61081_(string);
                if (property == null) continue;
                String string2 = compoundTag2.m_128423_(string).m_7916_();
                blockState = BehaviourTorchPlacing.updateState(blockState, property, string2);
            }
        }
        if (blockState != state) {
            level.m_7731_(pos, blockState, 2);
        }
        return blockState;
    }

    private static <T extends Comparable<T>> BlockState updateState(BlockState state, Property<T> property, String value) {
        return property.m_6215_(value).map(p_219986_2_ -> (BlockState)state.m_61124_(property, p_219986_2_)).orElse(state);
    }

    protected static boolean placeBlock(BlockPlaceContext context, BlockState state) {
        return context.m_43725_().m_7731_(context.m_8083_(), state, 11);
    }

    @Nullable
    protected static BlockState getStateForPlacement(BlockPlaceContext context, ItemStack torch) {
        BlockState blockstate = torch.m_41720_() == Items.f_42053_ ? Blocks.f_50140_.m_5573_(context) : Blocks.f_50082_.m_5573_(context);
        BlockState blockstate1 = null;
        Level iworldreader = context.m_43725_();
        BlockPos blockpos = context.m_8083_();
        for (Direction direction : context.m_6232_()) {
            BlockState blockstate2;
            if (direction == Direction.UP) continue;
            BlockState blockState = direction == Direction.DOWN ? (torch.m_41720_() == Items.f_42053_ ? Blocks.f_50139_.m_5573_(context) : Blocks.f_50081_.m_5573_(context)) : (blockstate2 = blockstate);
            if (blockstate2 == null || !blockstate2.m_60710_((LevelReader)iworldreader, blockpos)) continue;
            blockstate1 = blockstate2;
            break;
        }
        return blockstate1 != null && iworldreader.m_45752_(blockstate1, blockpos, CollisionContext.m_82749_()) ? blockstate1 : null;
    }
}

