/*
 * Decompiled with CFR 0.152.
 */
package com.eerussianguy.firmalife.compat.patchouli;

import com.eerussianguy.firmalife.common.FLHelpers;
import com.eerussianguy.firmalife.common.FLTags;
import com.eerussianguy.firmalife.common.blocks.FLBlocks;
import com.eerussianguy.firmalife.common.blocks.greenhouse.ClimateStationBlock;
import com.eerussianguy.firmalife.common.blocks.greenhouse.Greenhouse;
import com.eerussianguy.firmalife.common.blocks.greenhouse.GreenhouseDoorBlock;
import com.eerussianguy.firmalife.common.blocks.greenhouse.GreenhouseSlabBlock;
import com.eerussianguy.firmalife.common.blocks.greenhouse.GreenhouseStairBlock;
import com.eerussianguy.firmalife.common.blocks.greenhouse.GreenhouseWallBlock;
import java.util.Map;
import java.util.function.Function;
import net.dries007.tfc.common.blocks.TFCBlocks;
import net.dries007.tfc.common.blocks.soil.SoilBlockType;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.Direction;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraftforge.registries.RegistryObject;
import vazkii.patchouli.api.IMultiblock;
import vazkii.patchouli.api.IStateMatcher;
import vazkii.patchouli.api.PatchouliAPI;

public class FLPatchouliIntegration {
    public static void registerMultiBlocks() {
        FLPatchouliIntegration.registerMultiblock("treated_wood_greenhouse", api -> FLPatchouliIntegration.greenhouse(api, Greenhouse.TREATED_WOOD, FLTags.Blocks.ALL_TREATED_WOOD_GREENHOUSE));
        FLPatchouliIntegration.registerMultiblock("copper_greenhouse", api -> FLPatchouliIntegration.greenhouse(api, Greenhouse.COPPER, FLTags.Blocks.ALL_COPPER_GREENHOUSE));
        FLPatchouliIntegration.registerMultiblock("iron_greenhouse", api -> FLPatchouliIntegration.greenhouse(api, Greenhouse.IRON, FLTags.Blocks.ALL_IRON_GREENHOUSE));
        FLPatchouliIntegration.registerMultiblock("stainless_steel_greenhouse", api -> FLPatchouliIntegration.greenhouse(api, Greenhouse.IRON, FLTags.Blocks.STAINLESS_STEEL_GREENHOUSE));
        FLPatchouliIntegration.registerMultiblock("cellar", FLPatchouliIntegration::cellar);
    }

    private static IMultiblock cellar(PatchouliAPI.IPatchouliAPI api) {
        Block door = (Block)FLBlocks.SEALED_DOOR.get();
        IStateMatcher doorBottom = api.predicateMatcher((BlockState)((BlockState)door.m_49966_().m_61124_((Property)GreenhouseDoorBlock.f_52730_, (Comparable)DoubleBlockHalf.LOWER)).m_61124_((Property)DoorBlock.f_52726_, (Comparable)Direction.EAST), s -> Helpers.isBlock((BlockState)s, (Block)door));
        IStateMatcher doorTop = api.predicateMatcher((BlockState)((BlockState)door.m_49966_().m_61124_((Property)GreenhouseDoorBlock.f_52730_, (Comparable)DoubleBlockHalf.UPPER)).m_61124_((Property)DoorBlock.f_52726_, (Comparable)Direction.EAST), s -> Helpers.isBlock((BlockState)s, (Block)door));
        return api.makeMultiblock((String[][])new String[][]{{"XXXXX", "XXXXX", "XXXXX", "XXXXX", "XXXXX"}, {"XXXXX", "X   X", "X   X", "X   X", "XXXXX"}, {"XXXXX", "X   X", "X   X", "X   X", "XXXXX"}, {"XXEXX", "X   X", "X 0 X", "X   X", "XXXXX"}, {"XXDXX", "X   X", "X   X", "X   X", "XXXXX"}, {"XXXXX", "XXXXX", "XXXXX", "XXXXX", "XXXXX"}}, new Object[]{Character.valueOf('0'), api.airMatcher(), Character.valueOf('X'), api.stateMatcher(((Block)FLBlocks.SEALED_BRICKS.get()).m_49966_()), Character.valueOf('D'), doorBottom, Character.valueOf('E'), doorTop});
    }

    private static IMultiblock greenhouse(PatchouliAPI.IPatchouliAPI api, Greenhouse greenhouse, TagKey<Block> tag) {
        IStateMatcher wall = api.predicateMatcher(FLPatchouliIntegration.greenBlock(greenhouse, Greenhouse.BlockType.WALL), s -> Helpers.isBlock((BlockState)s, (TagKey)tag) && s.m_60734_() instanceof GreenhouseWallBlock);
        IStateMatcher roof = api.predicateMatcher((BlockState)FLPatchouliIntegration.greenBlock(greenhouse, Greenhouse.BlockType.ROOF).m_61124_((Property)StairBlock.f_56841_, (Comparable)Direction.EAST), s -> Helpers.isBlock((BlockState)s, (TagKey)tag) && s.m_60734_() instanceof GreenhouseStairBlock && s.m_61143_((Property)StairBlock.f_56842_) == Half.BOTTOM);
        IStateMatcher roof2 = api.predicateMatcher((BlockState)FLPatchouliIntegration.greenBlock(greenhouse, Greenhouse.BlockType.ROOF).m_61124_((Property)StairBlock.f_56841_, (Comparable)Direction.WEST), s -> Helpers.isBlock((BlockState)s, (TagKey)tag) && s.m_60734_() instanceof GreenhouseStairBlock && s.m_61143_((Property)StairBlock.f_56842_) == Half.BOTTOM);
        IStateMatcher top = api.predicateMatcher(FLPatchouliIntegration.greenBlock(greenhouse, Greenhouse.BlockType.ROOF_TOP), s -> Helpers.isBlock((BlockState)s, (TagKey)tag) && s.m_60734_() instanceof GreenhouseSlabBlock && s.m_61143_((Property)SlabBlock.f_56353_) == SlabType.BOTTOM);
        IStateMatcher doorT = api.predicateMatcher((BlockState)((BlockState)FLPatchouliIntegration.greenBlock(greenhouse, Greenhouse.BlockType.DOOR).m_61124_((Property)GreenhouseDoorBlock.f_52730_, (Comparable)DoubleBlockHalf.UPPER)).m_61124_((Property)GreenhouseDoorBlock.f_52726_, (Comparable)Direction.EAST), s -> Helpers.isBlock((BlockState)s, (TagKey)tag) && s.m_60734_() instanceof GreenhouseDoorBlock);
        IStateMatcher doorB = api.predicateMatcher((BlockState)((BlockState)FLPatchouliIntegration.greenBlock(greenhouse, Greenhouse.BlockType.DOOR).m_61124_((Property)GreenhouseDoorBlock.f_52730_, (Comparable)DoubleBlockHalf.LOWER)).m_61124_((Property)GreenhouseDoorBlock.f_52726_, (Comparable)Direction.EAST), s -> Helpers.isBlock((BlockState)s, (TagKey)tag) && s.m_60734_() instanceof GreenhouseDoorBlock);
        IStateMatcher solid = api.predicateMatcher((Block)((RegistryObject)((Map)TFCBlocks.SOIL.get(SoilBlockType.DIRT)).get(SoilBlockType.Variant.SILTY_LOAM)).get(), s -> s.m_60767_().m_76333_());
        IStateMatcher station = api.predicateMatcher((BlockState)((Block)FLBlocks.CLIMATE_STATION.get()).m_49966_().m_61124_((Property)ClimateStationBlock.STASIS, (Comparable)Boolean.valueOf(true)), s -> Helpers.isBlock((BlockState)s, (Block)((Block)FLBlocks.CLIMATE_STATION.get())));
        return api.makeMultiblock((String[][])new String[][]{{"     ", "     ", "TTTTT", "     ", "     "}, {"     ", "RRRRR", "W   W", "SSSSS", "     "}, {"RRRRR", "W   W", "W   W", "W   W", "SSSSS"}, {"WWWWW", "W   W", "W 0 W", "W   W", "WWWWW"}, {"WWEWW", "W   W", "W   W", "W   W", "WWWWW"}, {"WWDWW", "W  CW", "W   W", "W   W", "WWWWW"}, {"GGGGG", "GGGGG", "GGGGG", "GGGGG", "GGGGG"}}, new Object[]{Character.valueOf('C'), station, Character.valueOf('0'), api.airMatcher(), Character.valueOf('W'), wall, Character.valueOf('G'), solid, Character.valueOf('T'), top, Character.valueOf('R'), roof, Character.valueOf('S'), roof2, Character.valueOf('D'), doorB, Character.valueOf('E'), doorT});
    }

    private static BlockState greenBlock(Greenhouse greenhouse, Greenhouse.BlockType block) {
        return ((Block)FLBlocks.GREENHOUSE_BLOCKS.get((Object)greenhouse).get((Object)block).get()).m_49966_();
    }

    private static void registerMultiblock(String name, Function<PatchouliAPI.IPatchouliAPI, IMultiblock> factory) {
        PatchouliAPI.IPatchouliAPI api = PatchouliAPI.get();
        api.registerMultiblock(FLHelpers.identifier(name), factory.apply(api));
    }
}

