/*
 * Decompiled with CFR 0.152.
 */
package com.eerussianguy.firmalife.common.blocks;

import com.eerussianguy.firmalife.common.FLHelpers;
import com.eerussianguy.firmalife.common.blockentities.ClimateReceiver;
import com.eerussianguy.firmalife.common.blockentities.FLBlockEntities;
import com.eerussianguy.firmalife.common.blocks.FLStateProperties;
import com.eerussianguy.firmalife.common.util.FoodAge;
import com.eerussianguy.firmalife.config.FLConfig;
import java.util.Random;
import java.util.function.Supplier;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.TFCBlockStateProperties;
import net.dries007.tfc.common.blocks.devices.BottomSupportedDeviceBlock;
import net.dries007.tfc.common.blocks.devices.DeviceBlock;
import net.dries007.tfc.common.capabilities.food.FoodCapability;
import net.dries007.tfc.common.capabilities.food.FoodTrait;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.Nullable;

public class CheeseWheelBlock
extends BottomSupportedDeviceBlock
implements ClimateReceiver {
    public static final IntegerProperty COUNT = TFCBlockStateProperties.COUNT_1_4;
    public static final EnumProperty<FoodAge> AGE = FLStateProperties.AGE;
    public static final BooleanProperty AGING = FLStateProperties.AGING;
    private static final VoxelShape SHAPE_1 = CheeseWheelBlock.m_49796_((double)8.0, (double)0.0, (double)8.0, (double)15.0, (double)8.0, (double)15.0);
    private static final VoxelShape SHAPE_2 = CheeseWheelBlock.m_49796_((double)8.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0);
    private static final VoxelShape SHAPE_3 = Shapes.m_83110_((VoxelShape)CheeseWheelBlock.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)8.0, (double)8.0, (double)8.0), (VoxelShape)CheeseWheelBlock.m_49796_((double)8.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0));
    private static final VoxelShape SHAPE_4 = CheeseWheelBlock.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0);
    private static final VoxelShape[] SHAPES = new VoxelShape[]{SHAPE_1, SHAPE_2, SHAPE_3, SHAPE_4};
    private final Supplier<? extends Item> slice;

    public static VoxelShape getShape(int slices) {
        return SHAPES[slices - 1];
    }

    public CheeseWheelBlock(ExtendedProperties properties, Supplier<? extends Item> slice) {
        super(properties, DeviceBlock.InventoryRemoveBehavior.DROP, SHAPE_4);
        this.slice = slice;
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)COUNT, (Comparable)Integer.valueOf(4))).m_61124_(AGE, (Comparable)((Object)FoodAge.FRESH))).m_61124_((Property)AGING, (Comparable)Boolean.valueOf(false)));
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack held = player.m_21120_(hand);
        if (Helpers.isItem((ItemStack)held, (TagKey)TFCTags.Items.KNIVES)) {
            int count = (Integer)state.m_61143_((Property)COUNT);
            ItemStack drop = new ItemStack((ItemLike)this.slice.get());
            FoodCapability.applyTrait((ItemStack)drop, (FoodTrait)((FoodAge)((Object)state.m_61143_(AGE))).getTrait());
            drop.getCapability(FoodCapability.CAPABILITY).ifPresent(cap -> cap.setCreationDate(FoodCapability.getRoundedCreationDate()));
            ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)drop);
            FLHelpers.resetCounter(level, pos);
            if (count - 1 == 0) {
                level.m_46961_(pos, false);
            } else {
                Helpers.playSound((Level)level, (BlockPos)pos, (SoundEvent)this.getSoundType(state, (LevelReader)level, pos, (Entity)player).m_56775_());
                level.m_46597_(pos, (BlockState)state.m_61124_((Property)COUNT, (Comparable)Integer.valueOf(count - 1)));
            }
        }
        return InteractionResult.PASS;
    }

    public boolean m_6724_(BlockState state) {
        return (Integer)state.m_61143_((Property)COUNT) == 4;
    }

    public void m_7455_(BlockState state, ServerLevel level, BlockPos pos, Random rand) {
        level.m_141902_(pos, (BlockEntityType)FLBlockEntities.TICK_COUNTER.get()).ifPresent(counter -> {
            if (((Boolean)state.m_61143_((Property)AGING)).booleanValue()) {
                long days = counter.getTicksSinceUpdate() / 24000L;
                if (state.m_61143_(AGE) == FoodAge.FRESH && (Integer)state.m_61143_((Property)COUNT) == 4 && days > (long)((Integer)FLConfig.SERVER.cheeseAgedDays.get()).intValue()) {
                    level.m_46597_(pos, (BlockState)state.m_61124_(AGE, (Comparable)((Object)FoodAge.AGED)));
                    counter.resetCounter();
                } else if (state.m_61143_(AGE) == FoodAge.AGED && (Integer)state.m_61143_((Property)COUNT) == 4 && days > (long)((Integer)FLConfig.SERVER.cheeseVintageDays.get()).intValue()) {
                    level.m_46597_(pos, (BlockState)state.m_61124_(AGE, (Comparable)((Object)FoodAge.VINTAGE)));
                }
            } else {
                counter.resetCounter();
            }
        });
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.m_6402_(level, pos, state, placer, stack);
        FLHelpers.resetCounter(level, pos);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return CheeseWheelBlock.getShape((Integer)state.m_61143_((Property)COUNT));
    }

    @Override
    public void setValid(Level level, BlockPos pos, boolean valid, int tier, boolean cellar) {
        BlockState state = level.m_8055_(pos);
        if (state.m_60734_() instanceof CheeseWheelBlock) {
            boolean shouldAge;
            boolean isAgingNow = (Boolean)state.m_61143_((Property)AGING);
            boolean bl = shouldAge = valid && cellar;
            if (isAgingNow != shouldAge) {
                level.m_46597_(pos, (BlockState)state.m_61124_((Property)AGING, (Comparable)Boolean.valueOf(shouldAge)));
            }
        }
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder.m_61104_(new Property[]{COUNT, AGE, AGING}));
    }
}

