/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.region;

import net.dries007.tfc.world.layer.TFCLayers;
import net.dries007.tfc.world.layer.framework.Area;
import net.dries007.tfc.world.region.Region;
import net.dries007.tfc.world.region.RegionGenerator;
import net.dries007.tfc.world.region.RegionTask;

public enum ChooseBiomes implements RegionTask
{
    INSTANCE;

    private static final int[] MOUNTAIN_ALTITUDE_BIOMES;
    private static final int[] OCEANIC_MOUNTAIN_ALTITUDE_BIOMES;
    private static final int[] HIGH_ALTITUDE_BIOMES;
    private static final int[] MID_ALTITUDE_BIOMES;
    private static final int[] LOW_ALTITUDE_BIOMES;
    private static final int[] ISLAND_BIOMES;
    private static final int[] MID_DEPTH_OCEAN_BIOMES;

    @Override
    public void apply(RegionGenerator.Context context) {
        Region region = context.region;
        Area blobArea = context.generator().biomeArea.get();
        long rngSeed = context.random.nextLong();
        for (int dx = 0; dx < region.sizeX(); ++dx) {
            for (int dz = 0; dz < region.sizeZ(); ++dz) {
                int index = dx + region.sizeX() * dz;
                Region.Point point = region.data()[index];
                int areaSeed = blobArea.get(region.minX() + dx, region.minZ() + dz);
                if (point == null) continue;
                if (point.island()) {
                    point.biome = this.randomSeededFrom(rngSeed, areaSeed, ISLAND_BIOMES);
                } else if (point.mountain()) {
                    point.biome = this.randomSeededFrom(rngSeed, areaSeed, point.coastalMountain() ? OCEANIC_MOUNTAIN_ALTITUDE_BIOMES : MOUNTAIN_ALTITUDE_BIOMES);
                } else if (point.land()) {
                    point.biome = this.randomSeededFrom(rngSeed, areaSeed, switch (point.discreteBiomeAltitude()) {
                        case 2 -> HIGH_ALTITUDE_BIOMES;
                        case 1 -> MID_ALTITUDE_BIOMES;
                        case 0 -> LOW_ALTITUDE_BIOMES;
                        default -> throw new IllegalStateException("Invalid: " + point.discreteBiomeAltitude());
                    });
                } else {
                    point.biome = point.baseOceanDepth < 3 ? TFCLayers.OCEAN : (point.baseOceanDepth > 9 ? TFCLayers.DEEP_OCEAN_TRENCH : (point.baseOceanDepth >= 5 || point.distanceToEdge < 2 ? TFCLayers.DEEP_OCEAN : this.randomSeededFrom(rngSeed, areaSeed, MID_DEPTH_OCEAN_BIOMES)));
                }
                if (!point.lake() || !TFCLayers.hasLake(point.biome)) continue;
                point.biome = TFCLayers.lakeFor(point.biome);
            }
        }
    }

    private int randomSeededFrom(long rngSeed, int areaSeed, int[] choices) {
        return choices[Math.floorMod(rngSeed ^ (long)areaSeed, choices.length)];
    }

    static {
        MOUNTAIN_ALTITUDE_BIOMES = new int[]{TFCLayers.MOUNTAINS, TFCLayers.MOUNTAINS, TFCLayers.MOUNTAINS, TFCLayers.OLD_MOUNTAINS, TFCLayers.OLD_MOUNTAINS, TFCLayers.PLATEAU};
        OCEANIC_MOUNTAIN_ALTITUDE_BIOMES = new int[]{TFCLayers.VOLCANIC_MOUNTAINS, TFCLayers.VOLCANIC_OCEANIC_MOUNTAINS, TFCLayers.VOLCANIC_OCEANIC_MOUNTAINS, TFCLayers.OCEANIC_MOUNTAINS, TFCLayers.OCEANIC_MOUNTAINS, TFCLayers.ROLLING_HILLS};
        HIGH_ALTITUDE_BIOMES = new int[]{TFCLayers.HILLS, TFCLayers.ROLLING_HILLS, TFCLayers.ROLLING_HILLS, TFCLayers.INVERTED_BADLANDS, TFCLayers.BADLANDS, TFCLayers.PLATEAU, TFCLayers.PLATEAU, TFCLayers.OLD_MOUNTAINS, TFCLayers.OLD_MOUNTAINS};
        MID_ALTITUDE_BIOMES = new int[]{TFCLayers.PLAINS, TFCLayers.HILLS, TFCLayers.ROLLING_HILLS, TFCLayers.INVERTED_BADLANDS, TFCLayers.BADLANDS, TFCLayers.PLATEAU, TFCLayers.CANYONS, TFCLayers.LOW_CANYONS, TFCLayers.LOWLANDS};
        LOW_ALTITUDE_BIOMES = new int[]{TFCLayers.PLAINS, TFCLayers.PLAINS, TFCLayers.HILLS, TFCLayers.HILLS, TFCLayers.ROLLING_HILLS, TFCLayers.LOW_CANYONS, TFCLayers.LOWLANDS};
        ISLAND_BIOMES = new int[]{TFCLayers.PLAINS, TFCLayers.HILLS, TFCLayers.ROLLING_HILLS, TFCLayers.VOLCANIC_OCEANIC_MOUNTAINS, TFCLayers.VOLCANIC_OCEANIC_MOUNTAINS};
        MID_DEPTH_OCEAN_BIOMES = new int[]{TFCLayers.DEEP_OCEAN, TFCLayers.OCEAN, TFCLayers.OCEAN, TFCLayers.OCEAN_REEF, TFCLayers.OCEAN_REEF, TFCLayers.OCEAN_REEF};
    }
}

