/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.region;

import net.dries007.tfc.world.noise.Cellular2D;
import net.dries007.tfc.world.region.Region;
import net.dries007.tfc.world.region.RegionGenerator;
import net.dries007.tfc.world.region.RegionTask;

public enum AddContinents implements RegionTask
{
    INSTANCE;


    @Override
    public void apply(RegionGenerator.Context context) {
        for (int dx = -100; dx <= 100; ++dx) {
            for (int dz = -100; dz <= 100; ++dz) {
                int gridX = context.region.minX() + 100 + dx;
                int gridZ = context.region.minZ() + 100 + dz;
                Cellular2D.Cell otherCell = context.generator().sampleCell(gridX, gridZ);
                if (otherCell.x() != context.regionCell.x() || otherCell.y() != context.regionCell.y()) continue;
                Region.Point point = context.region.atInit(gridX, gridZ);
                float continent = context.generator().continentNoise.noise(gridX, gridZ);
                if ((double)continent > 4.4) {
                    point.setLand();
                }
                if (gridX < context.minX) {
                    context.minX = gridX;
                }
                if (gridZ < context.minZ) {
                    context.minZ = gridZ;
                }
                if (gridX > context.maxX) {
                    context.maxX = gridX;
                }
                if (gridZ <= context.maxZ) continue;
                context.maxZ = gridZ;
            }
        }
    }
}

