/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.carver;

import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blocks.soil.IDirtBlock;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.levelgen.Aquifer;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.WorldGenerationContext;
import net.minecraft.world.level.levelgen.carver.CarverConfiguration;
import net.minecraft.world.level.levelgen.carver.CarvingContext;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.jetbrains.annotations.Nullable;

public final class CarverHelpers {
    public static final BlockState AIR = Blocks.f_50627_.m_49966_();
    public static final FluidState WATER = Fluids.f_76193_.m_76145_();
    public static final FluidState LAVA = Fluids.f_76195_.m_76145_();

    public static <C extends CarverConfiguration> boolean carveBlock(CarvingContext context, C config, ChunkAccess chunk, BlockPos.MutableBlockPos pos, BlockPos.MutableBlockPos checkPos, Aquifer aquifer, MutableBoolean reachedSurface) {
        BlockState carvingState;
        BlockState stateAt = chunk.m_8055_((BlockPos)pos);
        if ((CarverHelpers.canReplaceBlock(stateAt) || CarverHelpers.isDebugEnabled(config)) && (carvingState = CarverHelpers.getCarveState(context, config, (BlockPos)pos, aquifer)) != null) {
            chunk.m_6978_((BlockPos)pos, carvingState, false);
            if (reachedSurface.isTrue()) {
                checkPos.m_122159_((Vec3i)pos, Direction.DOWN);
                Block block = chunk.m_8055_((BlockPos)checkPos).m_60734_();
                if (block instanceof IDirtBlock) {
                    IDirtBlock dirt = (IDirtBlock)block;
                    chunk.m_6978_((BlockPos)checkPos, dirt.getGrass(), false);
                }
            }
            return true;
        }
        return false;
    }

    public static boolean canReplaceBlock(BlockState state) {
        return Helpers.isBlock(state.m_60734_(), TFCTags.Blocks.CAN_CARVE);
    }

    @Nullable
    public static <C extends CarverConfiguration> BlockState getCarveState(CarvingContext context, C config, BlockPos pos, Aquifer aquifer) {
        if (pos.m_123342_() <= config.f_159090_.m_142322_((WorldGenerationContext)context)) {
            return LAVA.m_76188_();
        }
        BlockState carveState = aquifer.m_207104_((DensityFunction.FunctionContext)new DensityFunction.SinglePointContext(pos.m_123341_(), pos.m_123342_(), pos.m_123343_()), 0.0);
        if (carveState == null) {
            return CarverHelpers.isDebugEnabled(config) ? config.f_159092_.m_159148_() : null;
        }
        return CarverHelpers.isDebugEnabled(config) ? CarverHelpers.getDebugState(config, carveState) : carveState;
    }

    public static BlockState getDebugState(CarverConfiguration config, BlockState state) {
        if (Helpers.isBlock(state, Blocks.f_50016_)) {
            return config.f_159092_.m_159145_();
        }
        if (Helpers.isBlock(state, Blocks.f_49990_)) {
            BlockState debugState = config.f_159092_.m_159146_();
            return debugState.m_61138_((Property)BlockStateProperties.f_61362_) ? (BlockState)debugState.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(true)) : debugState;
        }
        return Helpers.isBlock(state, Blocks.f_49991_) ? config.f_159092_.m_159147_() : state;
    }

    public static boolean isDebugEnabled(CarverConfiguration config) {
        return config.f_159092_.m_159128_();
    }
}

