/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.biome;

import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.DoubleUnaryOperator;
import java.util.function.LongFunction;
import java.util.stream.Collectors;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.world.BiomeNoiseSampler;
import net.dries007.tfc.world.biome.TFCBiomes;
import net.dries007.tfc.world.surface.builder.SurfaceBuilder;
import net.dries007.tfc.world.surface.builder.SurfaceBuilderFactory;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import org.jetbrains.annotations.Nullable;

public class BiomeExtension {
    private final ResourceKey<Biome> key;
    private final LongFunction<BiomeNoiseSampler> noiseFactory;
    private final DoubleUnaryOperator aquiferSurfaceHeight;
    private final SurfaceBuilderFactory surfaceBuilderFactory;
    private final Group group;
    private final boolean salty;
    private final boolean volcanic;
    private final int volcanoRarity;
    private final int volcanoBasaltHeight;
    private final boolean spawnable;
    @Nullable
    private List<HolderSet<PlacedFeature>> flattenedFeatures;
    @Nullable
    private Set<PlacedFeature> flattenedFeatureSet;
    @Nullable
    private Biome prevBiome;

    BiomeExtension(ResourceKey<Biome> key, LongFunction<BiomeNoiseSampler> noiseFactory, SurfaceBuilderFactory surfaceBuilderFactory, DoubleUnaryOperator aquiferSurfaceHeight, Group group, boolean salty, boolean volcanic, int volcanoRarity, int volcanoBasaltHeight, boolean spawnable) {
        this.key = key;
        this.noiseFactory = noiseFactory;
        this.surfaceBuilderFactory = surfaceBuilderFactory;
        this.aquiferSurfaceHeight = aquiferSurfaceHeight;
        this.group = group;
        this.salty = salty;
        this.volcanic = volcanic;
        this.volcanoRarity = volcanoRarity;
        this.volcanoBasaltHeight = volcanoBasaltHeight;
        this.spawnable = spawnable;
    }

    public ResourceKey<Biome> key() {
        return this.key;
    }

    public Group getGroup() {
        return this.group;
    }

    public boolean isRiver() {
        return this.group == Group.RIVER;
    }

    public boolean isShore() {
        return this == TFCBiomes.SHORE;
    }

    public boolean isSalty() {
        return this.salty;
    }

    public boolean isVolcanic() {
        return this.volcanic;
    }

    public boolean isSpawnable() {
        return this.spawnable;
    }

    public int getVolcanoRarity() {
        return this.volcanoRarity;
    }

    public int getVolcanoBasaltHeight() {
        return this.volcanoBasaltHeight;
    }

    public double getAquiferSurfaceHeight(double height) {
        return this.aquiferSurfaceHeight.applyAsDouble(height);
    }

    public BiomeNoiseSampler createNoiseSampler(long seed) {
        return this.noiseFactory.apply(seed);
    }

    public SurfaceBuilder createSurfaceBuilder(long seed) {
        return this.surfaceBuilderFactory.apply(seed);
    }

    public List<HolderSet<PlacedFeature>> getFlattenedFeatures(Biome biome) {
        if (biome != this.prevBiome) {
            this.prevBiome = biome;
            this.flattenedFeatures = null;
        }
        if (this.flattenedFeatures == null) {
            this.flattenedFeatures = Helpers.flattenTopLevelMultipleFeature(biome.m_47536_());
            this.flattenedFeatureSet = this.flattenedFeatures.stream().flatMap(HolderSet::m_203614_).map(Holder::m_203334_).collect(Collectors.toSet());
        }
        return this.flattenedFeatures;
    }

    public Set<PlacedFeature> getFlattenedFeatureSet(Biome biome) {
        this.getFlattenedFeatures(biome);
        return Objects.requireNonNull(this.flattenedFeatureSet);
    }

    public static enum Group {
        LAND,
        OCEAN,
        RIVER,
        LAKE;

        public static final int SIZE;

        static {
            SIZE = Group.values().length;
        }
    }
}

