/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.biome;

import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.DoubleUnaryOperator;
import java.util.function.LongFunction;
import net.dries007.tfc.world.BiomeNoiseSampler;
import net.dries007.tfc.world.biome.BiomeExtension;
import net.dries007.tfc.world.biome.BiomeNoise;
import net.dries007.tfc.world.noise.Noise2D;
import net.dries007.tfc.world.surface.builder.SurfaceBuilderFactory;
import net.dries007.tfc.world.surface.builder.VolcanoesSurfaceBuilder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.Biome;
import org.jetbrains.annotations.Nullable;

public class BiomeBuilder {
    @Nullable
    private LongFunction<Noise2D> heightNoiseFactory;
    @Nullable
    private LongFunction<BiomeNoiseSampler> noiseFactory;
    @Nullable
    private SurfaceBuilderFactory surfaceBuilderFactory;
    private DoubleUnaryOperator aquiferSurfaceHeight = height -> height;
    private BiomeExtension.Group group = BiomeExtension.Group.LAND;
    private boolean salty = false;
    private boolean volcanic = false;
    private int volcanoFrequency = 0;
    private int volcanoBasaltHeight = 0;
    private boolean spawnable = false;

    public static BiomeBuilder builder() {
        return new BiomeBuilder();
    }

    private BiomeBuilder() {
    }

    public BiomeBuilder heightmap(LongFunction<Noise2D> heightNoiseFactory) {
        this.heightNoiseFactory = heightNoiseFactory;
        this.noiseFactory = seed -> BiomeNoiseSampler.fromHeightNoise((Noise2D)heightNoiseFactory.apply(seed));
        return this;
    }

    public BiomeBuilder surface(SurfaceBuilderFactory surfaceBuilderFactory) {
        this.surfaceBuilderFactory = surfaceBuilderFactory;
        return this;
    }

    public BiomeBuilder carving(BiFunction<Long, Noise2D, BiomeNoiseSampler> carvingNoiseFactory) {
        Objects.requireNonNull(this.heightNoiseFactory, "Height noise must not be null");
        LongFunction<Noise2D> baseHeightNoiseFactory = this.heightNoiseFactory;
        this.noiseFactory = seed -> (BiomeNoiseSampler)carvingNoiseFactory.apply(seed, (Noise2D)baseHeightNoiseFactory.apply(seed));
        this.aquiferSurfaceHeight = height -> 47.0;
        return this;
    }

    public BiomeBuilder noise(LongFunction<BiomeNoiseSampler> noiseFactory) {
        this.noiseFactory = noiseFactory;
        return this;
    }

    public BiomeBuilder aquiferHeightOffset(double delta) {
        return this.aquiferHeight(height -> height + delta);
    }

    public BiomeBuilder aquiferHeight(DoubleUnaryOperator aquiferSurfaceHeight) {
        this.aquiferSurfaceHeight = aquiferSurfaceHeight;
        return this;
    }

    public BiomeBuilder group(BiomeExtension.Group group) {
        this.group = group;
        return this;
    }

    public BiomeBuilder salty() {
        this.salty = true;
        return this;
    }

    public BiomeBuilder spawnable() {
        this.spawnable = true;
        return this;
    }

    public BiomeBuilder volcanoes(int frequency, int baseHeight, int scaleHeight, int volcanoBasaltHeight) {
        this.volcanic = true;
        this.volcanoFrequency = frequency;
        this.volcanoBasaltHeight = 63 + volcanoBasaltHeight;
        assert (this.heightNoiseFactory != null) : "volcanoes must be called after setting a heightmap";
        assert (this.surfaceBuilderFactory != null) : "volcanoes must be called after setting a surface builder";
        LongFunction<Noise2D> baseHeightNoiseFactory = this.heightNoiseFactory;
        this.heightNoiseFactory = seed -> BiomeNoise.addVolcanoes(seed, (Noise2D)baseHeightNoiseFactory.apply(seed), frequency, baseHeight, scaleHeight);
        this.noiseFactory = seed -> BiomeNoiseSampler.fromHeightNoise(this.heightNoiseFactory.apply(seed));
        this.surfaceBuilderFactory = VolcanoesSurfaceBuilder.create(this.surfaceBuilderFactory);
        return this;
    }

    public BiomeExtension build(ResourceKey<Biome> key) {
        assert (this.noiseFactory != null) : "missing noise / heightmap";
        assert (this.surfaceBuilderFactory != null) : "missing surface builder";
        return new BiomeExtension(key, this.noiseFactory, this.surfaceBuilderFactory, this.aquiferSurfaceHeight, this.group, this.salty, this.volcanic, this.volcanoFrequency, this.volcanoBasaltHeight, this.spawnable);
    }
}

